@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.EncryptionArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.enums.KeySource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties to configure Encryption
 * @property keySource Enumerates the possible value of keySource for Encryption
 * @property keyVaultProperties Properties of KeyVault
 */
public data class EncryptionArgs(
    public val keySource: Output<Either<String, KeySource>>? = null,
    public val keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.EncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.EncryptionArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.EncryptionArgs.builder()
            .keySource(
                keySource?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [EncryptionArgs].
 */
@PulumiTagMarker
public class EncryptionArgsBuilder internal constructor() {
    private var keySource: Output<Either<String, KeySource>>? = null

    private var keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null

    /**
     * @param value Enumerates the possible value of keySource for Encryption
     */
    @JvmName("yixxgstwyjpgoaji")
    public suspend fun keySource(`value`: Output<Either<String, KeySource>>) {
        this.keySource = value
    }

    /**
     * @param value Properties of KeyVault
     */
    @JvmName("wqgxndmwdrjqspdx")
    public suspend fun keyVaultProperties(`value`: Output<KeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value Enumerates the possible value of keySource for Encryption
     */
    @JvmName("tdogwosgihanmxvw")
    public suspend fun keySource(`value`: Either<String, KeySource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value Enumerates the possible value of keySource for Encryption
     */
    @JvmName("hgjvudquhbsmrcay")
    public fun keySource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value Enumerates the possible value of keySource for Encryption
     */
    @JvmName("blpwhvsdajocytgp")
    public fun keySource(`value`: KeySource) {
        val toBeMapped = Either.ofRight<String, KeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value Properties of KeyVault
     */
    @JvmName("vvrtoyodyvyucycn")
    public suspend fun keyVaultProperties(`value`: KeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Properties of KeyVault
     */
    @JvmName("qrwqxtujdhesugff")
    public suspend
    fun keyVaultProperties(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    internal fun build(): EncryptionArgs = EncryptionArgs(
        keySource = keySource,
        keyVaultProperties = keyVaultProperties,
    )
}
