@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.EncryptionScopePropertiesArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.enums.EncryptionScopeState
import com.pulumi.azurenative.cognitiveservices.kotlin.enums.KeySource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties to EncryptionScope
 * @property keySource Enumerates the possible value of keySource for Encryption
 * @property keyVaultProperties Properties of KeyVault
 * @property state The encryptionScope state.
 */
public data class EncryptionScopePropertiesArgs(
    public val keySource: Output<Either<String, KeySource>>? = null,
    public val keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null,
    public val state: Output<Either<String, EncryptionScopeState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.EncryptionScopePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.cognitiveservices.inputs.EncryptionScopePropertiesArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.EncryptionScopePropertiesArgs.builder()
            .keySource(
                keySource?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EncryptionScopePropertiesArgs].
 */
@PulumiTagMarker
public class EncryptionScopePropertiesArgsBuilder internal constructor() {
    private var keySource: Output<Either<String, KeySource>>? = null

    private var keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null

    private var state: Output<Either<String, EncryptionScopeState>>? = null

    /**
     * @param value Enumerates the possible value of keySource for Encryption
     */
    @JvmName("mpvjtnvniqfrlery")
    public suspend fun keySource(`value`: Output<Either<String, KeySource>>) {
        this.keySource = value
    }

    /**
     * @param value Properties of KeyVault
     */
    @JvmName("mdakpwdilbqqefak")
    public suspend fun keyVaultProperties(`value`: Output<KeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value The encryptionScope state.
     */
    @JvmName("iuhmkpidmdjncend")
    public suspend fun state(`value`: Output<Either<String, EncryptionScopeState>>) {
        this.state = value
    }

    /**
     * @param value Enumerates the possible value of keySource for Encryption
     */
    @JvmName("mfqlsooumqdnowlx")
    public suspend fun keySource(`value`: Either<String, KeySource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value Enumerates the possible value of keySource for Encryption
     */
    @JvmName("faqpbspxqawombta")
    public fun keySource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value Enumerates the possible value of keySource for Encryption
     */
    @JvmName("rsionqjscejkfsed")
    public fun keySource(`value`: KeySource) {
        val toBeMapped = Either.ofRight<String, KeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value Properties of KeyVault
     */
    @JvmName("hkjhotpnguvepqhi")
    public suspend fun keyVaultProperties(`value`: KeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Properties of KeyVault
     */
    @JvmName("nssmfwfywnbnchwi")
    public suspend
    fun keyVaultProperties(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param value The encryptionScope state.
     */
    @JvmName("nloexijcspnawokc")
    public suspend fun state(`value`: Either<String, EncryptionScopeState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The encryptionScope state.
     */
    @JvmName("lxuwbulnsjwydopp")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionScopeState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The encryptionScope state.
     */
    @JvmName("htorjywpxbqhinpe")
    public fun state(`value`: EncryptionScopeState) {
        val toBeMapped = Either.ofRight<String, EncryptionScopeState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): EncryptionScopePropertiesArgs = EncryptionScopePropertiesArgs(
        keySource = keySource,
        keyVaultProperties = keyVaultProperties,
        state = state,
    )
}
