@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.GetCommitmentPlanPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of Cognitive Services account.
 * @property commitmentPlanName The name of the commitmentPlan associated with the Cognitive Services Account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCommitmentPlanPlainArgs(
    public val accountName: String,
    public val commitmentPlanName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.GetCommitmentPlanPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.GetCommitmentPlanPlainArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.GetCommitmentPlanPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .commitmentPlanName(commitmentPlanName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCommitmentPlanPlainArgs].
 */
@PulumiTagMarker
public class GetCommitmentPlanPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var commitmentPlanName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("xcltgmykjwxmhmxb")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the commitmentPlan associated with the Cognitive Services Account
     */
    @JvmName("ovuyaapdstunlxfi")
    public suspend fun commitmentPlanName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.commitmentPlanName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yvbgddnjbmblgrao")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCommitmentPlanPlainArgs = GetCommitmentPlanPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        commitmentPlanName = commitmentPlanName ?: throw PulumiNullFieldException("commitmentPlanName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
