@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.GetDeploymentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of Cognitive Services account.
 * @property deploymentName The name of the deployment associated with the Cognitive Services Account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDeploymentPlainArgs(
    public val accountName: String,
    public val deploymentName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.GetDeploymentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.GetDeploymentPlainArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.GetDeploymentPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .deploymentName(deploymentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeploymentPlainArgs].
 */
@PulumiTagMarker
public class GetDeploymentPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var deploymentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("jfdimqccanqqqnyk")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the deployment associated with the Cognitive Services Account
     */
    @JvmName("mgjatvnqpocqnoxw")
    public suspend fun deploymentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tnhjqwhugsibuijn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDeploymentPlainArgs = GetDeploymentPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        deploymentName = deploymentName ?: throw PulumiNullFieldException("deploymentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
