@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.RaiPolicyPropertiesArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.enums.RaiPolicyMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure OpenAI Content Filters properties.
 * @property basePolicyName Name of the base Content Filters.
 * @property completionBlocklists The list of blocklists for completion.
 * @property contentFilters The list of Content Filters.
 * @property mode Content Filters mode.
 * @property promptBlocklists The list of blocklists for prompt.
 */
public data class RaiPolicyPropertiesArgs(
    public val basePolicyName: Output<String>? = null,
    public val completionBlocklists: Output<List<RaiBlocklistConfigArgs>>? = null,
    public val contentFilters: Output<List<RaiPolicyContentFilterArgs>>? = null,
    public val mode: Output<Either<String, RaiPolicyMode>>? = null,
    public val promptBlocklists: Output<List<RaiBlocklistConfigArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.RaiPolicyPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.RaiPolicyPropertiesArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.RaiPolicyPropertiesArgs.builder()
            .basePolicyName(basePolicyName?.applyValue({ args0 -> args0 }))
            .completionBlocklists(
                completionBlocklists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .contentFilters(
                contentFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .promptBlocklists(
                promptBlocklists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RaiPolicyPropertiesArgs].
 */
@PulumiTagMarker
public class RaiPolicyPropertiesArgsBuilder internal constructor() {
    private var basePolicyName: Output<String>? = null

    private var completionBlocklists: Output<List<RaiBlocklistConfigArgs>>? = null

    private var contentFilters: Output<List<RaiPolicyContentFilterArgs>>? = null

    private var mode: Output<Either<String, RaiPolicyMode>>? = null

    private var promptBlocklists: Output<List<RaiBlocklistConfigArgs>>? = null

    /**
     * @param value Name of the base Content Filters.
     */
    @JvmName("sokqsuqqxgpeiihi")
    public suspend fun basePolicyName(`value`: Output<String>) {
        this.basePolicyName = value
    }

    /**
     * @param value The list of blocklists for completion.
     */
    @JvmName("svyninldanwjywdr")
    public suspend fun completionBlocklists(`value`: Output<List<RaiBlocklistConfigArgs>>) {
        this.completionBlocklists = value
    }

    @JvmName("cxarunfpbevmrrut")
    public suspend fun completionBlocklists(vararg values: Output<RaiBlocklistConfigArgs>) {
        this.completionBlocklists = Output.all(values.asList())
    }

    /**
     * @param values The list of blocklists for completion.
     */
    @JvmName("mhefnjrpymbntbju")
    public suspend fun completionBlocklists(values: List<Output<RaiBlocklistConfigArgs>>) {
        this.completionBlocklists = Output.all(values)
    }

    /**
     * @param value The list of Content Filters.
     */
    @JvmName("kcqxumgfgaocrccn")
    public suspend fun contentFilters(`value`: Output<List<RaiPolicyContentFilterArgs>>) {
        this.contentFilters = value
    }

    @JvmName("kxnewnfimtmyqbkt")
    public suspend fun contentFilters(vararg values: Output<RaiPolicyContentFilterArgs>) {
        this.contentFilters = Output.all(values.asList())
    }

    /**
     * @param values The list of Content Filters.
     */
    @JvmName("wxwlqlwihavedpah")
    public suspend fun contentFilters(values: List<Output<RaiPolicyContentFilterArgs>>) {
        this.contentFilters = Output.all(values)
    }

    /**
     * @param value Content Filters mode.
     */
    @JvmName("oragqqloerlspnqq")
    public suspend fun mode(`value`: Output<Either<String, RaiPolicyMode>>) {
        this.mode = value
    }

    /**
     * @param value The list of blocklists for prompt.
     */
    @JvmName("htnvfqbisjarscxe")
    public suspend fun promptBlocklists(`value`: Output<List<RaiBlocklistConfigArgs>>) {
        this.promptBlocklists = value
    }

    @JvmName("fqgykicpyqpdslge")
    public suspend fun promptBlocklists(vararg values: Output<RaiBlocklistConfigArgs>) {
        this.promptBlocklists = Output.all(values.asList())
    }

    /**
     * @param values The list of blocklists for prompt.
     */
    @JvmName("unnyodalblxlpscq")
    public suspend fun promptBlocklists(values: List<Output<RaiBlocklistConfigArgs>>) {
        this.promptBlocklists = Output.all(values)
    }

    /**
     * @param value Name of the base Content Filters.
     */
    @JvmName("dxesmqnyrlcttpav")
    public suspend fun basePolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basePolicyName = mapped
    }

    /**
     * @param value The list of blocklists for completion.
     */
    @JvmName("gppgfpolakbwblyq")
    public suspend fun completionBlocklists(`value`: List<RaiBlocklistConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.completionBlocklists = mapped
    }

    /**
     * @param argument The list of blocklists for completion.
     */
    @JvmName("nmwwlgygsfqmkvkj")
    public suspend
    fun completionBlocklists(argument: List<suspend RaiBlocklistConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RaiBlocklistConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.completionBlocklists = mapped
    }

    /**
     * @param argument The list of blocklists for completion.
     */
    @JvmName("jfukrstiueohvmtf")
    public suspend fun completionBlocklists(
        vararg
        argument: suspend RaiBlocklistConfigArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RaiBlocklistConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.completionBlocklists = mapped
    }

    /**
     * @param argument The list of blocklists for completion.
     */
    @JvmName("uhstkgrvecoawcsh")
    public suspend
    fun completionBlocklists(argument: suspend RaiBlocklistConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RaiBlocklistConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.completionBlocklists = mapped
    }

    /**
     * @param values The list of blocklists for completion.
     */
    @JvmName("tjxsvlcbndksyrsc")
    public suspend fun completionBlocklists(vararg values: RaiBlocklistConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.completionBlocklists = mapped
    }

    /**
     * @param value The list of Content Filters.
     */
    @JvmName("soxullcjawprrxil")
    public suspend fun contentFilters(`value`: List<RaiPolicyContentFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentFilters = mapped
    }

    /**
     * @param argument The list of Content Filters.
     */
    @JvmName("xnwxayuttybbmiwt")
    public suspend
    fun contentFilters(argument: List<suspend RaiPolicyContentFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RaiPolicyContentFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.contentFilters = mapped
    }

    /**
     * @param argument The list of Content Filters.
     */
    @JvmName("dgmmqqdjxooyldsi")
    public suspend fun contentFilters(
        vararg
        argument: suspend RaiPolicyContentFilterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RaiPolicyContentFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.contentFilters = mapped
    }

    /**
     * @param argument The list of Content Filters.
     */
    @JvmName("jneemhhkfrryyawu")
    public suspend
    fun contentFilters(argument: suspend RaiPolicyContentFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RaiPolicyContentFilterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.contentFilters = mapped
    }

    /**
     * @param values The list of Content Filters.
     */
    @JvmName("fpmmjqxmwdflurtq")
    public suspend fun contentFilters(vararg values: RaiPolicyContentFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentFilters = mapped
    }

    /**
     * @param value Content Filters mode.
     */
    @JvmName("sxkrxmqfxwummkfy")
    public suspend fun mode(`value`: Either<String, RaiPolicyMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Content Filters mode.
     */
    @JvmName("gijbgbrpnnauokvt")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RaiPolicyMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Content Filters mode.
     */
    @JvmName("getcjoqorkaiygcv")
    public fun mode(`value`: RaiPolicyMode) {
        val toBeMapped = Either.ofRight<String, RaiPolicyMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The list of blocklists for prompt.
     */
    @JvmName("jabjywkvfejptaoj")
    public suspend fun promptBlocklists(`value`: List<RaiBlocklistConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promptBlocklists = mapped
    }

    /**
     * @param argument The list of blocklists for prompt.
     */
    @JvmName("rfnrtbgeihorkwbf")
    public suspend
    fun promptBlocklists(argument: List<suspend RaiBlocklistConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RaiBlocklistConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.promptBlocklists = mapped
    }

    /**
     * @param argument The list of blocklists for prompt.
     */
    @JvmName("tvohyhwgjlpymojl")
    public suspend fun promptBlocklists(
        vararg
        argument: suspend RaiBlocklistConfigArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RaiBlocklistConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.promptBlocklists = mapped
    }

    /**
     * @param argument The list of blocklists for prompt.
     */
    @JvmName("pjvvqocdbgpkwqye")
    public suspend fun promptBlocklists(argument: suspend RaiBlocklistConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RaiBlocklistConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.promptBlocklists = mapped
    }

    /**
     * @param values The list of blocklists for prompt.
     */
    @JvmName("kjourrosmeknpdwp")
    public suspend fun promptBlocklists(vararg values: RaiBlocklistConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.promptBlocklists = mapped
    }

    internal fun build(): RaiPolicyPropertiesArgs = RaiPolicyPropertiesArgs(
        basePolicyName = basePolicyName,
        completionBlocklists = completionBlocklists,
        contentFilters = contentFilters,
        mode = mode,
        promptBlocklists = promptBlocklists,
    )
}
