@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Cognitive Services account commitment quota.
 * @property quantity Commitment quota quantity.
 * @property unit Commitment quota unit.
 */
public data class CommitmentQuotaResponse(
    public val quantity: Double? = null,
    public val unit: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.CommitmentQuotaResponse):
            CommitmentQuotaResponse = CommitmentQuotaResponse(
            quantity = javaType.quantity().map({ args0 -> args0 }).orElse(null),
            unit = javaType.unit().map({ args0 -> args0 }).orElse(null),
        )
    }
}
