@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of Cognitive Services account deployment model.
 * @property callRateLimit The call rate limit Cognitive Services account.
 * @property format Deployment model format.
 * @property name Deployment model name.
 * @property source Optional. Deployment model source ARM resource ID.
 * @property version Optional. Deployment model version. If version is not specified, a default version will be assigned. The default version is different for different models and might change when there is new version available for a model. Default version for a model could be found from list models API.
 */
public data class DeploymentModelResponse(
    public val callRateLimit: CallRateLimitResponse,
    public val format: String? = null,
    public val name: String? = null,
    public val source: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.DeploymentModelResponse):
            DeploymentModelResponse = DeploymentModelResponse(
            callRateLimit = javaType.callRateLimit().let({ args0 ->
                com.pulumi.azurenative.cognitiveservices.kotlin.outputs.CallRateLimitResponse.Companion.toKotlin(args0)
            }),
            format = javaType.format().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
