@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The commitment plan association.
 * @property accountId The Azure resource id of the account.
 * @property etag Resource Etag.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetCommitmentPlanAssociationResult(
    public val accountId: String? = null,
    public val etag: String,
    public val id: String,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.GetCommitmentPlanAssociationResult):
            GetCommitmentPlanAssociationResult = GetCommitmentPlanAssociationResult(
            accountId = javaType.accountId().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
