@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The multiregion settings Cognitive Services account.
 * @property regions
 * @property routingMethod Multiregion routing methods.
 */
public data class MultiRegionSettingsResponse(
    public val regions: List<RegionSettingResponse>? = null,
    public val routingMethod: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.MultiRegionSettingsResponse):
            MultiRegionSettingsResponse = MultiRegionSettingsResponse(
            regions = javaType.regions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.RegionSettingResponse.Companion.toKotlin(args0)
                })
            }),
            routingMethod = javaType.routingMethod().map({ args0 -> args0 }).orElse(null),
        )
    }
}
