@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.Double
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property count
 * @property renewalPeriod
 * @property rules
 */
public data class QuotaLimitResponse(
    public val count: Double? = null,
    public val renewalPeriod: Double? = null,
    public val rules: List<ThrottlingRuleResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.QuotaLimitResponse):
            QuotaLimitResponse = QuotaLimitResponse(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            renewalPeriod = javaType.renewalPeriod().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.ThrottlingRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
