@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin

import com.pulumi.azurenative.communication.CommunicationFunctions.getCommunicationServicePlain
import com.pulumi.azurenative.communication.CommunicationFunctions.getDomainPlain
import com.pulumi.azurenative.communication.CommunicationFunctions.getEmailServicePlain
import com.pulumi.azurenative.communication.CommunicationFunctions.getSenderUsernamePlain
import com.pulumi.azurenative.communication.CommunicationFunctions.getSuppressionListAddressPlain
import com.pulumi.azurenative.communication.CommunicationFunctions.getSuppressionListPlain
import com.pulumi.azurenative.communication.CommunicationFunctions.listCommunicationServiceKeysPlain
import com.pulumi.azurenative.communication.kotlin.inputs.GetCommunicationServicePlainArgs
import com.pulumi.azurenative.communication.kotlin.inputs.GetCommunicationServicePlainArgsBuilder
import com.pulumi.azurenative.communication.kotlin.inputs.GetDomainPlainArgs
import com.pulumi.azurenative.communication.kotlin.inputs.GetDomainPlainArgsBuilder
import com.pulumi.azurenative.communication.kotlin.inputs.GetEmailServicePlainArgs
import com.pulumi.azurenative.communication.kotlin.inputs.GetEmailServicePlainArgsBuilder
import com.pulumi.azurenative.communication.kotlin.inputs.GetSenderUsernamePlainArgs
import com.pulumi.azurenative.communication.kotlin.inputs.GetSenderUsernamePlainArgsBuilder
import com.pulumi.azurenative.communication.kotlin.inputs.GetSuppressionListAddressPlainArgs
import com.pulumi.azurenative.communication.kotlin.inputs.GetSuppressionListAddressPlainArgsBuilder
import com.pulumi.azurenative.communication.kotlin.inputs.GetSuppressionListPlainArgs
import com.pulumi.azurenative.communication.kotlin.inputs.GetSuppressionListPlainArgsBuilder
import com.pulumi.azurenative.communication.kotlin.inputs.ListCommunicationServiceKeysPlainArgs
import com.pulumi.azurenative.communication.kotlin.inputs.ListCommunicationServiceKeysPlainArgsBuilder
import com.pulumi.azurenative.communication.kotlin.outputs.GetCommunicationServiceResult
import com.pulumi.azurenative.communication.kotlin.outputs.GetDomainResult
import com.pulumi.azurenative.communication.kotlin.outputs.GetEmailServiceResult
import com.pulumi.azurenative.communication.kotlin.outputs.GetSenderUsernameResult
import com.pulumi.azurenative.communication.kotlin.outputs.GetSuppressionListAddressResult
import com.pulumi.azurenative.communication.kotlin.outputs.GetSuppressionListResult
import com.pulumi.azurenative.communication.kotlin.outputs.ListCommunicationServiceKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.communication.kotlin.outputs.GetCommunicationServiceResult.Companion.toKotlin as getCommunicationServiceResultToKotlin
import com.pulumi.azurenative.communication.kotlin.outputs.GetDomainResult.Companion.toKotlin as getDomainResultToKotlin
import com.pulumi.azurenative.communication.kotlin.outputs.GetEmailServiceResult.Companion.toKotlin as getEmailServiceResultToKotlin
import com.pulumi.azurenative.communication.kotlin.outputs.GetSenderUsernameResult.Companion.toKotlin as getSenderUsernameResultToKotlin
import com.pulumi.azurenative.communication.kotlin.outputs.GetSuppressionListAddressResult.Companion.toKotlin as getSuppressionListAddressResultToKotlin
import com.pulumi.azurenative.communication.kotlin.outputs.GetSuppressionListResult.Companion.toKotlin as getSuppressionListResultToKotlin
import com.pulumi.azurenative.communication.kotlin.outputs.ListCommunicationServiceKeysResult.Companion.toKotlin as listCommunicationServiceKeysResultToKotlin

public object CommunicationFunctions {
    /**
     * Get the CommunicationService and its properties.
     * Azure REST API version: 2023-03-31.
     * Other available API versions: 2023-04-01, 2023-04-01-preview, 2023-06-01-preview.
     * @param argument null
     * @return A class representing a CommunicationService resource.
     */
    public suspend fun getCommunicationService(argument: GetCommunicationServicePlainArgs):
        GetCommunicationServiceResult =
        getCommunicationServiceResultToKotlin(getCommunicationServicePlain(argument.toJava()).await())

    /**
     * @see [getCommunicationService].
     * @param communicationServiceName The name of the CommunicationService resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A class representing a CommunicationService resource.
     */
    public suspend fun getCommunicationService(
        communicationServiceName: String,
        resourceGroupName: String,
    ): GetCommunicationServiceResult {
        val argument = GetCommunicationServicePlainArgs(
            communicationServiceName = communicationServiceName,
            resourceGroupName = resourceGroupName,
        )
        return getCommunicationServiceResultToKotlin(getCommunicationServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getCommunicationService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;communication&#46;kotlin&#46;inputs&#46;GetCommunicationServicePlainArgs].
     * @return A class representing a CommunicationService resource.
     */
    public suspend
    fun getCommunicationService(argument: suspend GetCommunicationServicePlainArgsBuilder.() -> Unit):
        GetCommunicationServiceResult {
        val builder = GetCommunicationServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCommunicationServiceResultToKotlin(getCommunicationServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Domains resource and its properties.
     * Azure REST API version: 2023-03-31.
     * Other available API versions: 2022-07-01-preview, 2023-04-01, 2023-04-01-preview, 2023-06-01-preview.
     * @param argument null
     * @return A class representing a Domains resource.
     */
    public suspend fun getDomain(argument: GetDomainPlainArgs): GetDomainResult =
        getDomainResultToKotlin(getDomainPlain(argument.toJava()).await())

    /**
     * @see [getDomain].
     * @param domainName The name of the Domains resource.
     * @param emailServiceName The name of the EmailService resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A class representing a Domains resource.
     */
    public suspend fun getDomain(
        domainName: String,
        emailServiceName: String,
        resourceGroupName: String,
    ): GetDomainResult {
        val argument = GetDomainPlainArgs(
            domainName = domainName,
            emailServiceName = emailServiceName,
            resourceGroupName = resourceGroupName,
        )
        return getDomainResultToKotlin(getDomainPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomain].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;communication&#46;kotlin&#46;inputs&#46;GetDomainPlainArgs].
     * @return A class representing a Domains resource.
     */
    public suspend fun getDomain(argument: suspend GetDomainPlainArgsBuilder.() -> Unit):
        GetDomainResult {
        val builder = GetDomainPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainResultToKotlin(getDomainPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the EmailService and its properties.
     * Azure REST API version: 2023-03-31.
     * Other available API versions: 2023-04-01, 2023-04-01-preview, 2023-06-01-preview.
     * @param argument null
     * @return A class representing an EmailService resource.
     */
    public suspend fun getEmailService(argument: GetEmailServicePlainArgs): GetEmailServiceResult =
        getEmailServiceResultToKotlin(getEmailServicePlain(argument.toJava()).await())

    /**
     * @see [getEmailService].
     * @param emailServiceName The name of the EmailService resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A class representing an EmailService resource.
     */
    public suspend fun getEmailService(emailServiceName: String, resourceGroupName: String):
        GetEmailServiceResult {
        val argument = GetEmailServicePlainArgs(
            emailServiceName = emailServiceName,
            resourceGroupName = resourceGroupName,
        )
        return getEmailServiceResultToKotlin(getEmailServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getEmailService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;communication&#46;kotlin&#46;inputs&#46;GetEmailServicePlainArgs].
     * @return A class representing an EmailService resource.
     */
    public suspend fun getEmailService(argument: suspend GetEmailServicePlainArgsBuilder.() -> Unit):
        GetEmailServiceResult {
        val builder = GetEmailServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEmailServiceResultToKotlin(getEmailServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a valid sender username for a domains resource.
     * Azure REST API version: 2023-03-31.
     * Other available API versions: 2023-04-01, 2023-04-01-preview, 2023-06-01-preview.
     * @param argument null
     * @return A class representing a SenderUsername resource.
     */
    public suspend fun getSenderUsername(argument: GetSenderUsernamePlainArgs):
        GetSenderUsernameResult =
        getSenderUsernameResultToKotlin(getSenderUsernamePlain(argument.toJava()).await())

    /**
     * @see [getSenderUsername].
     * @param domainName The name of the Domains resource.
     * @param emailServiceName The name of the EmailService resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param senderUsername The valid sender Username.
     * @return A class representing a SenderUsername resource.
     */
    public suspend fun getSenderUsername(
        domainName: String,
        emailServiceName: String,
        resourceGroupName: String,
        senderUsername: String,
    ): GetSenderUsernameResult {
        val argument = GetSenderUsernamePlainArgs(
            domainName = domainName,
            emailServiceName = emailServiceName,
            resourceGroupName = resourceGroupName,
            senderUsername = senderUsername,
        )
        return getSenderUsernameResultToKotlin(getSenderUsernamePlain(argument.toJava()).await())
    }

    /**
     * @see [getSenderUsername].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;communication&#46;kotlin&#46;inputs&#46;GetSenderUsernamePlainArgs].
     * @return A class representing a SenderUsername resource.
     */
    public suspend
    fun getSenderUsername(argument: suspend GetSenderUsernamePlainArgsBuilder.() -> Unit):
        GetSenderUsernameResult {
        val builder = GetSenderUsernamePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSenderUsernameResultToKotlin(getSenderUsernamePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a SuppressionList resource.
     * Azure REST API version: 2023-06-01-preview.
     * @param argument null
     * @return A class representing a SuppressionList resource.
     */
    public suspend fun getSuppressionList(argument: GetSuppressionListPlainArgs):
        GetSuppressionListResult =
        getSuppressionListResultToKotlin(getSuppressionListPlain(argument.toJava()).await())

    /**
     * @see [getSuppressionList].
     * @param domainName The name of the Domains resource.
     * @param emailServiceName The name of the EmailService resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param suppressionListName The name of the suppression list.
     * @return A class representing a SuppressionList resource.
     */
    public suspend fun getSuppressionList(
        domainName: String,
        emailServiceName: String,
        resourceGroupName: String,
        suppressionListName: String,
    ): GetSuppressionListResult {
        val argument = GetSuppressionListPlainArgs(
            domainName = domainName,
            emailServiceName = emailServiceName,
            resourceGroupName = resourceGroupName,
            suppressionListName = suppressionListName,
        )
        return getSuppressionListResultToKotlin(getSuppressionListPlain(argument.toJava()).await())
    }

    /**
     * @see [getSuppressionList].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;communication&#46;kotlin&#46;inputs&#46;GetSuppressionListPlainArgs].
     * @return A class representing a SuppressionList resource.
     */
    public suspend
    fun getSuppressionList(argument: suspend GetSuppressionListPlainArgsBuilder.() -> Unit):
        GetSuppressionListResult {
        val builder = GetSuppressionListPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSuppressionListResultToKotlin(getSuppressionListPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a SuppressionListAddress.
     * Azure REST API version: 2023-06-01-preview.
     * @param argument null
     * @return A object that represents a SuppressionList record.
     */
    public suspend fun getSuppressionListAddress(argument: GetSuppressionListAddressPlainArgs):
        GetSuppressionListAddressResult =
        getSuppressionListAddressResultToKotlin(getSuppressionListAddressPlain(argument.toJava()).await())

    /**
     * @see [getSuppressionListAddress].
     * @param addressId The id of the address in a suppression list.
     * @param domainName The name of the Domains resource.
     * @param emailServiceName The name of the EmailService resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param suppressionListName The name of the suppression list.
     * @return A object that represents a SuppressionList record.
     */
    public suspend fun getSuppressionListAddress(
        addressId: String,
        domainName: String,
        emailServiceName: String,
        resourceGroupName: String,
        suppressionListName: String,
    ): GetSuppressionListAddressResult {
        val argument = GetSuppressionListAddressPlainArgs(
            addressId = addressId,
            domainName = domainName,
            emailServiceName = emailServiceName,
            resourceGroupName = resourceGroupName,
            suppressionListName = suppressionListName,
        )
        return getSuppressionListAddressResultToKotlin(getSuppressionListAddressPlain(argument.toJava()).await())
    }

    /**
     * @see [getSuppressionListAddress].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;communication&#46;kotlin&#46;inputs&#46;GetSuppressionListAddressPlainArgs].
     * @return A object that represents a SuppressionList record.
     */
    public suspend
    fun getSuppressionListAddress(argument: suspend GetSuppressionListAddressPlainArgsBuilder.() -> Unit):
        GetSuppressionListAddressResult {
        val builder = GetSuppressionListAddressPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSuppressionListAddressResultToKotlin(getSuppressionListAddressPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the access keys of the CommunicationService resource.
     * Azure REST API version: 2023-03-31.
     * Other available API versions: 2023-04-01, 2023-04-01-preview, 2023-06-01-preview.
     * @param argument null
     * @return A class representing the access keys of a CommunicationService.
     */
    public suspend fun listCommunicationServiceKeys(argument: ListCommunicationServiceKeysPlainArgs):
        ListCommunicationServiceKeysResult =
        listCommunicationServiceKeysResultToKotlin(listCommunicationServiceKeysPlain(argument.toJava()).await())

    /**
     * @see [listCommunicationServiceKeys].
     * @param communicationServiceName The name of the CommunicationService resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A class representing the access keys of a CommunicationService.
     */
    public suspend fun listCommunicationServiceKeys(
        communicationServiceName: String,
        resourceGroupName: String,
    ): ListCommunicationServiceKeysResult {
        val argument = ListCommunicationServiceKeysPlainArgs(
            communicationServiceName = communicationServiceName,
            resourceGroupName = resourceGroupName,
        )
        return listCommunicationServiceKeysResultToKotlin(listCommunicationServiceKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listCommunicationServiceKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;communication&#46;kotlin&#46;inputs&#46;ListCommunicationServiceKeysPlainArgs].
     * @return A class representing the access keys of a CommunicationService.
     */
    public suspend
    fun listCommunicationServiceKeys(argument: suspend ListCommunicationServiceKeysPlainArgsBuilder.() -> Unit):
        ListCommunicationServiceKeysResult {
        val builder = ListCommunicationServiceKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listCommunicationServiceKeysResultToKotlin(listCommunicationServiceKeysPlain(builtArgument.toJava()).await())
    }
}
