@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin

import com.pulumi.azurenative.communication.CommunicationServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A class representing a CommunicationService resource.
 * Azure REST API version: 2023-03-31. Prior API version in Azure Native 1.x: 2020-08-20.
 * Other available API versions: 2023-04-01, 2023-04-01-preview, 2023-06-01-preview.
 * ## Example Usage
 * ### Create or update resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var communicationService = new AzureNative.Communication.CommunicationService("communicationService", new()
 *     {
 *         CommunicationServiceName = "MyCommunicationResource",
 *         DataLocation = "United States",
 *         Location = "Global",
 *         ResourceGroupName = "MyResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/communication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := communication.NewCommunicationService(ctx, "communicationService", &communication.CommunicationServiceArgs{
 * 			CommunicationServiceName: pulumi.String("MyCommunicationResource"),
 * 			DataLocation:             pulumi.String("United States"),
 * 			Location:                 pulumi.String("Global"),
 * 			ResourceGroupName:        pulumi.String("MyResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.communication.CommunicationService;
 * import com.pulumi.azurenative.communication.CommunicationServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var communicationService = new CommunicationService("communicationService", CommunicationServiceArgs.builder()
 *             .communicationServiceName("MyCommunicationResource")
 *             .dataLocation("United States")
 *             .location("Global")
 *             .resourceGroupName("MyResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:communication:CommunicationService MyCommunicationResource /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/communicationServices/{communicationServiceName}
 * ```
 * @property communicationServiceName The name of the CommunicationService resource.
 * @property dataLocation The location where the communication service stores its data at rest.
 * @property linkedDomains List of email Domain resource Ids.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class CommunicationServiceArgs(
    public val communicationServiceName: Output<String>? = null,
    public val dataLocation: Output<String>? = null,
    public val linkedDomains: Output<List<String>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.communication.CommunicationServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.communication.CommunicationServiceArgs =
        com.pulumi.azurenative.communication.CommunicationServiceArgs.builder()
            .communicationServiceName(communicationServiceName?.applyValue({ args0 -> args0 }))
            .dataLocation(dataLocation?.applyValue({ args0 -> args0 }))
            .linkedDomains(linkedDomains?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CommunicationServiceArgs].
 */
@PulumiTagMarker
public class CommunicationServiceArgsBuilder internal constructor() {
    private var communicationServiceName: Output<String>? = null

    private var dataLocation: Output<String>? = null

    private var linkedDomains: Output<List<String>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the CommunicationService resource.
     */
    @JvmName("gtyqjbqdngrprpic")
    public suspend fun communicationServiceName(`value`: Output<String>) {
        this.communicationServiceName = value
    }

    /**
     * @param value The location where the communication service stores its data at rest.
     */
    @JvmName("boniphqmufsbmorm")
    public suspend fun dataLocation(`value`: Output<String>) {
        this.dataLocation = value
    }

    /**
     * @param value List of email Domain resource Ids.
     */
    @JvmName("vxvicxnkpdtwwuji")
    public suspend fun linkedDomains(`value`: Output<List<String>>) {
        this.linkedDomains = value
    }

    @JvmName("rknfsvyhqkistgow")
    public suspend fun linkedDomains(vararg values: Output<String>) {
        this.linkedDomains = Output.all(values.asList())
    }

    /**
     * @param values List of email Domain resource Ids.
     */
    @JvmName("uqdaisjoeywjfmxl")
    public suspend fun linkedDomains(values: List<Output<String>>) {
        this.linkedDomains = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("cwybyxtgntwhkouu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cdwfgcjrtofgpnyi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bejswisehlkrsafr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the CommunicationService resource.
     */
    @JvmName("itbxdagvmdgtnklm")
    public suspend fun communicationServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.communicationServiceName = mapped
    }

    /**
     * @param value The location where the communication service stores its data at rest.
     */
    @JvmName("ybjcswljwkwrdfif")
    public suspend fun dataLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLocation = mapped
    }

    /**
     * @param value List of email Domain resource Ids.
     */
    @JvmName("bvgtcrlbdihkpdco")
    public suspend fun linkedDomains(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedDomains = mapped
    }

    /**
     * @param values List of email Domain resource Ids.
     */
    @JvmName("xaajykidblhwipig")
    public suspend fun linkedDomains(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedDomains = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("obrmeivuervfxhid")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qgouhyjqpvrornqq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("uievbftmffmyucqf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jggycmskrrilkrou")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CommunicationServiceArgs = CommunicationServiceArgs(
        communicationServiceName = communicationServiceName,
        dataLocation = dataLocation,
        linkedDomains = linkedDomains,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
