@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin

import com.pulumi.azurenative.communication.SenderUsernameArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A class representing a SenderUsername resource.
 * Azure REST API version: 2023-03-31.
 * Other available API versions: 2023-04-01, 2023-04-01-preview, 2023-06-01-preview.
 * ## Example Usage
 * ### Create or update SenderUsernames resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var senderUsername = new AzureNative.Communication.SenderUsername("senderUsername", new()
 *     {
 *         DisplayName = "Contoso News Alerts",
 *         DomainName = "contoso.com",
 *         EmailServiceName = "contosoEmailService",
 *         ResourceGroupName = "contosoResourceGroup",
 *         SenderUsername = "contosoNewsAlerts",
 *         Username = "contosoNewsAlerts",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/communication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := communication.NewSenderUsername(ctx, "senderUsername", &communication.SenderUsernameArgs{
 * 			DisplayName:       pulumi.String("Contoso News Alerts"),
 * 			DomainName:        pulumi.String("contoso.com"),
 * 			EmailServiceName:  pulumi.String("contosoEmailService"),
 * 			ResourceGroupName: pulumi.String("contosoResourceGroup"),
 * 			SenderUsername:    pulumi.String("contosoNewsAlerts"),
 * 			Username:          pulumi.String("contosoNewsAlerts"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.communication.SenderUsername;
 * import com.pulumi.azurenative.communication.SenderUsernameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var senderUsername = new SenderUsername("senderUsername", SenderUsernameArgs.builder()
 *             .displayName("Contoso News Alerts")
 *             .domainName("contoso.com")
 *             .emailServiceName("contosoEmailService")
 *             .resourceGroupName("contosoResourceGroup")
 *             .senderUsername("contosoNewsAlerts")
 *             .username("contosoNewsAlerts")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:communication:SenderUsername contoso.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}/domains/{domainName}/senderUsernames/{senderUsername}
 * ```
 * @property displayName The display name for the senderUsername.
 * @property domainName The name of the Domains resource.
 * @property emailServiceName The name of the EmailService resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property senderUsername The valid sender Username.
 * @property username A sender senderUsername to be used when sending emails.
 */
public data class SenderUsernameArgs(
    public val displayName: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val emailServiceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val senderUsername: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.communication.SenderUsernameArgs> {
    override fun toJava(): com.pulumi.azurenative.communication.SenderUsernameArgs =
        com.pulumi.azurenative.communication.SenderUsernameArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .emailServiceName(emailServiceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .senderUsername(senderUsername?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SenderUsernameArgs].
 */
@PulumiTagMarker
public class SenderUsernameArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var domainName: Output<String>? = null

    private var emailServiceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var senderUsername: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The display name for the senderUsername.
     */
    @JvmName("mssgdgoukupiprwt")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the Domains resource.
     */
    @JvmName("yfqevigujisvgwjr")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The name of the EmailService resource.
     */
    @JvmName("brqgqsjseomovpbx")
    public suspend fun emailServiceName(`value`: Output<String>) {
        this.emailServiceName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fnrckkqmeowlrfwo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The valid sender Username.
     */
    @JvmName("uhwaflhmqpjsrrvd")
    public suspend fun senderUsername(`value`: Output<String>) {
        this.senderUsername = value
    }

    /**
     * @param value A sender senderUsername to be used when sending emails.
     */
    @JvmName("mmumxsgbgjondlnu")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The display name for the senderUsername.
     */
    @JvmName("jqnjtwfxrenijrxe")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the Domains resource.
     */
    @JvmName("hyijpeipqntydnvl")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The name of the EmailService resource.
     */
    @JvmName("axhpdxbaligmqqej")
    public suspend fun emailServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailServiceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xtbhpvvjrrbagkxo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The valid sender Username.
     */
    @JvmName("myjgcfgtgndetrbt")
    public suspend fun senderUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.senderUsername = mapped
    }

    /**
     * @param value A sender senderUsername to be used when sending emails.
     */
    @JvmName("fcjbpekevitktcww")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): SenderUsernameArgs = SenderUsernameArgs(
        displayName = displayName,
        domainName = domainName,
        emailServiceName = emailServiceName,
        resourceGroupName = resourceGroupName,
        senderUsername = senderUsername,
        username = username,
    )
}
