@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin.inputs

import com.pulumi.azurenative.communication.inputs.GetSenderUsernamePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName The name of the Domains resource.
 * @property emailServiceName The name of the EmailService resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property senderUsername The valid sender Username.
 */
public data class GetSenderUsernamePlainArgs(
    public val domainName: String,
    public val emailServiceName: String,
    public val resourceGroupName: String,
    public val senderUsername: String,
) : ConvertibleToJava<com.pulumi.azurenative.communication.inputs.GetSenderUsernamePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.communication.inputs.GetSenderUsernamePlainArgs =
        com.pulumi.azurenative.communication.inputs.GetSenderUsernamePlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .emailServiceName(emailServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .senderUsername(senderUsername.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSenderUsernamePlainArgs].
 */
@PulumiTagMarker
public class GetSenderUsernamePlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var emailServiceName: String? = null

    private var resourceGroupName: String? = null

    private var senderUsername: String? = null

    /**
     * @param value The name of the Domains resource.
     */
    @JvmName("gajhvqphggrulctp")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value The name of the EmailService resource.
     */
    @JvmName("alexnbxjtbpnoinu")
    public suspend fun emailServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.emailServiceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cdgcbymibodpgnac")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The valid sender Username.
     */
    @JvmName("ptbeqllrskwectnh")
    public suspend fun senderUsername(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.senderUsername = mapped
    }

    internal fun build(): GetSenderUsernamePlainArgs = GetSenderUsernamePlainArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        emailServiceName = emailServiceName ?: throw PulumiNullFieldException("emailServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        senderUsername = senderUsername ?: throw PulumiNullFieldException("senderUsername"),
    )
}
