@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.CloudServicePropertiesResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.CloudServicePropertiesResponse.Companion.toKotlin as cloudServicePropertiesResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CloudService].
 */
@PulumiTagMarker
public class CloudServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CloudServiceArgs = CloudServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CloudServiceArgsBuilder.() -> Unit) {
        val builder = CloudServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CloudService {
        val builtJavaResource = com.pulumi.azurenative.compute.CloudService(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CloudService(builtJavaResource)
    }
}

/**
 * Describes the cloud service.
 * Azure REST API version: 2022-09-04. Prior API version in Azure Native 1.x: 2021-03-01.
 * ## Example Usage
 * ### Create New Cloud Service with Multiple Roles
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudService = new AzureNative.Compute.CloudService("cloudService", new()
 *     {
 *         CloudServiceName = "{cs-name}",
 *         Location = "westus",
 *         Properties = new AzureNative.Compute.Inputs.CloudServicePropertiesArgs
 *         {
 *             Configuration = "{ServiceConfiguration}",
 *             NetworkProfile = new AzureNative.Compute.Inputs.CloudServiceNetworkProfileArgs
 *             {
 *                 LoadBalancerConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.LoadBalancerConfigurationArgs
 *                     {
 *                         Name = "contosolb",
 *                         Properties = new AzureNative.Compute.Inputs.LoadBalancerConfigurationPropertiesArgs
 *                         {
 *                             FrontendIpConfigurations = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationArgs
 *                                 {
 *                                     Name = "contosofe",
 *                                     Properties = new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationPropertiesArgs
 *                                     {
 *                                         PublicIPAddress = new AzureNative.Compute.Inputs.SubResourceArgs
 *                                         {
 *                                             Id = "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             PackageUrl = "{PackageUrl}",
 *             RoleProfile = new AzureNative.Compute.Inputs.CloudServiceRoleProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.CloudServiceRoleProfilePropertiesArgs
 *                     {
 *                         Name = "ContosoFrontend",
 *                         Sku = new AzureNative.Compute.Inputs.CloudServiceRoleSkuArgs
 *                         {
 *                             Capacity = 1,
 *                             Name = "Standard_D1_v2",
 *                             Tier = "Standard",
 *                         },
 *                     },
 *                     new AzureNative.Compute.Inputs.CloudServiceRoleProfilePropertiesArgs
 *                     {
 *                         Name = "ContosoBackend",
 *                         Sku = new AzureNative.Compute.Inputs.CloudServiceRoleSkuArgs
 *                         {
 *                             Capacity = 1,
 *                             Name = "Standard_D1_v2",
 *                             Tier = "Standard",
 *                         },
 *                     },
 *                 },
 *             },
 *             UpgradeMode = "Auto",
 *         },
 *         ResourceGroupName = "ConstosoRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewCloudService(ctx, "cloudService", &compute.CloudServiceArgs{
 * CloudServiceName: pulumi.String("{cs-name}"),
 * Location: pulumi.String("westus"),
 * Properties: compute.CloudServicePropertiesResponse{
 * Configuration: pulumi.String("{ServiceConfiguration}"),
 * NetworkProfile: interface{}{
 * LoadBalancerConfigurations: compute.LoadBalancerConfigurationArray{
 * interface{}{
 * Name: pulumi.String("contosolb"),
 * Properties: interface{}{
 * FrontendIpConfigurations: compute.LoadBalancerFrontendIpConfigurationArray{
 * interface{}{
 * Name: pulumi.String("contosofe"),
 * Properties: interface{}{
 * PublicIPAddress: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip"),
 * },
 * },
 * },
 * },
 * },
 * },
 * },
 * },
 * PackageUrl: pulumi.String("{PackageUrl}"),
 * RoleProfile: interface{}{
 * Roles: compute.CloudServiceRoleProfilePropertiesArray{
 * interface{}{
 * Name: pulumi.String("ContosoFrontend"),
 * Sku: &compute.CloudServiceRoleSkuArgs{
 * Capacity: pulumi.Float64(1),
 * Name: pulumi.String("Standard_D1_v2"),
 * Tier: pulumi.String("Standard"),
 * },
 * },
 * interface{}{
 * Name: pulumi.String("ContosoBackend"),
 * Sku: &compute.CloudServiceRoleSkuArgs{
 * Capacity: pulumi.Float64(1),
 * Name: pulumi.String("Standard_D1_v2"),
 * Tier: pulumi.String("Standard"),
 * },
 * },
 * },
 * },
 * UpgradeMode: pulumi.String("Auto"),
 * },
 * ResourceGroupName: pulumi.String("ConstosoRG"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.CloudService;
 * import com.pulumi.azurenative.compute.CloudServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudService = new CloudService("cloudService", CloudServiceArgs.builder()
 *             .cloudServiceName("{cs-name}")
 *             .location("westus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("configuration", "{ServiceConfiguration}"),
 *                 Map.entry("networkProfile", Map.of("loadBalancerConfigurations", Map.ofEntries(
 *                     Map.entry("name", "contosolb"),
 *                     Map.entry("properties", Map.of("frontendIpConfigurations", Map.ofEntries(
 *                         Map.entry("name", "contosofe"),
 *                         Map.entry("properties", Map.of("publicIPAddress", Map.of("id", "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip")))
 *                     )))
 *                 ))),
 *                 Map.entry("packageUrl", "{PackageUrl}"),
 *                 Map.entry("roleProfile", Map.of("roles",
 *                     Map.ofEntries(
 *                         Map.entry("name", "ContosoFrontend"),
 *                         Map.entry("sku", Map.ofEntries(
 *                             Map.entry("capacity", 1),
 *                             Map.entry("name", "Standard_D1_v2"),
 *                             Map.entry("tier", "Standard")
 *                         ))
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("name", "ContosoBackend"),
 *                         Map.entry("sku", Map.ofEntries(
 *                             Map.entry("capacity", 1),
 *                             Map.entry("name", "Standard_D1_v2"),
 *                             Map.entry("tier", "Standard")
 *                         ))
 *                     ))),
 *                 Map.entry("upgradeMode", "Auto")
 *             ))
 *             .resourceGroupName("ConstosoRG")
 *             .build());
 *     }
 * }
 * ```
 * ### Create New Cloud Service with Multiple Roles in a specific availability zone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudService = new AzureNative.Compute.CloudService("cloudService", new()
 *     {
 *         CloudServiceName = "{cs-name}",
 *         Location = "westus",
 *         Properties = new AzureNative.Compute.Inputs.CloudServicePropertiesArgs
 *         {
 *             Configuration = "{ServiceConfiguration}",
 *             NetworkProfile = new AzureNative.Compute.Inputs.CloudServiceNetworkProfileArgs
 *             {
 *                 LoadBalancerConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.LoadBalancerConfigurationArgs
 *                     {
 *                         Name = "contosolb",
 *                         Properties = new AzureNative.Compute.Inputs.LoadBalancerConfigurationPropertiesArgs
 *                         {
 *                             FrontendIpConfigurations = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationArgs
 *                                 {
 *                                     Name = "contosofe",
 *                                     Properties = new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationPropertiesArgs
 *                                     {
 *                                         PublicIPAddress = new AzureNative.Compute.Inputs.SubResourceArgs
 *                                         {
 *                                             Id = "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             PackageUrl = "{PackageUrl}",
 *             RoleProfile = new AzureNative.Compute.Inputs.CloudServiceRoleProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.CloudServiceRoleProfilePropertiesArgs
 *                     {
 *                         Name = "ContosoFrontend",
 *                         Sku = new AzureNative.Compute.Inputs.CloudServiceRoleSkuArgs
 *                         {
 *                             Capacity = 1,
 *                             Name = "Standard_D1_v2",
 *                             Tier = "Standard",
 *                         },
 *                     },
 *                     new AzureNative.Compute.Inputs.CloudServiceRoleProfilePropertiesArgs
 *                     {
 *                         Name = "ContosoBackend",
 *                         Sku = new AzureNative.Compute.Inputs.CloudServiceRoleSkuArgs
 *                         {
 *                             Capacity = 1,
 *                             Name = "Standard_D1_v2",
 *                             Tier = "Standard",
 *                         },
 *                     },
 *                 },
 *             },
 *             UpgradeMode = "Auto",
 *         },
 *         ResourceGroupName = "ConstosoRG",
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewCloudService(ctx, "cloudService", &compute.CloudServiceArgs{
 * CloudServiceName: pulumi.String("{cs-name}"),
 * Location: pulumi.String("westus"),
 * Properties: compute.CloudServicePropertiesResponse{
 * Configuration: pulumi.String("{ServiceConfiguration}"),
 * NetworkProfile: interface{}{
 * LoadBalancerConfigurations: compute.LoadBalancerConfigurationArray{
 * interface{}{
 * Name: pulumi.String("contosolb"),
 * Properties: interface{}{
 * FrontendIpConfigurations: compute.LoadBalancerFrontendIpConfigurationArray{
 * interface{}{
 * Name: pulumi.String("contosofe"),
 * Properties: interface{}{
 * PublicIPAddress: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip"),
 * },
 * },
 * },
 * },
 * },
 * },
 * },
 * },
 * PackageUrl: pulumi.String("{PackageUrl}"),
 * RoleProfile: interface{}{
 * Roles: compute.CloudServiceRoleProfilePropertiesArray{
 * interface{}{
 * Name: pulumi.String("ContosoFrontend"),
 * Sku: &compute.CloudServiceRoleSkuArgs{
 * Capacity: pulumi.Float64(1),
 * Name: pulumi.String("Standard_D1_v2"),
 * Tier: pulumi.String("Standard"),
 * },
 * },
 * interface{}{
 * Name: pulumi.String("ContosoBackend"),
 * Sku: &compute.CloudServiceRoleSkuArgs{
 * Capacity: pulumi.Float64(1),
 * Name: pulumi.String("Standard_D1_v2"),
 * Tier: pulumi.String("Standard"),
 * },
 * },
 * },
 * },
 * UpgradeMode: pulumi.String("Auto"),
 * },
 * ResourceGroupName: pulumi.String("ConstosoRG"),
 * Zones: pulumi.StringArray{
 * pulumi.String("1"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.CloudService;
 * import com.pulumi.azurenative.compute.CloudServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudService = new CloudService("cloudService", CloudServiceArgs.builder()
 *             .cloudServiceName("{cs-name}")
 *             .location("westus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("configuration", "{ServiceConfiguration}"),
 *                 Map.entry("networkProfile", Map.of("loadBalancerConfigurations", Map.ofEntries(
 *                     Map.entry("name", "contosolb"),
 *                     Map.entry("properties", Map.of("frontendIpConfigurations", Map.ofEntries(
 *                         Map.entry("name", "contosofe"),
 *                         Map.entry("properties", Map.of("publicIPAddress", Map.of("id", "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip")))
 *                     )))
 *                 ))),
 *                 Map.entry("packageUrl", "{PackageUrl}"),
 *                 Map.entry("roleProfile", Map.of("roles",
 *                     Map.ofEntries(
 *                         Map.entry("name", "ContosoFrontend"),
 *                         Map.entry("sku", Map.ofEntries(
 *                             Map.entry("capacity", 1),
 *                             Map.entry("name", "Standard_D1_v2"),
 *                             Map.entry("tier", "Standard")
 *                         ))
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("name", "ContosoBackend"),
 *                         Map.entry("sku", Map.ofEntries(
 *                             Map.entry("capacity", 1),
 *                             Map.entry("name", "Standard_D1_v2"),
 *                             Map.entry("tier", "Standard")
 *                         ))
 *                     ))),
 *                 Map.entry("upgradeMode", "Auto")
 *             ))
 *             .resourceGroupName("ConstosoRG")
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create New Cloud Service with Single Role
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudService = new AzureNative.Compute.CloudService("cloudService", new()
 *     {
 *         CloudServiceName = "{cs-name}",
 *         Location = "westus",
 *         Properties = new AzureNative.Compute.Inputs.CloudServicePropertiesArgs
 *         {
 *             Configuration = "{ServiceConfiguration}",
 *             NetworkProfile = new AzureNative.Compute.Inputs.CloudServiceNetworkProfileArgs
 *             {
 *                 LoadBalancerConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.LoadBalancerConfigurationArgs
 *                     {
 *                         Name = "myLoadBalancer",
 *                         Properties = new AzureNative.Compute.Inputs.LoadBalancerConfigurationPropertiesArgs
 *                         {
 *                             FrontendIpConfigurations = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationArgs
 *                                 {
 *                                     Name = "myfe",
 *                                     Properties = new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationPropertiesArgs
 *                                     {
 *                                         PublicIPAddress = new AzureNative.Compute.Inputs.SubResourceArgs
 *                                         {
 *                                             Id = "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/myPublicIP",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             PackageUrl = "{PackageUrl}",
 *             RoleProfile = new AzureNative.Compute.Inputs.CloudServiceRoleProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.CloudServiceRoleProfilePropertiesArgs
 *                     {
 *                         Name = "ContosoFrontend",
 *                         Sku = new AzureNative.Compute.Inputs.CloudServiceRoleSkuArgs
 *                         {
 *                             Capacity = 1,
 *                             Name = "Standard_D1_v2",
 *                             Tier = "Standard",
 *                         },
 *                     },
 *                 },
 *             },
 *             UpgradeMode = "Auto",
 *         },
 *         ResourceGroupName = "ConstosoRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewCloudService(ctx, "cloudService", &compute.CloudServiceArgs{
 * CloudServiceName: pulumi.String("{cs-name}"),
 * Location: pulumi.String("westus"),
 * Properties: compute.CloudServicePropertiesResponse{
 * Configuration: pulumi.String("{ServiceConfiguration}"),
 * NetworkProfile: interface{}{
 * LoadBalancerConfigurations: compute.LoadBalancerConfigurationArray{
 * interface{}{
 * Name: pulumi.String("myLoadBalancer"),
 * Properties: interface{}{
 * FrontendIpConfigurations: compute.LoadBalancerFrontendIpConfigurationArray{
 * interface{}{
 * Name: pulumi.String("myfe"),
 * Properties: interface{}{
 * PublicIPAddress: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/myPublicIP"),
 * },
 * },
 * },
 * },
 * },
 * },
 * },
 * },
 * PackageUrl: pulumi.String("{PackageUrl}"),
 * RoleProfile: interface{}{
 * Roles: compute.CloudServiceRoleProfilePropertiesArray{
 * interface{}{
 * Name: pulumi.String("ContosoFrontend"),
 * Sku: &compute.CloudServiceRoleSkuArgs{
 * Capacity: pulumi.Float64(1),
 * Name: pulumi.String("Standard_D1_v2"),
 * Tier: pulumi.String("Standard"),
 * },
 * },
 * },
 * },
 * UpgradeMode: pulumi.String("Auto"),
 * },
 * ResourceGroupName: pulumi.String("ConstosoRG"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.CloudService;
 * import com.pulumi.azurenative.compute.CloudServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudService = new CloudService("cloudService", CloudServiceArgs.builder()
 *             .cloudServiceName("{cs-name}")
 *             .location("westus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("configuration", "{ServiceConfiguration}"),
 *                 Map.entry("networkProfile", Map.of("loadBalancerConfigurations", Map.ofEntries(
 *                     Map.entry("name", "myLoadBalancer"),
 *                     Map.entry("properties", Map.of("frontendIpConfigurations", Map.ofEntries(
 *                         Map.entry("name", "myfe"),
 *                         Map.entry("properties", Map.of("publicIPAddress", Map.of("id", "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/myPublicIP")))
 *                     )))
 *                 ))),
 *                 Map.entry("packageUrl", "{PackageUrl}"),
 *                 Map.entry("roleProfile", Map.of("roles", Map.ofEntries(
 *                     Map.entry("name", "ContosoFrontend"),
 *                     Map.entry("sku", Map.ofEntries(
 *                         Map.entry("capacity", 1),
 *                         Map.entry("name", "Standard_D1_v2"),
 *                         Map.entry("tier", "Standard")
 *                     ))
 *                 ))),
 *                 Map.entry("upgradeMode", "Auto")
 *             ))
 *             .resourceGroupName("ConstosoRG")
 *             .build());
 *     }
 * }
 * ```
 * ### Create New Cloud Service with Single Role and Certificate from Key Vault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudService = new AzureNative.Compute.CloudService("cloudService", new()
 *     {
 *         CloudServiceName = "{cs-name}",
 *         Location = "westus",
 *         Properties = new AzureNative.Compute.Inputs.CloudServicePropertiesArgs
 *         {
 *             Configuration = "{ServiceConfiguration}",
 *             NetworkProfile = new AzureNative.Compute.Inputs.CloudServiceNetworkProfileArgs
 *             {
 *                 LoadBalancerConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.LoadBalancerConfigurationArgs
 *                     {
 *                         Name = "contosolb",
 *                         Properties = new AzureNative.Compute.Inputs.LoadBalancerConfigurationPropertiesArgs
 *                         {
 *                             FrontendIpConfigurations = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationArgs
 *                                 {
 *                                     Name = "contosofe",
 *                                     Properties = new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationPropertiesArgs
 *                                     {
 *                                         PublicIPAddress = new AzureNative.Compute.Inputs.SubResourceArgs
 *                                         {
 *                                             Id = "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.CloudServiceOsProfileArgs
 *             {
 *                 Secrets = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.CloudServiceVaultSecretGroupArgs
 *                     {
 *                         SourceVault = new AzureNative.Compute.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.KeyVault/vaults/{keyvault-name}",
 *                         },
 *                         VaultCertificates = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.CloudServiceVaultCertificateArgs
 *                             {
 *                                 CertificateUrl = "https://{keyvault-name}.vault.azure.net:443/secrets/ContosoCertificate/{secret-id}",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             PackageUrl = "{PackageUrl}",
 *             RoleProfile = new AzureNative.Compute.Inputs.CloudServiceRoleProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.CloudServiceRoleProfilePropertiesArgs
 *                     {
 *                         Name = "ContosoFrontend",
 *                         Sku = new AzureNative.Compute.Inputs.CloudServiceRoleSkuArgs
 *                         {
 *                             Capacity = 1,
 *                             Name = "Standard_D1_v2",
 *                             Tier = "Standard",
 *                         },
 *                     },
 *                 },
 *             },
 *             UpgradeMode = "Auto",
 *         },
 *         ResourceGroupName = "ConstosoRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewCloudService(ctx, "cloudService", &compute.CloudServiceArgs{
 * CloudServiceName: pulumi.String("{cs-name}"),
 * Location: pulumi.String("westus"),
 * Properties: compute.CloudServicePropertiesResponse{
 * Configuration: pulumi.String("{ServiceConfiguration}"),
 * NetworkProfile: interface{}{
 * LoadBalancerConfigurations: compute.LoadBalancerConfigurationArray{
 * interface{}{
 * Name: pulumi.String("contosolb"),
 * Properties: interface{}{
 * FrontendIpConfigurations: compute.LoadBalancerFrontendIpConfigurationArray{
 * interface{}{
 * Name: pulumi.String("contosofe"),
 * Properties: interface{}{
 * PublicIPAddress: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip"),
 * },
 * },
 * },
 * },
 * },
 * },
 * },
 * },
 * OsProfile: interface{}{
 * Secrets: compute.CloudServiceVaultSecretGroupArray{
 * interface{}{
 * SourceVault: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.KeyVault/vaults/{keyvault-name}"),
 * },
 * VaultCertificates: compute.CloudServiceVaultCertificateArray{
 * &compute.CloudServiceVaultCertificateArgs{
 * CertificateUrl: pulumi.String("https://{keyvault-name}.vault.azure.net:443/secrets/ContosoCertificate/{secret-id}"),
 * },
 * },
 * },
 * },
 * },
 * PackageUrl: pulumi.String("{PackageUrl}"),
 * RoleProfile: interface{}{
 * Roles: compute.CloudServiceRoleProfilePropertiesArray{
 * interface{}{
 * Name: pulumi.String("ContosoFrontend"),
 * Sku: &compute.CloudServiceRoleSkuArgs{
 * Capacity: pulumi.Float64(1),
 * Name: pulumi.String("Standard_D1_v2"),
 * Tier: pulumi.String("Standard"),
 * },
 * },
 * },
 * },
 * UpgradeMode: pulumi.String("Auto"),
 * },
 * ResourceGroupName: pulumi.String("ConstosoRG"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.CloudService;
 * import com.pulumi.azurenative.compute.CloudServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudService = new CloudService("cloudService", CloudServiceArgs.builder()
 *             .cloudServiceName("{cs-name}")
 *             .location("westus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("configuration", "{ServiceConfiguration}"),
 *                 Map.entry("networkProfile", Map.of("loadBalancerConfigurations", Map.ofEntries(
 *                     Map.entry("name", "contosolb"),
 *                     Map.entry("properties", Map.of("frontendIpConfigurations", Map.ofEntries(
 *                         Map.entry("name", "contosofe"),
 *                         Map.entry("properties", Map.of("publicIPAddress", Map.of("id", "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip")))
 *                     )))
 *                 ))),
 *                 Map.entry("osProfile", Map.of("secrets", Map.ofEntries(
 *                     Map.entry("sourceVault", Map.of("id", "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.KeyVault/vaults/{keyvault-name}")),
 *                     Map.entry("vaultCertificates", Map.of("certificateUrl", "https://{keyvault-name}.vault.azure.net:443/secrets/ContosoCertificate/{secret-id}"))
 *                 ))),
 *                 Map.entry("packageUrl", "{PackageUrl}"),
 *                 Map.entry("roleProfile", Map.of("roles", Map.ofEntries(
 *                     Map.entry("name", "ContosoFrontend"),
 *                     Map.entry("sku", Map.ofEntries(
 *                         Map.entry("capacity", 1),
 *                         Map.entry("name", "Standard_D1_v2"),
 *                         Map.entry("tier", "Standard")
 *                     ))
 *                 ))),
 *                 Map.entry("upgradeMode", "Auto")
 *             ))
 *             .resourceGroupName("ConstosoRG")
 *             .build());
 *     }
 * }
 * ```
 * ### Create New Cloud Service with Single Role and RDP Extension
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudService = new AzureNative.Compute.CloudService("cloudService", new()
 *     {
 *         CloudServiceName = "{cs-name}",
 *         Location = "westus",
 *         Properties = new AzureNative.Compute.Inputs.CloudServicePropertiesArgs
 *         {
 *             Configuration = "{ServiceConfiguration}",
 *             ExtensionProfile = new AzureNative.Compute.Inputs.CloudServiceExtensionProfileArgs
 *             {
 *                 Extensions = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.ExtensionArgs
 *                     {
 *                         Name = "RDPExtension",
 *                         Properties = new AzureNative.Compute.Inputs.CloudServiceExtensionPropertiesArgs
 *                         {
 *                             AutoUpgradeMinorVersion = false,
 *                             ProtectedSettings = "<PrivateConfig><Password>{password}</Password></PrivateConfig>",
 *                             Publisher = "Microsoft.Windows.Azure.Extensions",
 *                             Settings = "<PublicConfig><UserName>UserAzure</UserName><Expiration>10/22/2021 15:05:45</Expiration></PublicConfig>",
 *                             Type = "RDP",
 *                             TypeHandlerVersion = "1.2",
 *                         },
 *                     },
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.CloudServiceNetworkProfileArgs
 *             {
 *                 LoadBalancerConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.LoadBalancerConfigurationArgs
 *                     {
 *                         Name = "contosolb",
 *                         Properties = new AzureNative.Compute.Inputs.LoadBalancerConfigurationPropertiesArgs
 *                         {
 *                             FrontendIpConfigurations = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationArgs
 *                                 {
 *                                     Name = "contosofe",
 *                                     Properties = new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationPropertiesArgs
 *                                     {
 *                                         PublicIPAddress = new AzureNative.Compute.Inputs.SubResourceArgs
 *                                         {
 *                                             Id = "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             PackageUrl = "{PackageUrl}",
 *             RoleProfile = new AzureNative.Compute.Inputs.CloudServiceRoleProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.CloudServiceRoleProfilePropertiesArgs
 *                     {
 *                         Name = "ContosoFrontend",
 *                         Sku = new AzureNative.Compute.Inputs.CloudServiceRoleSkuArgs
 *                         {
 *                             Capacity = 1,
 *                             Name = "Standard_D1_v2",
 *                             Tier = "Standard",
 *                         },
 *                     },
 *                 },
 *             },
 *             UpgradeMode = "Auto",
 *         },
 *         ResourceGroupName = "ConstosoRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewCloudService(ctx, "cloudService", &compute.CloudServiceArgs{
 * CloudServiceName: pulumi.String("{cs-name}"),
 * Location: pulumi.String("westus"),
 * Properties: compute.CloudServicePropertiesResponse{
 * Configuration: pulumi.String("{ServiceConfiguration}"),
 * ExtensionProfile: interface{}{
 * Extensions: compute.ExtensionArray{
 * interface{}{
 * Name: pulumi.String("RDPExtension"),
 * Properties: &compute.CloudServiceExtensionPropertiesArgs{
 * AutoUpgradeMinorVersion: pulumi.Bool(false),
 * ProtectedSettings: pulumi.Any("<PrivateConfig><Password>{password}</Password></PrivateConfig>"),
 * Publisher: pulumi.String("Microsoft.Windows.Azure.Extensions"),
 * Settings: pulumi.Any("<PublicConfig><UserName>UserAzure</UserName><Expiration>10/22/2021 15:05:45</Expiration></PublicConfig>"),
 * Type: pulumi.String("RDP"),
 * TypeHandlerVersion: pulumi.String("1.2"),
 * },
 * },
 * },
 * },
 * NetworkProfile: interface{}{
 * LoadBalancerConfigurations: compute.LoadBalancerConfigurationArray{
 * interface{}{
 * Name: pulumi.String("contosolb"),
 * Properties: interface{}{
 * FrontendIpConfigurations: compute.LoadBalancerFrontendIpConfigurationArray{
 * interface{}{
 * Name: pulumi.String("contosofe"),
 * Properties: interface{}{
 * PublicIPAddress: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip"),
 * },
 * },
 * },
 * },
 * },
 * },
 * },
 * },
 * PackageUrl: pulumi.String("{PackageUrl}"),
 * RoleProfile: interface{}{
 * Roles: compute.CloudServiceRoleProfilePropertiesArray{
 * interface{}{
 * Name: pulumi.String("ContosoFrontend"),
 * Sku: &compute.CloudServiceRoleSkuArgs{
 * Capacity: pulumi.Float64(1),
 * Name: pulumi.String("Standard_D1_v2"),
 * Tier: pulumi.String("Standard"),
 * },
 * },
 * },
 * },
 * UpgradeMode: pulumi.String("Auto"),
 * },
 * ResourceGroupName: pulumi.String("ConstosoRG"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.CloudService;
 * import com.pulumi.azurenative.compute.CloudServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudService = new CloudService("cloudService", CloudServiceArgs.builder()
 *             .cloudServiceName("{cs-name}")
 *             .location("westus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("configuration", "{ServiceConfiguration}"),
 *                 Map.entry("extensionProfile", Map.of("extensions", Map.ofEntries(
 *                     Map.entry("name", "RDPExtension"),
 *                     Map.entry("properties", Map.ofEntries(
 *                         Map.entry("autoUpgradeMinorVersion", false),
 *                         Map.entry("protectedSettings", "<PrivateConfig><Password>{password}</Password></PrivateConfig>"),
 *                         Map.entry("publisher", "Microsoft.Windows.Azure.Extensions"),
 *                         Map.entry("settings", "<PublicConfig><UserName>UserAzure</UserName><Expiration>10/22/2021 15:05:45</Expiration></PublicConfig>"),
 *                         Map.entry("type", "RDP"),
 *                         Map.entry("typeHandlerVersion", "1.2")
 *                     ))
 *                 ))),
 *                 Map.entry("networkProfile", Map.of("loadBalancerConfigurations", Map.ofEntries(
 *                     Map.entry("name", "contosolb"),
 *                     Map.entry("properties", Map.of("frontendIpConfigurations", Map.ofEntries(
 *                         Map.entry("name", "contosofe"),
 *                         Map.entry("properties", Map.of("publicIPAddress", Map.of("id", "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip")))
 *                     )))
 *                 ))),
 *                 Map.entry("packageUrl", "{PackageUrl}"),
 *                 Map.entry("roleProfile", Map.of("roles", Map.ofEntries(
 *                     Map.entry("name", "ContosoFrontend"),
 *                     Map.entry("sku", Map.ofEntries(
 *                         Map.entry("capacity", 1),
 *                         Map.entry("name", "Standard_D1_v2"),
 *                         Map.entry("tier", "Standard")
 *                     ))
 *                 ))),
 *                 Map.entry("upgradeMode", "Auto")
 *             ))
 *             .resourceGroupName("ConstosoRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:CloudService {cs-name} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}
 * ```
 */
public class CloudService internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.CloudService,
) : KotlinCustomResource(javaResource, CloudServiceMapper) {
    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Cloud service properties
     */
    public val properties: Output<CloudServicePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                cloudServicePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>?
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    systemDataResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * List of logical availability zone of the resource. List should contain only 1 zone where cloud service should be provisioned. This field is optional.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object CloudServiceMapper : ResourceMapper<CloudService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.CloudService::class == javaResource::class

    override fun map(javaResource: Resource): CloudService = CloudService(
        javaResource as
            com.pulumi.azurenative.compute.CloudService,
    )
}

/**
 * @see [CloudService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CloudService].
 */
public suspend fun cloudService(
    name: String,
    block: suspend CloudServiceResourceBuilder.() -> Unit,
): CloudService {
    val builder = CloudServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CloudService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cloudService(name: String): CloudService {
    val builder = CloudServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
