@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.DiskArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.DataAccessAuthMode
import com.pulumi.azurenative.compute.kotlin.enums.HyperVGeneration
import com.pulumi.azurenative.compute.kotlin.enums.NetworkAccessPolicy
import com.pulumi.azurenative.compute.kotlin.enums.OperatingSystemTypes
import com.pulumi.azurenative.compute.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.compute.kotlin.inputs.CreationDataArgs
import com.pulumi.azurenative.compute.kotlin.inputs.CreationDataArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.DiskSecurityProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.DiskSecurityProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.DiskSkuArgs
import com.pulumi.azurenative.compute.kotlin.inputs.DiskSkuArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.EncryptionArgs
import com.pulumi.azurenative.compute.kotlin.inputs.EncryptionArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.EncryptionSettingsCollectionArgs
import com.pulumi.azurenative.compute.kotlin.inputs.EncryptionSettingsCollectionArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.compute.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.PurchasePlanArgs
import com.pulumi.azurenative.compute.kotlin.inputs.PurchasePlanArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.SupportedCapabilitiesArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SupportedCapabilitiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Disk resource.
 * Azure REST API version: 2022-07-02. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-04-30-preview, 2018-06-01, 2019-07-01, 2023-01-02, 2023-04-02, 2023-10-02.
 * ## Example Usage
 * ### Create a confidential VM supported disk encrypted with customer managed key
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "FromImage",
 *             ImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 Id = "/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.DiskSecurityProfileArgs
 *         {
 *             SecureVMDiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}",
 *             SecurityType = "ConfidentialVM_DiskEncryptedWithCustomerKey",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: compute.CreationDataResponse{
 * 				CreateOption: pulumi.String("FromImage"),
 * 				ImageReference: &compute.ImageDiskReferenceArgs{
 * 					Id: pulumi.String("/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.DiskSecurityProfileArgs{
 * 				SecureVMDiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}"),
 * 				SecurityType:                pulumi.String("ConfidentialVM_DiskEncryptedWithCustomerKey"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "FromImage"),
 *                 Map.entry("imageReference", Map.of("id", "/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0"))
 *             ))
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(Map.ofEntries(
 *                 Map.entry("secureVMDiskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}"),
 *                 Map.entry("securityType", "ConfidentialVM_DiskEncryptedWithCustomerKey")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk and associate with disk access resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Empty",
 *         },
 *         DiskAccessId = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskAccesses/{existing-diskAccess-name}",
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         NetworkAccessPolicy = "AllowPrivate",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String("Empty"),
 * 			},
 * 			DiskAccessId:        pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskAccesses/{existing-diskAccess-name}"),
 * 			DiskName:            pulumi.String("myDisk"),
 * 			DiskSizeGB:          pulumi.Int(200),
 * 			Location:            pulumi.String("West US"),
 * 			NetworkAccessPolicy: pulumi.String("AllowPrivate"),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.of("createOption", "Empty"))
 *             .diskAccessId("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskAccesses/{existing-diskAccess-name}")
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .networkAccessPolicy("AllowPrivate")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk and associate with disk encryption set.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Empty",
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Encryption = new AzureNative.Compute.Inputs.EncryptionArgs
 *         {
 *             DiskEncryptionSetId = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String("Empty"),
 * 			},
 * 			DiskName:   pulumi.String("myDisk"),
 * 			DiskSizeGB: pulumi.Int(200),
 * 			Encryption: &compute.EncryptionArgs{
 * 				DiskEncryptionSetId: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.of("createOption", "Empty"))
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .encryption(Map.of("diskEncryptionSetId", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"))
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk by copying a snapshot.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Copy",
 *             SourceResourceId = "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot",
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String("Copy"),
 * 				SourceResourceId: pulumi.String("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "Copy"),
 *                 Map.entry("sourceResourceId", "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot")
 *             ))
 *             .diskName("myDisk")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk by importing an unmanaged blob from a different subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Import",
 *             SourceUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *             StorageAccountId = "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount",
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String("Import"),
 * 				SourceUri:        pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 				StorageAccountId: pulumi.String("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "Import"),
 *                 Map.entry("sourceUri", "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 *                 Map.entry("storageAccountId", "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount")
 *             ))
 *             .diskName("myDisk")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk by importing an unmanaged blob from the same subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Import",
 *             SourceUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String("Import"),
 * 				SourceUri:    pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "Import"),
 *                 Map.entry("sourceUri", "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd")
 *             ))
 *             .diskName("myDisk")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from ImportSecure create option
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "ImportSecure",
 *             SecurityDataUri = "https://mystorageaccount.blob.core.windows.net/osimages/vmgs.vhd",
 *             SourceUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *             StorageAccountId = "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount",
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.DiskSecurityProfileArgs
 *         {
 *             SecurityType = "ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String("ImportSecure"),
 * 				SecurityDataUri:  pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/vmgs.vhd"),
 * 				SourceUri:        pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 				StorageAccountId: pulumi.String("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.DiskSecurityProfileArgs{
 * 				SecurityType: pulumi.String("ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "ImportSecure"),
 *                 Map.entry("securityDataUri", "https://mystorageaccount.blob.core.windows.net/osimages/vmgs.vhd"),
 *                 Map.entry("sourceUri", "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 *                 Map.entry("storageAccountId", "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount")
 *             ))
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(Map.of("securityType", "ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from UploadPreparedSecure create option
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "UploadPreparedSecure",
 *             UploadSizeBytes = 10737418752,
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.DiskSecurityProfileArgs
 *         {
 *             SecurityType = "TrustedLaunch",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:    pulumi.String("UploadPreparedSecure"),
 * 				UploadSizeBytes: pulumi.Float64(10737418752),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.DiskSecurityProfileArgs{
 * 				SecurityType: pulumi.String("TrustedLaunch"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "UploadPreparedSecure"),
 *                 Map.entry("uploadSizeBytes", 10737418752)
 *             ))
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(Map.of("securityType", "TrustedLaunch"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from a platform image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "FromImage",
 *             ImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 Id = "/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: compute.CreationDataResponse{
 * 				CreateOption: pulumi.String("FromImage"),
 * 				ImageReference: &compute.ImageDiskReferenceArgs{
 * 					Id: pulumi.String("/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "FromImage"),
 *                 Map.entry("imageReference", Map.of("id", "/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/westus/Publishers/{publisher}/ArtifactTypes/VMImage/Offers/{offer}/Skus/{sku}/Versions/1.0.0"))
 *             ))
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from an Azure Compute Gallery community image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "FromImage",
 *             GalleryImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 CommunityGalleryImageId = "/CommunityGalleries/{communityGalleryPublicGalleryName}/Images/{imageName}/Versions/1.0.0",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: compute.CreationDataResponse{
 * 				CreateOption: pulumi.String("FromImage"),
 * 				GalleryImageReference: &compute.ImageDiskReferenceArgs{
 * 					CommunityGalleryImageId: pulumi.String("/CommunityGalleries/{communityGalleryPublicGalleryName}/Images/{imageName}/Versions/1.0.0"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "FromImage"),
 *                 Map.entry("galleryImageReference", Map.of("communityGalleryImageId", "/CommunityGalleries/{communityGalleryPublicGalleryName}/Images/{imageName}/Versions/1.0.0"))
 *             ))
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from an Azure Compute Gallery direct shared image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "FromImage",
 *             GalleryImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 SharedGalleryImageId = "/SharedGalleries/{sharedGalleryUniqueName}/Images/{imageName}/Versions/1.0.0",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: compute.CreationDataResponse{
 * 				CreateOption: pulumi.String("FromImage"),
 * 				GalleryImageReference: &compute.ImageDiskReferenceArgs{
 * 					SharedGalleryImageId: pulumi.String("/SharedGalleries/{sharedGalleryUniqueName}/Images/{imageName}/Versions/1.0.0"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "FromImage"),
 *                 Map.entry("galleryImageReference", Map.of("sharedGalleryImageId", "/SharedGalleries/{sharedGalleryUniqueName}/Images/{imageName}/Versions/1.0.0"))
 *             ))
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from an Azure Compute Gallery image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "FromImage",
 *             GalleryImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 Id = "/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Providers/Microsoft.Compute/Galleries/{galleryName}/Images/{imageName}/Versions/1.0.0",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: compute.CreationDataResponse{
 * 				CreateOption: pulumi.String("FromImage"),
 * 				GalleryImageReference: &compute.ImageDiskReferenceArgs{
 * 					Id: pulumi.String("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Providers/Microsoft.Compute/Galleries/{galleryName}/Images/{imageName}/Versions/1.0.0"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "FromImage"),
 *                 Map.entry("galleryImageReference", Map.of("id", "/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Providers/Microsoft.Compute/Galleries/{galleryName}/Images/{imageName}/Versions/1.0.0"))
 *             ))
 *             .diskName("myDisk")
 *             .location("West US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk from an existing managed disk in the same or different subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Copy",
 *             SourceResourceId = "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myDisk1",
 *         },
 *         DiskName = "myDisk2",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String("Copy"),
 * 				SourceResourceId: pulumi.String("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myDisk1"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk2"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "Copy"),
 *                 Map.entry("sourceResourceId", "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myDisk1")
 *             ))
 *             .diskName("myDisk2")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with dataAccessAuthMode
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Empty",
 *         },
 *         DataAccessAuthMode = "AzureActiveDirectory",
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String("Empty"),
 * 			},
 * 			DataAccessAuthMode: pulumi.String("AzureActiveDirectory"),
 * 			DiskName:           pulumi.String("myDisk"),
 * 			DiskSizeGB:         pulumi.Int(200),
 * 			Location:           pulumi.String("West US"),
 * 			ResourceGroupName:  pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.of("createOption", "Empty"))
 *             .dataAccessAuthMode("AzureActiveDirectory")
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with optimizedForFrequentAttach.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Empty",
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         OptimizedForFrequentAttach = true,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String("Empty"),
 * 			},
 * 			DiskName:                   pulumi.String("myDisk"),
 * 			DiskSizeGB:                 pulumi.Int(200),
 * 			Location:                   pulumi.String("West US"),
 * 			OptimizedForFrequentAttach: pulumi.Bool(true),
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.of("createOption", "Empty"))
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .optimizedForFrequentAttach(true)
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with performancePlus.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Upload",
 *             PerformancePlus = true,
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:    pulumi.String("Upload"),
 * 				PerformancePlus: pulumi.Bool(true),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "Upload"),
 *                 Map.entry("performancePlus", true)
 *             ))
 *             .diskName("myDisk")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with premium v2 account type.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Empty",
 *         },
 *         DiskIOPSReadWrite = 125,
 *         DiskMBpsReadWrite = 3000,
 *         DiskName = "myPremiumV2Disk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.DiskSkuArgs
 *         {
 *             Name = "PremiumV2_LRS",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String("Empty"),
 * 			},
 * 			DiskIOPSReadWrite: pulumi.Float64(125),
 * 			DiskMBpsReadWrite: pulumi.Float64(3000),
 * 			DiskName:          pulumi.String("myPremiumV2Disk"),
 * 			DiskSizeGB:        pulumi.Int(200),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.DiskSkuArgs{
 * 				Name: pulumi.String("PremiumV2_LRS"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.of("createOption", "Empty"))
 *             .diskIOPSReadWrite(125)
 *             .diskMBpsReadWrite(3000)
 *             .diskName("myPremiumV2Disk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.of("name", "PremiumV2_LRS"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with security profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "FromImage",
 *             ImageReference = new AzureNative.Compute.Inputs.ImageDiskReferenceArgs
 *             {
 *                 Id = "/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/uswest/Publishers/Microsoft/ArtifactTypes/VMImage/Offers/{offer}",
 *             },
 *         },
 *         DiskName = "myDisk",
 *         Location = "North Central US",
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.DiskSecurityProfileArgs
 *         {
 *             SecurityType = "TrustedLaunch",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: compute.CreationDataResponse{
 * 				CreateOption: pulumi.String("FromImage"),
 * 				ImageReference: &compute.ImageDiskReferenceArgs{
 * 					Id: pulumi.String("/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/uswest/Publishers/Microsoft/ArtifactTypes/VMImage/Offers/{offer}"),
 * 				},
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("North Central US"),
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.DiskSecurityProfileArgs{
 * 				SecurityType: pulumi.String("TrustedLaunch"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "FromImage"),
 *                 Map.entry("imageReference", Map.of("id", "/Subscriptions/{subscriptionId}/Providers/Microsoft.Compute/Locations/uswest/Publishers/Microsoft/ArtifactTypes/VMImage/Offers/{offer}"))
 *             ))
 *             .diskName("myDisk")
 *             .location("North Central US")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(Map.of("securityType", "TrustedLaunch"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with ssd zrs account type.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Empty",
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.DiskSkuArgs
 *         {
 *             Name = "Premium_ZRS",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String("Empty"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			DiskSizeGB:        pulumi.Int(200),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.DiskSkuArgs{
 * 				Name: pulumi.String("Premium_ZRS"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.of("createOption", "Empty"))
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.of("name", "Premium_ZRS"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed disk with ultra account type with readOnly property set.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Empty",
 *             LogicalSectorSize = 4096,
 *         },
 *         DiskIOPSReadWrite = 125,
 *         DiskMBpsReadWrite = 3000,
 *         DiskName = "myUltraReadOnlyDisk",
 *         DiskSizeGB = 200,
 *         Encryption = new AzureNative.Compute.Inputs.EncryptionArgs
 *         {
 *             Type = "EncryptionAtRestWithPlatformKey",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.DiskSkuArgs
 *         {
 *             Name = "UltraSSD_LRS",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:      pulumi.String("Empty"),
 * 				LogicalSectorSize: pulumi.Int(4096),
 * 			},
 * 			DiskIOPSReadWrite: pulumi.Float64(125),
 * 			DiskMBpsReadWrite: pulumi.Float64(3000),
 * 			DiskName:          pulumi.String("myUltraReadOnlyDisk"),
 * 			DiskSizeGB:        pulumi.Int(200),
 * 			Encryption: &compute.EncryptionArgs{
 * 				Type: pulumi.String("EncryptionAtRestWithPlatformKey"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.DiskSkuArgs{
 * 				Name: pulumi.String("UltraSSD_LRS"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "Empty"),
 *                 Map.entry("logicalSectorSize", 4096)
 *             ))
 *             .diskIOPSReadWrite(125)
 *             .diskMBpsReadWrite(3000)
 *             .diskName("myUltraReadOnlyDisk")
 *             .diskSizeGB(200)
 *             .encryption(Map.of("type", "EncryptionAtRestWithPlatformKey"))
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.of("name", "UltraSSD_LRS"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a managed upload disk.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Upload",
 *             UploadSizeBytes = 10737418752,
 *         },
 *         DiskName = "myDisk",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:    pulumi.String("Upload"),
 * 				UploadSizeBytes: pulumi.Float64(10737418752),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "Upload"),
 *                 Map.entry("uploadSizeBytes", 10737418752)
 *             ))
 *             .diskName("myDisk")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an empty managed disk in extended location.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Empty",
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         ExtendedLocation = new AzureNative.Compute.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "{edge-zone-id}",
 *             Type = "EdgeZone",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String("Empty"),
 * 			},
 * 			DiskName:   pulumi.String("myDisk"),
 * 			DiskSizeGB: pulumi.Int(200),
 * 			ExtendedLocation: &compute.ExtendedLocationArgs{
 * 				Name: pulumi.String("{edge-zone-id}"),
 * 				Type: pulumi.String("EdgeZone"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.of("createOption", "Empty"))
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "{edge-zone-id}"),
 *                 Map.entry("type", "EdgeZone")
 *             ))
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an empty managed disk.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Empty",
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String("Empty"),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			DiskSizeGB:        pulumi.Int(200),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.of("createOption", "Empty"))
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an ultra managed disk with logicalSectorSize 512E
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.Compute.Disk("disk", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Empty",
 *             LogicalSectorSize = 512,
 *         },
 *         DiskName = "myDisk",
 *         DiskSizeGB = 200,
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.DiskSkuArgs
 *         {
 *             Name = "UltraSSD_LRS",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDisk(ctx, "disk", &compute.DiskArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:      pulumi.String("Empty"),
 * 				LogicalSectorSize: pulumi.Int(512),
 * 			},
 * 			DiskName:          pulumi.String("myDisk"),
 * 			DiskSizeGB:        pulumi.Int(200),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &compute.DiskSkuArgs{
 * 				Name: pulumi.String("UltraSSD_LRS"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Disk;
 * import com.pulumi.azurenative.compute.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "Empty"),
 *                 Map.entry("logicalSectorSize", 512)
 *             ))
 *             .diskName("myDisk")
 *             .diskSizeGB(200)
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.of("name", "UltraSSD_LRS"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:Disk myDisk /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}
 * ```
 * @property burstingEnabled Set to true to enable bursting beyond the provisioned performance target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
 * @property completionPercent Percentage complete for the background copy when a resource is created via the CopyStart operation.
 * @property creationData Disk source information. CreationData information cannot be changed after the disk has been created.
 * @property dataAccessAuthMode Additional authentication requirements when exporting or uploading to a disk or snapshot.
 * @property diskAccessId ARM id of the DiskAccess resource for using private endpoints on disks.
 * @property diskIOPSReadOnly The total number of IOPS that will be allowed across all VMs mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
 * @property diskIOPSReadWrite The number of IOPS allowed for this disk; only settable for UltraSSD disks. One operation can transfer between 4k and 256k bytes.
 * @property diskMBpsReadOnly The total throughput (MBps) that will be allowed across all VMs mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
 * @property diskMBpsReadWrite The bandwidth allowed for this disk; only settable for UltraSSD disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
 * @property diskName The name of the managed disk that is being created. The name can't be changed after the disk is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
 * @property diskSizeGB If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
 * @property encryption Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
 * @property encryptionSettingsCollection Encryption settings collection used for Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
 * @property extendedLocation The extended location where the disk will be created. Extended location cannot be changed.
 * @property hyperVGeneration The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
 * @property location Resource location
 * @property maxShares The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
 * @property networkAccessPolicy Policy for accessing the disk via network.
 * @property optimizedForFrequentAttach Setting this property to true improves reliability and performance of data disks that are frequently (more than 5 times a day) by detached from one virtual machine and attached to another. This property should not be set for disks that are not detached and attached frequently as it causes the disks to not align with the fault domain of the virtual machine.
 * @property osType The Operating System type.
 * @property publicNetworkAccess Policy for controlling export on the disk.
 * @property purchasePlan Purchase plan information for the the image from which the OS disk was created. E.g. - {name: 2019-Datacenter, publisher: MicrosoftWindowsServer, product: WindowsServer}
 * @property resourceGroupName The name of the resource group.
 * @property securityProfile Contains the security related information for the resource.
 * @property sku The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
 * @property supportedCapabilities List of supported capabilities for the image from which the OS disk was created.
 * @property supportsHibernation Indicates the OS on a disk supports hibernation.
 * @property tags Resource tags
 * @property tier Performance tier of the disk (e.g, P4, S10) as described here: https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra disks.
 * @property zones The Logical zone list for Disk.
 */
public data class DiskArgs(
    public val burstingEnabled: Output<Boolean>? = null,
    public val completionPercent: Output<Double>? = null,
    public val creationData: Output<CreationDataArgs>? = null,
    public val dataAccessAuthMode: Output<Either<String, DataAccessAuthMode>>? = null,
    public val diskAccessId: Output<String>? = null,
    public val diskIOPSReadOnly: Output<Double>? = null,
    public val diskIOPSReadWrite: Output<Double>? = null,
    public val diskMBpsReadOnly: Output<Double>? = null,
    public val diskMBpsReadWrite: Output<Double>? = null,
    public val diskName: Output<String>? = null,
    public val diskSizeGB: Output<Int>? = null,
    public val encryption: Output<EncryptionArgs>? = null,
    public val encryptionSettingsCollection: Output<EncryptionSettingsCollectionArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val hyperVGeneration: Output<Either<String, HyperVGeneration>>? = null,
    public val location: Output<String>? = null,
    public val maxShares: Output<Int>? = null,
    public val networkAccessPolicy: Output<Either<String, NetworkAccessPolicy>>? = null,
    public val optimizedForFrequentAttach: Output<Boolean>? = null,
    public val osType: Output<OperatingSystemTypes>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val purchasePlan: Output<PurchasePlanArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityProfile: Output<DiskSecurityProfileArgs>? = null,
    public val sku: Output<DiskSkuArgs>? = null,
    public val supportedCapabilities: Output<SupportedCapabilitiesArgs>? = null,
    public val supportsHibernation: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tier: Output<String>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.DiskArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.DiskArgs =
        com.pulumi.azurenative.compute.DiskArgs.builder()
            .burstingEnabled(burstingEnabled?.applyValue({ args0 -> args0 }))
            .completionPercent(completionPercent?.applyValue({ args0 -> args0 }))
            .creationData(creationData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataAccessAuthMode(
                dataAccessAuthMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .diskAccessId(diskAccessId?.applyValue({ args0 -> args0 }))
            .diskIOPSReadOnly(diskIOPSReadOnly?.applyValue({ args0 -> args0 }))
            .diskIOPSReadWrite(diskIOPSReadWrite?.applyValue({ args0 -> args0 }))
            .diskMBpsReadOnly(diskMBpsReadOnly?.applyValue({ args0 -> args0 }))
            .diskMBpsReadWrite(diskMBpsReadWrite?.applyValue({ args0 -> args0 }))
            .diskName(diskName?.applyValue({ args0 -> args0 }))
            .diskSizeGB(diskSizeGB?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encryptionSettingsCollection(
                encryptionSettingsCollection?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hyperVGeneration(
                hyperVGeneration?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .maxShares(maxShares?.applyValue({ args0 -> args0 }))
            .networkAccessPolicy(
                networkAccessPolicy?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .optimizedForFrequentAttach(optimizedForFrequentAttach?.applyValue({ args0 -> args0 }))
            .osType(osType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .purchasePlan(purchasePlan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityProfile(securityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .supportedCapabilities(
                supportedCapabilities?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .supportsHibernation(supportsHibernation?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tier(tier?.applyValue({ args0 -> args0 }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DiskArgs].
 */
@PulumiTagMarker
public class DiskArgsBuilder internal constructor() {
    private var burstingEnabled: Output<Boolean>? = null

    private var completionPercent: Output<Double>? = null

    private var creationData: Output<CreationDataArgs>? = null

    private var dataAccessAuthMode: Output<Either<String, DataAccessAuthMode>>? = null

    private var diskAccessId: Output<String>? = null

    private var diskIOPSReadOnly: Output<Double>? = null

    private var diskIOPSReadWrite: Output<Double>? = null

    private var diskMBpsReadOnly: Output<Double>? = null

    private var diskMBpsReadWrite: Output<Double>? = null

    private var diskName: Output<String>? = null

    private var diskSizeGB: Output<Int>? = null

    private var encryption: Output<EncryptionArgs>? = null

    private var encryptionSettingsCollection: Output<EncryptionSettingsCollectionArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var hyperVGeneration: Output<Either<String, HyperVGeneration>>? = null

    private var location: Output<String>? = null

    private var maxShares: Output<Int>? = null

    private var networkAccessPolicy: Output<Either<String, NetworkAccessPolicy>>? = null

    private var optimizedForFrequentAttach: Output<Boolean>? = null

    private var osType: Output<OperatingSystemTypes>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var purchasePlan: Output<PurchasePlanArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityProfile: Output<DiskSecurityProfileArgs>? = null

    private var sku: Output<DiskSkuArgs>? = null

    private var supportedCapabilities: Output<SupportedCapabilitiesArgs>? = null

    private var supportsHibernation: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tier: Output<String>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Set to true to enable bursting beyond the provisioned performance target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
     */
    @JvmName("effimjmimwrmrnkb")
    public suspend fun burstingEnabled(`value`: Output<Boolean>) {
        this.burstingEnabled = value
    }

    /**
     * @param value Percentage complete for the background copy when a resource is created via the CopyStart operation.
     */
    @JvmName("agayhqtcsswjgsam")
    public suspend fun completionPercent(`value`: Output<Double>) {
        this.completionPercent = value
    }

    /**
     * @param value Disk source information. CreationData information cannot be changed after the disk has been created.
     */
    @JvmName("ffskgfwnkbucgvdo")
    public suspend fun creationData(`value`: Output<CreationDataArgs>) {
        this.creationData = value
    }

    /**
     * @param value Additional authentication requirements when exporting or uploading to a disk or snapshot.
     */
    @JvmName("emdxsnnomuywtoge")
    public suspend fun dataAccessAuthMode(`value`: Output<Either<String, DataAccessAuthMode>>) {
        this.dataAccessAuthMode = value
    }

    /**
     * @param value ARM id of the DiskAccess resource for using private endpoints on disks.
     */
    @JvmName("vygoornvriagiryy")
    public suspend fun diskAccessId(`value`: Output<String>) {
        this.diskAccessId = value
    }

    /**
     * @param value The total number of IOPS that will be allowed across all VMs mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
     */
    @JvmName("evfqpwmnygmetxrw")
    public suspend fun diskIOPSReadOnly(`value`: Output<Double>) {
        this.diskIOPSReadOnly = value
    }

    /**
     * @param value The number of IOPS allowed for this disk; only settable for UltraSSD disks. One operation can transfer between 4k and 256k bytes.
     */
    @JvmName("rowsjduexyvqpesb")
    public suspend fun diskIOPSReadWrite(`value`: Output<Double>) {
        this.diskIOPSReadWrite = value
    }

    /**
     * @param value The total throughput (MBps) that will be allowed across all VMs mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
     */
    @JvmName("saaqtjndmmvhgqat")
    public suspend fun diskMBpsReadOnly(`value`: Output<Double>) {
        this.diskMBpsReadOnly = value
    }

    /**
     * @param value The bandwidth allowed for this disk; only settable for UltraSSD disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
     */
    @JvmName("qsibqqjrfmfcxuka")
    public suspend fun diskMBpsReadWrite(`value`: Output<Double>) {
        this.diskMBpsReadWrite = value
    }

    /**
     * @param value The name of the managed disk that is being created. The name can't be changed after the disk is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     */
    @JvmName("oqqsswsiwjwngqqt")
    public suspend fun diskName(`value`: Output<String>) {
        this.diskName = value
    }

    /**
     * @param value If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
     */
    @JvmName("bgvcghekcqkonhsv")
    public suspend fun diskSizeGB(`value`: Output<Int>) {
        this.diskSizeGB = value
    }

    /**
     * @param value Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
     */
    @JvmName("rqvppaxgxhfaktbw")
    public suspend fun encryption(`value`: Output<EncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value Encryption settings collection used for Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
     */
    @JvmName("tptcxrlbsgsilgoj")
    public suspend
    fun encryptionSettingsCollection(`value`: Output<EncryptionSettingsCollectionArgs>) {
        this.encryptionSettingsCollection = value
    }

    /**
     * @param value The extended location where the disk will be created. Extended location cannot be changed.
     */
    @JvmName("sbfhbtwxlqprdlpd")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    @JvmName("lgmlabwthtrsbaju")
    public suspend fun hyperVGeneration(`value`: Output<Either<String, HyperVGeneration>>) {
        this.hyperVGeneration = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("areuwvhflalwtxpc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
     */
    @JvmName("thgpkvfgqrenohxu")
    public suspend fun maxShares(`value`: Output<Int>) {
        this.maxShares = value
    }

    /**
     * @param value Policy for accessing the disk via network.
     */
    @JvmName("ohwgfbmiskvpwyml")
    public suspend fun networkAccessPolicy(`value`: Output<Either<String, NetworkAccessPolicy>>) {
        this.networkAccessPolicy = value
    }

    /**
     * @param value Setting this property to true improves reliability and performance of data disks that are frequently (more than 5 times a day) by detached from one virtual machine and attached to another. This property should not be set for disks that are not detached and attached frequently as it causes the disks to not align with the fault domain of the virtual machine.
     */
    @JvmName("uesyanbmfrepdypf")
    public suspend fun optimizedForFrequentAttach(`value`: Output<Boolean>) {
        this.optimizedForFrequentAttach = value
    }

    /**
     * @param value The Operating System type.
     */
    @JvmName("gninehdirgdqibbv")
    public suspend fun osType(`value`: Output<OperatingSystemTypes>) {
        this.osType = value
    }

    /**
     * @param value Policy for controlling export on the disk.
     */
    @JvmName("emrwclwwjdruhmik")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Purchase plan information for the the image from which the OS disk was created. E.g. - {name: 2019-Datacenter, publisher: MicrosoftWindowsServer, product: WindowsServer}
     */
    @JvmName("eburnggnufwoilqf")
    public suspend fun purchasePlan(`value`: Output<PurchasePlanArgs>) {
        this.purchasePlan = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("crcglhyfcuwafcpm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Contains the security related information for the resource.
     */
    @JvmName("rbkdssosmuuhlaip")
    public suspend fun securityProfile(`value`: Output<DiskSecurityProfileArgs>) {
        this.securityProfile = value
    }

    /**
     * @param value The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
     */
    @JvmName("swlsmvlwywnhrlht")
    public suspend fun sku(`value`: Output<DiskSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value List of supported capabilities for the image from which the OS disk was created.
     */
    @JvmName("kubjcqwrltqmuiny")
    public suspend fun supportedCapabilities(`value`: Output<SupportedCapabilitiesArgs>) {
        this.supportedCapabilities = value
    }

    /**
     * @param value Indicates the OS on a disk supports hibernation.
     */
    @JvmName("codmyligivngovvy")
    public suspend fun supportsHibernation(`value`: Output<Boolean>) {
        this.supportsHibernation = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("kmygodwsohogxegq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Performance tier of the disk (e.g, P4, S10) as described here: https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra disks.
     */
    @JvmName("rwfeeanridfvddjt")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value The Logical zone list for Disk.
     */
    @JvmName("fierkpgxxdwnshra")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("msyexcawkyiuhbbk")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values The Logical zone list for Disk.
     */
    @JvmName("fpyyujgvdntucgeg")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Set to true to enable bursting beyond the provisioned performance target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
     */
    @JvmName("xallywdwqfdoydpy")
    public suspend fun burstingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.burstingEnabled = mapped
    }

    /**
     * @param value Percentage complete for the background copy when a resource is created via the CopyStart operation.
     */
    @JvmName("wkvmalejaciitcdl")
    public suspend fun completionPercent(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.completionPercent = mapped
    }

    /**
     * @param value Disk source information. CreationData information cannot be changed after the disk has been created.
     */
    @JvmName("gyceypdgsbkvpeyx")
    public suspend fun creationData(`value`: CreationDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationData = mapped
    }

    /**
     * @param argument Disk source information. CreationData information cannot be changed after the disk has been created.
     */
    @JvmName("dlqfvnplodhfatve")
    public suspend fun creationData(argument: suspend CreationDataArgsBuilder.() -> Unit) {
        val toBeMapped = CreationDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.creationData = mapped
    }

    /**
     * @param value Additional authentication requirements when exporting or uploading to a disk or snapshot.
     */
    @JvmName("liokcrjxonehmmmq")
    public suspend fun dataAccessAuthMode(`value`: Either<String, DataAccessAuthMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataAccessAuthMode = mapped
    }

    /**
     * @param value Additional authentication requirements when exporting or uploading to a disk or snapshot.
     */
    @JvmName("dqtmaegvnywdmdey")
    public fun dataAccessAuthMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataAccessAuthMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataAccessAuthMode = mapped
    }

    /**
     * @param value Additional authentication requirements when exporting or uploading to a disk or snapshot.
     */
    @JvmName("dxjvqntqusshvthk")
    public fun dataAccessAuthMode(`value`: DataAccessAuthMode) {
        val toBeMapped = Either.ofRight<String, DataAccessAuthMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataAccessAuthMode = mapped
    }

    /**
     * @param value ARM id of the DiskAccess resource for using private endpoints on disks.
     */
    @JvmName("pvuwhnueqwyjjdqk")
    public suspend fun diskAccessId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskAccessId = mapped
    }

    /**
     * @param value The total number of IOPS that will be allowed across all VMs mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
     */
    @JvmName("qehyilyfomifjtsj")
    public suspend fun diskIOPSReadOnly(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskIOPSReadOnly = mapped
    }

    /**
     * @param value The number of IOPS allowed for this disk; only settable for UltraSSD disks. One operation can transfer between 4k and 256k bytes.
     */
    @JvmName("oilfjmuavmpffkvu")
    public suspend fun diskIOPSReadWrite(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskIOPSReadWrite = mapped
    }

    /**
     * @param value The total throughput (MBps) that will be allowed across all VMs mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
     */
    @JvmName("qryjymyviburdumg")
    public suspend fun diskMBpsReadOnly(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskMBpsReadOnly = mapped
    }

    /**
     * @param value The bandwidth allowed for this disk; only settable for UltraSSD disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of 10.
     */
    @JvmName("nxkbfwxcsoioajrm")
    public suspend fun diskMBpsReadWrite(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskMBpsReadWrite = mapped
    }

    /**
     * @param value The name of the managed disk that is being created. The name can't be changed after the disk is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     */
    @JvmName("qqpxpqylycljemtg")
    public suspend fun diskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskName = mapped
    }

    /**
     * @param value If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
     */
    @JvmName("najcceuxneosndpc")
    public suspend fun diskSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
     */
    @JvmName("anfjuywytffixdov")
    public suspend fun encryption(`value`: EncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
     */
    @JvmName("ghjnhudbcvwbrfhw")
    public suspend fun encryption(argument: suspend EncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Encryption settings collection used for Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
     */
    @JvmName("uqcybjxtvgnnnukv")
    public suspend fun encryptionSettingsCollection(`value`: EncryptionSettingsCollectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionSettingsCollection = mapped
    }

    /**
     * @param argument Encryption settings collection used for Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
     */
    @JvmName("knwvwxvvfowytkwc")
    public suspend
    fun encryptionSettingsCollection(argument: suspend EncryptionSettingsCollectionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionSettingsCollectionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionSettingsCollection = mapped
    }

    /**
     * @param value The extended location where the disk will be created. Extended location cannot be changed.
     */
    @JvmName("pfspvafbvkmlyccy")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location where the disk will be created. Extended location cannot be changed.
     */
    @JvmName("sfmdsrxajlgtqsnl")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    @JvmName("wmxvbsuqrtxeeglf")
    public suspend fun hyperVGeneration(`value`: Either<String, HyperVGeneration>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    @JvmName("mtyvddmpmlutdybs")
    public fun hyperVGeneration(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HyperVGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    @JvmName("xhyfdvucvqimcuvu")
    public fun hyperVGeneration(`value`: HyperVGeneration) {
        val toBeMapped = Either.ofRight<String, HyperVGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("botqjqoptfltksca")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
     */
    @JvmName("vvomwuxjkyfyhnuj")
    public suspend fun maxShares(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxShares = mapped
    }

    /**
     * @param value Policy for accessing the disk via network.
     */
    @JvmName("qcdgrqhvpdpylqba")
    public suspend fun networkAccessPolicy(`value`: Either<String, NetworkAccessPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAccessPolicy = mapped
    }

    /**
     * @param value Policy for accessing the disk via network.
     */
    @JvmName("whdviwoykbnqncva")
    public fun networkAccessPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkAccessPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkAccessPolicy = mapped
    }

    /**
     * @param value Policy for accessing the disk via network.
     */
    @JvmName("vaspgqengggppssg")
    public fun networkAccessPolicy(`value`: NetworkAccessPolicy) {
        val toBeMapped = Either.ofRight<String, NetworkAccessPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkAccessPolicy = mapped
    }

    /**
     * @param value Setting this property to true improves reliability and performance of data disks that are frequently (more than 5 times a day) by detached from one virtual machine and attached to another. This property should not be set for disks that are not detached and attached frequently as it causes the disks to not align with the fault domain of the virtual machine.
     */
    @JvmName("edxrqtwqoumndgdj")
    public suspend fun optimizedForFrequentAttach(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimizedForFrequentAttach = mapped
    }

    /**
     * @param value The Operating System type.
     */
    @JvmName("bqpmwcoabgtmncvg")
    public suspend fun osType(`value`: OperatingSystemTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Policy for controlling export on the disk.
     */
    @JvmName("avjnrwsshwpygnmb")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Policy for controlling export on the disk.
     */
    @JvmName("mjooeoxmaufocjnn")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Policy for controlling export on the disk.
     */
    @JvmName("ljybdhiiskbvxnje")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Purchase plan information for the the image from which the OS disk was created. E.g. - {name: 2019-Datacenter, publisher: MicrosoftWindowsServer, product: WindowsServer}
     */
    @JvmName("vihgvdyfdbhpnwbo")
    public suspend fun purchasePlan(`value`: PurchasePlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.purchasePlan = mapped
    }

    /**
     * @param argument Purchase plan information for the the image from which the OS disk was created. E.g. - {name: 2019-Datacenter, publisher: MicrosoftWindowsServer, product: WindowsServer}
     */
    @JvmName("pdfktryycqyfeqox")
    public suspend fun purchasePlan(argument: suspend PurchasePlanArgsBuilder.() -> Unit) {
        val toBeMapped = PurchasePlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.purchasePlan = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nmiinvwpxtowxnlh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Contains the security related information for the resource.
     */
    @JvmName("pwxlskmldqtdidgx")
    public suspend fun securityProfile(`value`: DiskSecurityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfile = mapped
    }

    /**
     * @param argument Contains the security related information for the resource.
     */
    @JvmName("vwrgydbusrpqkndp")
    public suspend fun securityProfile(argument: suspend DiskSecurityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = DiskSecurityProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityProfile = mapped
    }

    /**
     * @param value The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
     */
    @JvmName("xuoxrvqvmvhduklr")
    public suspend fun sku(`value`: DiskSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
     */
    @JvmName("tfohcydmweqpcqjb")
    public suspend fun sku(argument: suspend DiskSkuArgsBuilder.() -> Unit) {
        val toBeMapped = DiskSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value List of supported capabilities for the image from which the OS disk was created.
     */
    @JvmName("twobogxygakdnikt")
    public suspend fun supportedCapabilities(`value`: SupportedCapabilitiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportedCapabilities = mapped
    }

    /**
     * @param argument List of supported capabilities for the image from which the OS disk was created.
     */
    @JvmName("bavbuxiormdcfcyk")
    public suspend
    fun supportedCapabilities(argument: suspend SupportedCapabilitiesArgsBuilder.() -> Unit) {
        val toBeMapped = SupportedCapabilitiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.supportedCapabilities = mapped
    }

    /**
     * @param value Indicates the OS on a disk supports hibernation.
     */
    @JvmName("aisedsisukrtsdoa")
    public suspend fun supportsHibernation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportsHibernation = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("liyacbwraxldmwlj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("ohqfumtwpjkbafsh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Performance tier of the disk (e.g, P4, S10) as described here: https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra disks.
     */
    @JvmName("nfwnqrtjmgwbtyru")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The Logical zone list for Disk.
     */
    @JvmName("nrtysiqlgpgrtmtu")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values The Logical zone list for Disk.
     */
    @JvmName("ayjfxrdqxklkdndx")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): DiskArgs = DiskArgs(
        burstingEnabled = burstingEnabled,
        completionPercent = completionPercent,
        creationData = creationData,
        dataAccessAuthMode = dataAccessAuthMode,
        diskAccessId = diskAccessId,
        diskIOPSReadOnly = diskIOPSReadOnly,
        diskIOPSReadWrite = diskIOPSReadWrite,
        diskMBpsReadOnly = diskMBpsReadOnly,
        diskMBpsReadWrite = diskMBpsReadWrite,
        diskName = diskName,
        diskSizeGB = diskSizeGB,
        encryption = encryption,
        encryptionSettingsCollection = encryptionSettingsCollection,
        extendedLocation = extendedLocation,
        hyperVGeneration = hyperVGeneration,
        location = location,
        maxShares = maxShares,
        networkAccessPolicy = networkAccessPolicy,
        optimizedForFrequentAttach = optimizedForFrequentAttach,
        osType = osType,
        publicNetworkAccess = publicNetworkAccess,
        purchasePlan = purchasePlan,
        resourceGroupName = resourceGroupName,
        securityProfile = securityProfile,
        sku = sku,
        supportedCapabilities = supportedCapabilities,
        supportsHibernation = supportsHibernation,
        tags = tags,
        tier = tier,
        zones = zones,
    )
}
