@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.ApiErrorResponse
import com.pulumi.azurenative.compute.kotlin.outputs.EncryptionSetIdentityResponse
import com.pulumi.azurenative.compute.kotlin.outputs.KeyForDiskEncryptionSetResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.ApiErrorResponse.Companion.toKotlin as apiErrorResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.EncryptionSetIdentityResponse.Companion.toKotlin as encryptionSetIdentityResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.KeyForDiskEncryptionSetResponse.Companion.toKotlin as keyForDiskEncryptionSetResponseToKotlin

/**
 * Builder for [DiskEncryptionSet].
 */
@PulumiTagMarker
public class DiskEncryptionSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiskEncryptionSetArgs = DiskEncryptionSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiskEncryptionSetArgsBuilder.() -> Unit) {
        val builder = DiskEncryptionSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DiskEncryptionSet {
        val builtJavaResource =
            com.pulumi.azurenative.compute.DiskEncryptionSet(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DiskEncryptionSet(builtJavaResource)
    }
}

/**
 * disk encryption set resource.
 * Azure REST API version: 2022-07-02. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-06-30, 2023-01-02, 2023-04-02, 2023-10-02.
 * ## Example Usage
 * ### Create a disk encryption set with key vault from a different subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diskEncryptionSet = new AzureNative.Compute.DiskEncryptionSet("diskEncryptionSet", new()
 *     {
 *         ActiveKey = new AzureNative.Compute.Inputs.KeyForDiskEncryptionSetArgs
 *         {
 *             KeyUrl = "https://myvaultdifferentsub.vault-int.azure-int.net/keys/{key}",
 *         },
 *         DiskEncryptionSetName = "myDiskEncryptionSet",
 *         EncryptionType = "EncryptionAtRestWithCustomerKey",
 *         Identity = new AzureNative.Compute.Inputs.EncryptionSetIdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDiskEncryptionSet(ctx, "diskEncryptionSet", &compute.DiskEncryptionSetArgs{
 * 			ActiveKey: &compute.KeyForDiskEncryptionSetArgs{
 * 				KeyUrl: pulumi.String("https://myvaultdifferentsub.vault-int.azure-int.net/keys/{key}"),
 * 			},
 * 			DiskEncryptionSetName: pulumi.String("myDiskEncryptionSet"),
 * 			EncryptionType:        pulumi.String("EncryptionAtRestWithCustomerKey"),
 * 			Identity: &compute.EncryptionSetIdentityArgs{
 * 				Type: pulumi.String("SystemAssigned"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.DiskEncryptionSet;
 * import com.pulumi.azurenative.compute.DiskEncryptionSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diskEncryptionSet = new DiskEncryptionSet("diskEncryptionSet", DiskEncryptionSetArgs.builder()
 *             .activeKey(Map.of("keyUrl", "https://myvaultdifferentsub.vault-int.azure-int.net/keys/{key}"))
 *             .diskEncryptionSetName("myDiskEncryptionSet")
 *             .encryptionType("EncryptionAtRestWithCustomerKey")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a disk encryption set.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diskEncryptionSet = new AzureNative.Compute.DiskEncryptionSet("diskEncryptionSet", new()
 *     {
 *         ActiveKey = new AzureNative.Compute.Inputs.KeyForDiskEncryptionSetArgs
 *         {
 *             KeyUrl = "https://myvmvault.vault-int.azure-int.net/keys/{key}",
 *             SourceVault = new AzureNative.Compute.Inputs.SourceVaultArgs
 *             {
 *                 Id = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.KeyVault/vaults/myVMVault",
 *             },
 *         },
 *         DiskEncryptionSetName = "myDiskEncryptionSet",
 *         EncryptionType = "EncryptionAtRestWithCustomerKey",
 *         Identity = new AzureNative.Compute.Inputs.EncryptionSetIdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDiskEncryptionSet(ctx, "diskEncryptionSet", &compute.DiskEncryptionSetArgs{
 * 			ActiveKey: compute.KeyForDiskEncryptionSetResponse{
 * 				KeyUrl: pulumi.String("https://myvmvault.vault-int.azure-int.net/keys/{key}"),
 * 				SourceVault: &compute.SourceVaultArgs{
 * 					Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.KeyVault/vaults/myVMVault"),
 * 				},
 * 			},
 * 			DiskEncryptionSetName: pulumi.String("myDiskEncryptionSet"),
 * 			EncryptionType:        pulumi.String("EncryptionAtRestWithCustomerKey"),
 * 			Identity: &compute.EncryptionSetIdentityArgs{
 * 				Type: pulumi.String("SystemAssigned"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.DiskEncryptionSet;
 * import com.pulumi.azurenative.compute.DiskEncryptionSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diskEncryptionSet = new DiskEncryptionSet("diskEncryptionSet", DiskEncryptionSetArgs.builder()
 *             .activeKey(Map.ofEntries(
 *                 Map.entry("keyUrl", "https://myvmvault.vault-int.azure-int.net/keys/{key}"),
 *                 Map.entry("sourceVault", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.KeyVault/vaults/myVMVault"))
 *             ))
 *             .diskEncryptionSetName("myDiskEncryptionSet")
 *             .encryptionType("EncryptionAtRestWithCustomerKey")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:DiskEncryptionSet myDiskEncryptionSet /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}
 * ```
 */
public class DiskEncryptionSet internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.DiskEncryptionSet,
) : KotlinCustomResource(javaResource, DiskEncryptionSetMapper) {
    /**
     * The key vault key which is currently used by this disk encryption set.
     */
    public val activeKey: Output<KeyForDiskEncryptionSetResponse>?
        get() = javaResource.activeKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    keyForDiskEncryptionSetResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The error that was encountered during auto-key rotation. If an error is present, then auto-key rotation will not be attempted until the error on this disk encryption set is fixed.
     */
    public val autoKeyRotationError: Output<ApiErrorResponse>
        get() = javaResource.autoKeyRotationError().applyValue({ args0 ->
            args0.let({ args0 ->
                apiErrorResponseToKotlin(args0)
            })
        })

    /**
     * The type of key used to encrypt the data of the disk.
     */
    public val encryptionType: Output<String>?
        get() = javaResource.encryptionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Multi-tenant application client id to access key vault in a different tenant. Setting the value to 'None' will clear the property.
     */
    public val federatedClientId: Output<String>?
        get() = javaResource.federatedClientId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The managed identity for the disk encryption set. It should be given permission on the key vault before it can be used to encrypt disks.
     */
    public val identity: Output<EncryptionSetIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    encryptionSetIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The time when the active key of this disk encryption set was updated.
     */
    public val lastKeyRotationTimestamp: Output<String>
        get() = javaResource.lastKeyRotationTimestamp().applyValue({ args0 -> args0 })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A readonly collection of key vault keys previously used by this disk encryption set while a key rotation is in progress. It will be empty if there is no ongoing key rotation.
     */
    public val previousKeys: Output<List<KeyForDiskEncryptionSetResponse>>
        get() = javaResource.previousKeys().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    keyForDiskEncryptionSetResponseToKotlin(args0)
                })
            })
        })

    /**
     * The disk encryption set provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Set this flag to true to enable auto-updating of this disk encryption set to the latest key version.
     */
    public val rotationToLatestKeyVersionEnabled: Output<Boolean>?
        get() = javaResource.rotationToLatestKeyVersionEnabled().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DiskEncryptionSetMapper : ResourceMapper<DiskEncryptionSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.DiskEncryptionSet::class == javaResource::class

    override fun map(javaResource: Resource): DiskEncryptionSet = DiskEncryptionSet(
        javaResource as
            com.pulumi.azurenative.compute.DiskEncryptionSet,
    )
}

/**
 * @see [DiskEncryptionSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DiskEncryptionSet].
 */
public suspend fun diskEncryptionSet(
    name: String,
    block: suspend DiskEncryptionSetResourceBuilder.() -> Unit,
): DiskEncryptionSet {
    val builder = DiskEncryptionSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DiskEncryptionSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun diskEncryptionSet(name: String): DiskEncryptionSet {
    val builder = DiskEncryptionSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
