@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.GalleryApplicationCustomActionResponse
import com.pulumi.azurenative.compute.kotlin.outputs.GalleryApplicationCustomActionResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [GalleryApplication].
 */
@PulumiTagMarker
public class GalleryApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GalleryApplicationArgs = GalleryApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GalleryApplicationArgsBuilder.() -> Unit) {
        val builder = GalleryApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GalleryApplication {
        val builtJavaResource =
            com.pulumi.azurenative.compute.GalleryApplication(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GalleryApplication(builtJavaResource)
    }
}

/**
 * Specifies information about the gallery Application Definition that you want to create or update.
 * Azure REST API version: 2022-03-03. Prior API version in Azure Native 1.x: 2020-09-30.
 * Other available API versions: 2022-08-03, 2023-07-03.
 * ## Example Usage
 * ### Create or update a simple gallery Application.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryApplication = new AzureNative.Compute.GalleryApplication("galleryApplication", new()
 *     {
 *         CustomActions = new[]
 *         {
 *             new AzureNative.Compute.Inputs.GalleryApplicationCustomActionArgs
 *             {
 *                 Description = "This is the custom action description.",
 *                 Name = "myCustomAction",
 *                 Parameters = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.GalleryApplicationCustomActionParameterArgs
 *                     {
 *                         DefaultValue = "default value of parameter.",
 *                         Description = "This is the description of the parameter",
 *                         Name = "myCustomActionParameter",
 *                         Required = false,
 *                         Type = AzureNative.Compute.GalleryApplicationCustomActionParameterType.String,
 *                     },
 *                 },
 *                 Script = "myCustomActionScript",
 *             },
 *         },
 *         Description = "This is the gallery application description.",
 *         Eula = "This is the gallery application EULA.",
 *         GalleryApplicationName = "myGalleryApplicationName",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PrivacyStatementUri = "myPrivacyStatementUri}",
 *         ReleaseNoteUri = "myReleaseNoteUri",
 *         ResourceGroupName = "myResourceGroup",
 *         SupportedOSType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewGalleryApplication(ctx, "galleryApplication", &compute.GalleryApplicationArgs{
 * 			CustomActions: []compute.GalleryApplicationCustomActionArgs{
 * 				{
 * 					Description: pulumi.String("This is the custom action description."),
 * 					Name:        pulumi.String("myCustomAction"),
 * 					Parameters: compute.GalleryApplicationCustomActionParameterArray{
 * 						{
 * 							DefaultValue: pulumi.String("default value of parameter."),
 * 							Description:  pulumi.String("This is the description of the parameter"),
 * 							Name:         pulumi.String("myCustomActionParameter"),
 * 							Required:     pulumi.Bool(false),
 * 							Type:         compute.GalleryApplicationCustomActionParameterTypeString,
 * 						},
 * 					},
 * 					Script: pulumi.String("myCustomActionScript"),
 * 				},
 * 			},
 * 			Description:            pulumi.String("This is the gallery application description."),
 * 			Eula:                   pulumi.String("This is the gallery application EULA."),
 * 			GalleryApplicationName: pulumi.String("myGalleryApplicationName"),
 * 			GalleryName:            pulumi.String("myGalleryName"),
 * 			Location:               pulumi.String("West US"),
 * 			PrivacyStatementUri:    pulumi.String("myPrivacyStatementUri}"),
 * 			ReleaseNoteUri:         pulumi.String("myReleaseNoteUri"),
 * 			ResourceGroupName:      pulumi.String("myResourceGroup"),
 * 			SupportedOSType:        compute.OperatingSystemTypesWindows,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryApplication;
 * import com.pulumi.azurenative.compute.GalleryApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryApplication = new GalleryApplication("galleryApplication", GalleryApplicationArgs.builder()
 *             .customActions(Map.ofEntries(
 *                 Map.entry("description", "This is the custom action description."),
 *                 Map.entry("name", "myCustomAction"),
 *                 Map.entry("parameters", Map.ofEntries(
 *                     Map.entry("defaultValue", "default value of parameter."),
 *                     Map.entry("description", "This is the description of the parameter"),
 *                     Map.entry("name", "myCustomActionParameter"),
 *                     Map.entry("required", false),
 *                     Map.entry("type", "String")
 *                 )),
 *                 Map.entry("script", "myCustomActionScript")
 *             ))
 *             .description("This is the gallery application description.")
 *             .eula("This is the gallery application EULA.")
 *             .galleryApplicationName("myGalleryApplicationName")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .privacyStatementUri("myPrivacyStatementUri}")
 *             .releaseNoteUri("myReleaseNoteUri")
 *             .resourceGroupName("myResourceGroup")
 *             .supportedOSType("Windows")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:GalleryApplication myGalleryApplicationName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}
 * ```
 */
public class GalleryApplication internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.GalleryApplication,
) : KotlinCustomResource(javaResource, GalleryApplicationMapper) {
    /**
     * A list of custom actions that can be performed with all of the Gallery Application Versions within this Gallery Application.
     */
    public val customActions: Output<List<GalleryApplicationCustomActionResponse>>?
        get() = javaResource.customActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The description of this gallery Application Definition resource. This property is updatable.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The end of life date of the gallery Application Definition. This property can be used for decommissioning purposes. This property is updatable.
     */
    public val endOfLifeDate: Output<String>?
        get() = javaResource.endOfLifeDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Eula agreement for the gallery Application Definition.
     */
    public val eula: Output<String>?
        get() = javaResource.eula().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The privacy statement uri.
     */
    public val privacyStatementUri: Output<String>?
        get() = javaResource.privacyStatementUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The release note uri.
     */
    public val releaseNoteUri: Output<String>?
        get() = javaResource.releaseNoteUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This property allows you to specify the supported type of the OS that application is built for. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
     */
    public val supportedOSType: Output<String>
        get() = javaResource.supportedOSType().applyValue({ args0 -> args0 })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GalleryApplicationMapper : ResourceMapper<GalleryApplication> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.GalleryApplication::class == javaResource::class

    override fun map(javaResource: Resource): GalleryApplication = GalleryApplication(
        javaResource as
            com.pulumi.azurenative.compute.GalleryApplication,
    )
}

/**
 * @see [GalleryApplication].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GalleryApplication].
 */
public suspend fun galleryApplication(
    name: String,
    block: suspend GalleryApplicationResourceBuilder.() -> Unit,
): GalleryApplication {
    val builder = GalleryApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GalleryApplication].
 * @param name The _unique_ name of the resulting resource.
 */
public fun galleryApplication(name: String): GalleryApplication {
    val builder = GalleryApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
