@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.GalleryImageVersionPublishingProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.GalleryImageVersionSafetyProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.GalleryImageVersionStorageProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.ReplicationStatusResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.GalleryImageVersionPublishingProfileResponse.Companion.toKotlin as galleryImageVersionPublishingProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GalleryImageVersionSafetyProfileResponse.Companion.toKotlin as galleryImageVersionSafetyProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GalleryImageVersionStorageProfileResponse.Companion.toKotlin as galleryImageVersionStorageProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.ReplicationStatusResponse.Companion.toKotlin as replicationStatusResponseToKotlin

/**
 * Builder for [GalleryImageVersion].
 */
@PulumiTagMarker
public class GalleryImageVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GalleryImageVersionArgs = GalleryImageVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GalleryImageVersionArgsBuilder.() -> Unit) {
        val builder = GalleryImageVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GalleryImageVersion {
        val builtJavaResource =
            com.pulumi.azurenative.compute.GalleryImageVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GalleryImageVersion(builtJavaResource)
    }
}

/**
 * Specifies information about the gallery image version that you want to create or update.
 * Azure REST API version: 2022-03-03. Prior API version in Azure Native 1.x: 2020-09-30.
 * Other available API versions: 2019-03-01, 2022-08-03, 2023-07-03.
 * ## Example Usage
 * ### Create or update a simple Gallery Image Version using VM as source.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImageVersion = new AzureNative.Compute.GalleryImageVersion("galleryImageVersion", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryImageVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryImageVersionPublishingProfileArgs
 *         {
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 2,
 *                 },
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "East US",
 *                     RegionalReplicaCount = 2,
 *                     StorageAccountType = "Standard_ZRS",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryImageVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.GalleryImageVersionStorageProfileArgs
 *         {
 *             Source = new AzureNative.Compute.Inputs.GalleryArtifactVersionFullSourceArgs
 *             {
 *                 Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{vmName}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewGalleryImageVersion(ctx, "galleryImageVersion", &compute.GalleryImageVersionArgs{
 * GalleryImageName: pulumi.String("myGalleryImageName"),
 * GalleryImageVersionName: pulumi.String("1.0.0"),
 * GalleryName: pulumi.String("myGalleryName"),
 * Location: pulumi.String("West US"),
 * PublishingProfile: compute.GalleryImageVersionPublishingProfileResponse{
 * TargetRegions: compute.TargetRegionArray{
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("West US"),
 * RegionalReplicaCount: pulumi.Int(2),
 * },
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("East US"),
 * RegionalReplicaCount: pulumi.Int(2),
 * StorageAccountType: pulumi.String("Standard_ZRS"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SafetyProfile: &compute.GalleryImageVersionSafetyProfileArgs{
 * AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * },
 * StorageProfile: compute.GalleryImageVersionStorageProfileResponse{
 * Source: &compute.GalleryArtifactVersionFullSourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{vmName}"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImageVersion;
 * import com.pulumi.azurenative.compute.GalleryImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImageVersion = new GalleryImageVersion("galleryImageVersion", GalleryImageVersionArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryImageVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.of("targetRegions",
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 2)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "East US"),
 *                     Map.entry("regionalReplicaCount", 2),
 *                     Map.entry("storageAccountType", "Standard_ZRS")
 *                 )))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .storageProfile(Map.of("source", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{vmName}")))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple Gallery Image Version using community gallery image as source.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImageVersion = new AzureNative.Compute.GalleryImageVersion("galleryImageVersion", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryImageVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryImageVersionPublishingProfileArgs
 *         {
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 1,
 *                 },
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "East US",
 *                     RegionalReplicaCount = 2,
 *                     StorageAccountType = "Standard_ZRS",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryImageVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.GalleryImageVersionStorageProfileArgs
 *         {
 *             Source = new AzureNative.Compute.Inputs.GalleryArtifactVersionFullSourceArgs
 *             {
 *                 CommunityGalleryImageId = "/communityGalleries/{communityGalleryName}/images/{communityGalleryImageName}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewGalleryImageVersion(ctx, "galleryImageVersion", &compute.GalleryImageVersionArgs{
 * GalleryImageName: pulumi.String("myGalleryImageName"),
 * GalleryImageVersionName: pulumi.String("1.0.0"),
 * GalleryName: pulumi.String("myGalleryName"),
 * Location: pulumi.String("West US"),
 * PublishingProfile: compute.GalleryImageVersionPublishingProfileResponse{
 * TargetRegions: compute.TargetRegionArray{
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("West US"),
 * RegionalReplicaCount: pulumi.Int(1),
 * },
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("East US"),
 * RegionalReplicaCount: pulumi.Int(2),
 * StorageAccountType: pulumi.String("Standard_ZRS"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SafetyProfile: &compute.GalleryImageVersionSafetyProfileArgs{
 * AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * },
 * StorageProfile: compute.GalleryImageVersionStorageProfileResponse{
 * Source: &compute.GalleryArtifactVersionFullSourceArgs{
 * CommunityGalleryImageId: pulumi.String("/communityGalleries/{communityGalleryName}/images/{communityGalleryImageName}"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImageVersion;
 * import com.pulumi.azurenative.compute.GalleryImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImageVersion = new GalleryImageVersion("galleryImageVersion", GalleryImageVersionArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryImageVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.of("targetRegions",
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 1)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "East US"),
 *                     Map.entry("regionalReplicaCount", 2),
 *                     Map.entry("storageAccountType", "Standard_ZRS")
 *                 )))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .storageProfile(Map.of("source", Map.of("communityGalleryImageId", "/communityGalleries/{communityGalleryName}/images/{communityGalleryImageName}")))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple Gallery Image Version using managed image as source.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImageVersion = new AzureNative.Compute.GalleryImageVersion("galleryImageVersion", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryImageVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryImageVersionPublishingProfileArgs
 *         {
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 1,
 *                 },
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "East US",
 *                     RegionalReplicaCount = 2,
 *                     StorageAccountType = "Standard_ZRS",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryImageVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.GalleryImageVersionStorageProfileArgs
 *         {
 *             Source = new AzureNative.Compute.Inputs.GalleryArtifactVersionFullSourceArgs
 *             {
 *                 Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewGalleryImageVersion(ctx, "galleryImageVersion", &compute.GalleryImageVersionArgs{
 * GalleryImageName: pulumi.String("myGalleryImageName"),
 * GalleryImageVersionName: pulumi.String("1.0.0"),
 * GalleryName: pulumi.String("myGalleryName"),
 * Location: pulumi.String("West US"),
 * PublishingProfile: compute.GalleryImageVersionPublishingProfileResponse{
 * TargetRegions: compute.TargetRegionArray{
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("West US"),
 * RegionalReplicaCount: pulumi.Int(1),
 * },
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("East US"),
 * RegionalReplicaCount: pulumi.Int(2),
 * StorageAccountType: pulumi.String("Standard_ZRS"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SafetyProfile: &compute.GalleryImageVersionSafetyProfileArgs{
 * AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * },
 * StorageProfile: compute.GalleryImageVersionStorageProfileResponse{
 * Source: &compute.GalleryArtifactVersionFullSourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImageVersion;
 * import com.pulumi.azurenative.compute.GalleryImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImageVersion = new GalleryImageVersion("galleryImageVersion", GalleryImageVersionArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryImageVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.of("targetRegions",
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 1)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "East US"),
 *                     Map.entry("regionalReplicaCount", 2),
 *                     Map.entry("storageAccountType", "Standard_ZRS")
 *                 )))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .storageProfile(Map.of("source", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}")))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple Gallery Image Version using mix of disks and snapshots as a source.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImageVersion = new AzureNative.Compute.GalleryImageVersion("galleryImageVersion", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryImageVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryImageVersionPublishingProfileArgs
 *         {
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 1,
 *                 },
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "East US",
 *                     RegionalReplicaCount = 2,
 *                     StorageAccountType = "Standard_ZRS",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryImageVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.GalleryImageVersionStorageProfileArgs
 *         {
 *             DataDiskImages = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.GalleryDataDiskImageArgs
 *                 {
 *                     HostCaching = AzureNative.Compute.HostCaching.None,
 *                     Lun = 1,
 *                     Source = new AzureNative.Compute.Inputs.GalleryDiskImageSourceArgs
 *                     {
 *                         Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/disks/{dataDiskName}",
 *                     },
 *                 },
 *             },
 *             OsDiskImage = new AzureNative.Compute.Inputs.GalleryOSDiskImageArgs
 *             {
 *                 HostCaching = AzureNative.Compute.HostCaching.ReadOnly,
 *                 Source = new AzureNative.Compute.Inputs.GalleryDiskImageSourceArgs
 *                 {
 *                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/snapshots/{osSnapshotName}",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewGalleryImageVersion(ctx, "galleryImageVersion", &compute.GalleryImageVersionArgs{
 * GalleryImageName: pulumi.String("myGalleryImageName"),
 * GalleryImageVersionName: pulumi.String("1.0.0"),
 * GalleryName: pulumi.String("myGalleryName"),
 * Location: pulumi.String("West US"),
 * PublishingProfile: compute.GalleryImageVersionPublishingProfileResponse{
 * TargetRegions: compute.TargetRegionArray{
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("West US"),
 * RegionalReplicaCount: pulumi.Int(1),
 * },
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("East US"),
 * RegionalReplicaCount: pulumi.Int(2),
 * StorageAccountType: pulumi.String("Standard_ZRS"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SafetyProfile: &compute.GalleryImageVersionSafetyProfileArgs{
 * AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * },
 * StorageProfile: compute.GalleryImageVersionStorageProfileResponse{
 * DataDiskImages: compute.GalleryDataDiskImageArray{
 * interface{}{
 * HostCaching: compute.HostCachingNone,
 * Lun: pulumi.Int(1),
 * Source: &compute.GalleryDiskImageSourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/disks/{dataDiskName}"),
 * },
 * },
 * },
 * OsDiskImage: interface{}{
 * HostCaching: compute.HostCachingReadOnly,
 * Source: &compute.GalleryDiskImageSourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/snapshots/{osSnapshotName}"),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImageVersion;
 * import com.pulumi.azurenative.compute.GalleryImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImageVersion = new GalleryImageVersion("galleryImageVersion", GalleryImageVersionArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryImageVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.of("targetRegions",
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages", Map.ofEntries(
 *                             Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 *                             Map.entry("lun", 1)
 *                         )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 1)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages", Map.ofEntries(
 *                             Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 *                             Map.entry("lun", 1)
 *                         )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "East US"),
 *                     Map.entry("regionalReplicaCount", 2),
 *                     Map.entry("storageAccountType", "Standard_ZRS")
 *                 )))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("dataDiskImages", Map.ofEntries(
 *                     Map.entry("hostCaching", "None"),
 *                     Map.entry("lun", 1),
 *                     Map.entry("source", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/disks/{dataDiskName}"))
 *                 )),
 *                 Map.entry("osDiskImage", Map.ofEntries(
 *                     Map.entry("hostCaching", "ReadOnly"),
 *                     Map.entry("source", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/snapshots/{osSnapshotName}"))
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple Gallery Image Version using shallow replication mode.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImageVersion = new AzureNative.Compute.GalleryImageVersion("galleryImageVersion", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryImageVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryImageVersionPublishingProfileArgs
 *         {
 *             ReplicationMode = "Shallow",
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 1,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryImageVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.GalleryImageVersionStorageProfileArgs
 *         {
 *             Source = new AzureNative.Compute.Inputs.GalleryArtifactVersionFullSourceArgs
 *             {
 *                 Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewGalleryImageVersion(ctx, "galleryImageVersion", &compute.GalleryImageVersionArgs{
 * 			GalleryImageName:        pulumi.String("myGalleryImageName"),
 * 			GalleryImageVersionName: pulumi.String("1.0.0"),
 * 			GalleryName:             pulumi.String("myGalleryName"),
 * 			Location:                pulumi.String("West US"),
 * 			PublishingProfile: compute.GalleryImageVersionPublishingProfileResponse{
 * 				ReplicationMode: pulumi.String("Shallow"),
 * 				TargetRegions: compute.TargetRegionArray{
 * 					&compute.TargetRegionArgs{
 * 						ExcludeFromLatest:    pulumi.Bool(false),
 * 						Name:                 pulumi.String("West US"),
 * 						RegionalReplicaCount: pulumi.Int(1),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SafetyProfile: &compute.GalleryImageVersionSafetyProfileArgs{
 * 				AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * 			},
 * 			StorageProfile: compute.GalleryImageVersionStorageProfileResponse{
 * 				Source: &compute.GalleryArtifactVersionFullSourceArgs{
 * 					Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImageVersion;
 * import com.pulumi.azurenative.compute.GalleryImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImageVersion = new GalleryImageVersion("galleryImageVersion", GalleryImageVersionArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryImageVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.ofEntries(
 *                 Map.entry("replicationMode", "Shallow"),
 *                 Map.entry("targetRegions", Map.ofEntries(
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 1)
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .storageProfile(Map.of("source", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}")))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple Gallery Image Version using shared image as source.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImageVersion = new AzureNative.Compute.GalleryImageVersion("galleryImageVersion", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryImageVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryImageVersionPublishingProfileArgs
 *         {
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 1,
 *                 },
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "East US",
 *                     RegionalReplicaCount = 2,
 *                     StorageAccountType = "Standard_ZRS",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryImageVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.GalleryImageVersionStorageProfileArgs
 *         {
 *             Source = new AzureNative.Compute.Inputs.GalleryArtifactVersionFullSourceArgs
 *             {
 *                 Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{versionName}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewGalleryImageVersion(ctx, "galleryImageVersion", &compute.GalleryImageVersionArgs{
 * GalleryImageName: pulumi.String("myGalleryImageName"),
 * GalleryImageVersionName: pulumi.String("1.0.0"),
 * GalleryName: pulumi.String("myGalleryName"),
 * Location: pulumi.String("West US"),
 * PublishingProfile: compute.GalleryImageVersionPublishingProfileResponse{
 * TargetRegions: compute.TargetRegionArray{
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("West US"),
 * RegionalReplicaCount: pulumi.Int(1),
 * },
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("East US"),
 * RegionalReplicaCount: pulumi.Int(2),
 * StorageAccountType: pulumi.String("Standard_ZRS"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SafetyProfile: &compute.GalleryImageVersionSafetyProfileArgs{
 * AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * },
 * StorageProfile: compute.GalleryImageVersionStorageProfileResponse{
 * Source: &compute.GalleryArtifactVersionFullSourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{versionName}"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImageVersion;
 * import com.pulumi.azurenative.compute.GalleryImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImageVersion = new GalleryImageVersion("galleryImageVersion", GalleryImageVersionArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryImageVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.of("targetRegions",
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 1)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "East US"),
 *                     Map.entry("regionalReplicaCount", 2),
 *                     Map.entry("storageAccountType", "Standard_ZRS")
 *                 )))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .storageProfile(Map.of("source", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{versionName}")))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple Gallery Image Version using vhd as a source.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImageVersion = new AzureNative.Compute.GalleryImageVersion("galleryImageVersion", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryImageVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryImageVersionPublishingProfileArgs
 *         {
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 1,
 *                 },
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     ExcludeFromLatest = false,
 *                     Name = "East US",
 *                     RegionalReplicaCount = 2,
 *                     StorageAccountType = "Standard_ZRS",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryImageVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.GalleryImageVersionStorageProfileArgs
 *         {
 *             DataDiskImages = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.GalleryDataDiskImageArgs
 *                 {
 *                     HostCaching = AzureNative.Compute.HostCaching.None,
 *                     Lun = 1,
 *                     Source = new AzureNative.Compute.Inputs.GalleryDiskImageSourceArgs
 *                     {
 *                         Id = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/{storageAccount}",
 *                         Uri = "https://gallerysourcencus.blob.core.windows.net/myvhds/Windows-Server-2012-R2-20171216-en.us-128GB.vhd",
 *                     },
 *                 },
 *             },
 *             OsDiskImage = new AzureNative.Compute.Inputs.GalleryOSDiskImageArgs
 *             {
 *                 HostCaching = AzureNative.Compute.HostCaching.ReadOnly,
 *                 Source = new AzureNative.Compute.Inputs.GalleryDiskImageSourceArgs
 *                 {
 *                     Id = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/{storageAccount}",
 *                     Uri = "https://gallerysourcencus.blob.core.windows.net/myvhds/Windows-Server-2012-R2-20171216-en.us-128GB.vhd",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewGalleryImageVersion(ctx, "galleryImageVersion", &compute.GalleryImageVersionArgs{
 * GalleryImageName: pulumi.String("myGalleryImageName"),
 * GalleryImageVersionName: pulumi.String("1.0.0"),
 * GalleryName: pulumi.String("myGalleryName"),
 * Location: pulumi.String("West US"),
 * PublishingProfile: compute.GalleryImageVersionPublishingProfileResponse{
 * TargetRegions: compute.TargetRegionArray{
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("West US"),
 * RegionalReplicaCount: pulumi.Int(1),
 * },
 * &compute.TargetRegionArgs{
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("East US"),
 * RegionalReplicaCount: pulumi.Int(2),
 * StorageAccountType: pulumi.String("Standard_ZRS"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SafetyProfile: &compute.GalleryImageVersionSafetyProfileArgs{
 * AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * },
 * StorageProfile: compute.GalleryImageVersionStorageProfileResponse{
 * DataDiskImages: compute.GalleryDataDiskImageArray{
 * interface{}{
 * HostCaching: compute.HostCachingNone,
 * Lun: pulumi.Int(1),
 * Source: &compute.GalleryDiskImageSourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/{storageAccount}"),
 * Uri: pulumi.String("https://gallerysourcencus.blob.core.windows.net/myvhds/Windows-Server-2012-R2-20171216-en.us-128GB.vhd"),
 * },
 * },
 * },
 * OsDiskImage: interface{}{
 * HostCaching: compute.HostCachingReadOnly,
 * Source: &compute.GalleryDiskImageSourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/{storageAccount}"),
 * Uri: pulumi.String("https://gallerysourcencus.blob.core.windows.net/myvhds/Windows-Server-2012-R2-20171216-en.us-128GB.vhd"),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImageVersion;
 * import com.pulumi.azurenative.compute.GalleryImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImageVersion = new GalleryImageVersion("galleryImageVersion", GalleryImageVersionArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryImageVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.of("targetRegions",
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages", Map.ofEntries(
 *                             Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherDiskEncryptionSet"),
 *                             Map.entry("lun", 1)
 *                         )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 1)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "East US"),
 *                     Map.entry("regionalReplicaCount", 2),
 *                     Map.entry("storageAccountType", "Standard_ZRS")
 *                 )))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("dataDiskImages", Map.ofEntries(
 *                     Map.entry("hostCaching", "None"),
 *                     Map.entry("lun", 1),
 *                     Map.entry("source", Map.ofEntries(
 *                         Map.entry("id", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/{storageAccount}"),
 *                         Map.entry("uri", "https://gallerysourcencus.blob.core.windows.net/myvhds/Windows-Server-2012-R2-20171216-en.us-128GB.vhd")
 *                     ))
 *                 )),
 *                 Map.entry("osDiskImage", Map.ofEntries(
 *                     Map.entry("hostCaching", "ReadOnly"),
 *                     Map.entry("source", Map.ofEntries(
 *                         Map.entry("id", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/{storageAccount}"),
 *                         Map.entry("uri", "https://gallerysourcencus.blob.core.windows.net/myvhds/Windows-Server-2012-R2-20171216-en.us-128GB.vhd")
 *                     ))
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple gallery image version with target extended locations specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImageVersion = new AzureNative.Compute.GalleryImageVersion("galleryImageVersion", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryImageVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryImageVersionPublishingProfileArgs
 *         {
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 1,
 *                 },
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "East US",
 *                     RegionalReplicaCount = 2,
 *                     StorageAccountType = "Standard_ZRS",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryImageVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.GalleryImageVersionStorageProfileArgs
 *         {
 *             Source = new AzureNative.Compute.Inputs.GalleryArtifactVersionFullSourceArgs
 *             {
 *                 Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewGalleryImageVersion(ctx, "galleryImageVersion", &compute.GalleryImageVersionArgs{
 * GalleryImageName: pulumi.String("myGalleryImageName"),
 * GalleryImageVersionName: pulumi.String("1.0.0"),
 * GalleryName: pulumi.String("myGalleryName"),
 * Location: pulumi.String("West US"),
 * PublishingProfile: compute.GalleryImageVersionPublishingProfileResponse{
 * TargetRegions: compute.TargetRegionArray{
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("West US"),
 * RegionalReplicaCount: pulumi.Int(1),
 * },
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("East US"),
 * RegionalReplicaCount: pulumi.Int(2),
 * StorageAccountType: pulumi.String("Standard_ZRS"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SafetyProfile: &compute.GalleryImageVersionSafetyProfileArgs{
 * AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * },
 * StorageProfile: compute.GalleryImageVersionStorageProfileResponse{
 * Source: &compute.GalleryArtifactVersionFullSourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImageVersion;
 * import com.pulumi.azurenative.compute.GalleryImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImageVersion = new GalleryImageVersion("galleryImageVersion", GalleryImageVersionArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryImageVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.of("targetRegions",
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 1)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "East US"),
 *                     Map.entry("regionalReplicaCount", 2),
 *                     Map.entry("storageAccountType", "Standard_ZRS")
 *                 )))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .storageProfile(Map.of("source", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:GalleryImageVersion 1.0.0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}
 * ```
 */
public class GalleryImageVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.GalleryImageVersion,
) : KotlinCustomResource(javaResource, GalleryImageVersionMapper) {
    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The publishing profile of a gallery image Version.
     */
    public val publishingProfile: Output<GalleryImageVersionPublishingProfileResponse>?
        get() = javaResource.publishingProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    galleryImageVersionPublishingProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * This is the replication status of the gallery image version.
     */
    public val replicationStatus: Output<ReplicationStatusResponse>
        get() = javaResource.replicationStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                replicationStatusResponseToKotlin(args0)
            })
        })

    /**
     * This is the safety profile of the Gallery Image Version.
     */
    public val safetyProfile: Output<GalleryImageVersionSafetyProfileResponse>?
        get() = javaResource.safetyProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    galleryImageVersionSafetyProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * This is the storage profile of a Gallery Image Version.
     */
    public val storageProfile: Output<GalleryImageVersionStorageProfileResponse>
        get() = javaResource.storageProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                galleryImageVersionStorageProfileResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GalleryImageVersionMapper : ResourceMapper<GalleryImageVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.GalleryImageVersion::class == javaResource::class

    override fun map(javaResource: Resource): GalleryImageVersion = GalleryImageVersion(
        javaResource
            as com.pulumi.azurenative.compute.GalleryImageVersion,
    )
}

/**
 * @see [GalleryImageVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GalleryImageVersion].
 */
public suspend fun galleryImageVersion(
    name: String,
    block: suspend GalleryImageVersionResourceBuilder.() -> Unit,
): GalleryImageVersion {
    val builder = GalleryImageVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GalleryImageVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun galleryImageVersion(name: String): GalleryImageVersion {
    val builder = GalleryImageVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
