@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.GalleryImageVersionArgs.builder
import com.pulumi.azurenative.compute.kotlin.inputs.GalleryImageVersionPublishingProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GalleryImageVersionPublishingProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GalleryImageVersionSafetyProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GalleryImageVersionSafetyProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GalleryImageVersionStorageProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GalleryImageVersionStorageProfileArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Specifies information about the gallery image version that you want to create or update.
 * Azure REST API version: 2022-03-03. Prior API version in Azure Native 1.x: 2020-09-30.
 * Other available API versions: 2019-03-01, 2022-08-03, 2023-07-03.
 * ## Example Usage
 * ### Create or update a simple Gallery Image Version using VM as source.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImageVersion = new AzureNative.Compute.GalleryImageVersion("galleryImageVersion", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryImageVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryImageVersionPublishingProfileArgs
 *         {
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 2,
 *                 },
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "East US",
 *                     RegionalReplicaCount = 2,
 *                     StorageAccountType = "Standard_ZRS",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryImageVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.GalleryImageVersionStorageProfileArgs
 *         {
 *             Source = new AzureNative.Compute.Inputs.GalleryArtifactVersionFullSourceArgs
 *             {
 *                 Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{vmName}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewGalleryImageVersion(ctx, "galleryImageVersion", &compute.GalleryImageVersionArgs{
 * GalleryImageName: pulumi.String("myGalleryImageName"),
 * GalleryImageVersionName: pulumi.String("1.0.0"),
 * GalleryName: pulumi.String("myGalleryName"),
 * Location: pulumi.String("West US"),
 * PublishingProfile: compute.GalleryImageVersionPublishingProfileResponse{
 * TargetRegions: compute.TargetRegionArray{
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("West US"),
 * RegionalReplicaCount: pulumi.Int(2),
 * },
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("East US"),
 * RegionalReplicaCount: pulumi.Int(2),
 * StorageAccountType: pulumi.String("Standard_ZRS"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SafetyProfile: &compute.GalleryImageVersionSafetyProfileArgs{
 * AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * },
 * StorageProfile: compute.GalleryImageVersionStorageProfileResponse{
 * Source: &compute.GalleryArtifactVersionFullSourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{vmName}"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImageVersion;
 * import com.pulumi.azurenative.compute.GalleryImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImageVersion = new GalleryImageVersion("galleryImageVersion", GalleryImageVersionArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryImageVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.of("targetRegions",
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 2)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "East US"),
 *                     Map.entry("regionalReplicaCount", 2),
 *                     Map.entry("storageAccountType", "Standard_ZRS")
 *                 )))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .storageProfile(Map.of("source", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{vmName}")))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple Gallery Image Version using community gallery image as source.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImageVersion = new AzureNative.Compute.GalleryImageVersion("galleryImageVersion", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryImageVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryImageVersionPublishingProfileArgs
 *         {
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 1,
 *                 },
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "East US",
 *                     RegionalReplicaCount = 2,
 *                     StorageAccountType = "Standard_ZRS",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryImageVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.GalleryImageVersionStorageProfileArgs
 *         {
 *             Source = new AzureNative.Compute.Inputs.GalleryArtifactVersionFullSourceArgs
 *             {
 *                 CommunityGalleryImageId = "/communityGalleries/{communityGalleryName}/images/{communityGalleryImageName}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewGalleryImageVersion(ctx, "galleryImageVersion", &compute.GalleryImageVersionArgs{
 * GalleryImageName: pulumi.String("myGalleryImageName"),
 * GalleryImageVersionName: pulumi.String("1.0.0"),
 * GalleryName: pulumi.String("myGalleryName"),
 * Location: pulumi.String("West US"),
 * PublishingProfile: compute.GalleryImageVersionPublishingProfileResponse{
 * TargetRegions: compute.TargetRegionArray{
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("West US"),
 * RegionalReplicaCount: pulumi.Int(1),
 * },
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("East US"),
 * RegionalReplicaCount: pulumi.Int(2),
 * StorageAccountType: pulumi.String("Standard_ZRS"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SafetyProfile: &compute.GalleryImageVersionSafetyProfileArgs{
 * AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * },
 * StorageProfile: compute.GalleryImageVersionStorageProfileResponse{
 * Source: &compute.GalleryArtifactVersionFullSourceArgs{
 * CommunityGalleryImageId: pulumi.String("/communityGalleries/{communityGalleryName}/images/{communityGalleryImageName}"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImageVersion;
 * import com.pulumi.azurenative.compute.GalleryImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImageVersion = new GalleryImageVersion("galleryImageVersion", GalleryImageVersionArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryImageVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.of("targetRegions",
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 1)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "East US"),
 *                     Map.entry("regionalReplicaCount", 2),
 *                     Map.entry("storageAccountType", "Standard_ZRS")
 *                 )))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .storageProfile(Map.of("source", Map.of("communityGalleryImageId", "/communityGalleries/{communityGalleryName}/images/{communityGalleryImageName}")))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple Gallery Image Version using managed image as source.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImageVersion = new AzureNative.Compute.GalleryImageVersion("galleryImageVersion", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryImageVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryImageVersionPublishingProfileArgs
 *         {
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 1,
 *                 },
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "East US",
 *                     RegionalReplicaCount = 2,
 *                     StorageAccountType = "Standard_ZRS",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryImageVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.GalleryImageVersionStorageProfileArgs
 *         {
 *             Source = new AzureNative.Compute.Inputs.GalleryArtifactVersionFullSourceArgs
 *             {
 *                 Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewGalleryImageVersion(ctx, "galleryImageVersion", &compute.GalleryImageVersionArgs{
 * GalleryImageName: pulumi.String("myGalleryImageName"),
 * GalleryImageVersionName: pulumi.String("1.0.0"),
 * GalleryName: pulumi.String("myGalleryName"),
 * Location: pulumi.String("West US"),
 * PublishingProfile: compute.GalleryImageVersionPublishingProfileResponse{
 * TargetRegions: compute.TargetRegionArray{
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("West US"),
 * RegionalReplicaCount: pulumi.Int(1),
 * },
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("East US"),
 * RegionalReplicaCount: pulumi.Int(2),
 * StorageAccountType: pulumi.String("Standard_ZRS"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SafetyProfile: &compute.GalleryImageVersionSafetyProfileArgs{
 * AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * },
 * StorageProfile: compute.GalleryImageVersionStorageProfileResponse{
 * Source: &compute.GalleryArtifactVersionFullSourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImageVersion;
 * import com.pulumi.azurenative.compute.GalleryImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImageVersion = new GalleryImageVersion("galleryImageVersion", GalleryImageVersionArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryImageVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.of("targetRegions",
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 1)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "East US"),
 *                     Map.entry("regionalReplicaCount", 2),
 *                     Map.entry("storageAccountType", "Standard_ZRS")
 *                 )))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .storageProfile(Map.of("source", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}")))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple Gallery Image Version using mix of disks and snapshots as a source.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImageVersion = new AzureNative.Compute.GalleryImageVersion("galleryImageVersion", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryImageVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryImageVersionPublishingProfileArgs
 *         {
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 1,
 *                 },
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "East US",
 *                     RegionalReplicaCount = 2,
 *                     StorageAccountType = "Standard_ZRS",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryImageVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.GalleryImageVersionStorageProfileArgs
 *         {
 *             DataDiskImages = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.GalleryDataDiskImageArgs
 *                 {
 *                     HostCaching = AzureNative.Compute.HostCaching.None,
 *                     Lun = 1,
 *                     Source = new AzureNative.Compute.Inputs.GalleryDiskImageSourceArgs
 *                     {
 *                         Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/disks/{dataDiskName}",
 *                     },
 *                 },
 *             },
 *             OsDiskImage = new AzureNative.Compute.Inputs.GalleryOSDiskImageArgs
 *             {
 *                 HostCaching = AzureNative.Compute.HostCaching.ReadOnly,
 *                 Source = new AzureNative.Compute.Inputs.GalleryDiskImageSourceArgs
 *                 {
 *                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/snapshots/{osSnapshotName}",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewGalleryImageVersion(ctx, "galleryImageVersion", &compute.GalleryImageVersionArgs{
 * GalleryImageName: pulumi.String("myGalleryImageName"),
 * GalleryImageVersionName: pulumi.String("1.0.0"),
 * GalleryName: pulumi.String("myGalleryName"),
 * Location: pulumi.String("West US"),
 * PublishingProfile: compute.GalleryImageVersionPublishingProfileResponse{
 * TargetRegions: compute.TargetRegionArray{
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("West US"),
 * RegionalReplicaCount: pulumi.Int(1),
 * },
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("East US"),
 * RegionalReplicaCount: pulumi.Int(2),
 * StorageAccountType: pulumi.String("Standard_ZRS"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SafetyProfile: &compute.GalleryImageVersionSafetyProfileArgs{
 * AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * },
 * StorageProfile: compute.GalleryImageVersionStorageProfileResponse{
 * DataDiskImages: compute.GalleryDataDiskImageArray{
 * interface{}{
 * HostCaching: compute.HostCachingNone,
 * Lun: pulumi.Int(1),
 * Source: &compute.GalleryDiskImageSourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/disks/{dataDiskName}"),
 * },
 * },
 * },
 * OsDiskImage: interface{}{
 * HostCaching: compute.HostCachingReadOnly,
 * Source: &compute.GalleryDiskImageSourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/snapshots/{osSnapshotName}"),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImageVersion;
 * import com.pulumi.azurenative.compute.GalleryImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImageVersion = new GalleryImageVersion("galleryImageVersion", GalleryImageVersionArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryImageVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.of("targetRegions",
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages", Map.ofEntries(
 *                             Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 *                             Map.entry("lun", 1)
 *                         )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 1)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages", Map.ofEntries(
 *                             Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 *                             Map.entry("lun", 1)
 *                         )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "East US"),
 *                     Map.entry("regionalReplicaCount", 2),
 *                     Map.entry("storageAccountType", "Standard_ZRS")
 *                 )))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("dataDiskImages", Map.ofEntries(
 *                     Map.entry("hostCaching", "None"),
 *                     Map.entry("lun", 1),
 *                     Map.entry("source", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/disks/{dataDiskName}"))
 *                 )),
 *                 Map.entry("osDiskImage", Map.ofEntries(
 *                     Map.entry("hostCaching", "ReadOnly"),
 *                     Map.entry("source", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/snapshots/{osSnapshotName}"))
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple Gallery Image Version using shallow replication mode.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImageVersion = new AzureNative.Compute.GalleryImageVersion("galleryImageVersion", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryImageVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryImageVersionPublishingProfileArgs
 *         {
 *             ReplicationMode = "Shallow",
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 1,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryImageVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.GalleryImageVersionStorageProfileArgs
 *         {
 *             Source = new AzureNative.Compute.Inputs.GalleryArtifactVersionFullSourceArgs
 *             {
 *                 Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewGalleryImageVersion(ctx, "galleryImageVersion", &compute.GalleryImageVersionArgs{
 * 			GalleryImageName:        pulumi.String("myGalleryImageName"),
 * 			GalleryImageVersionName: pulumi.String("1.0.0"),
 * 			GalleryName:             pulumi.String("myGalleryName"),
 * 			Location:                pulumi.String("West US"),
 * 			PublishingProfile: compute.GalleryImageVersionPublishingProfileResponse{
 * 				ReplicationMode: pulumi.String("Shallow"),
 * 				TargetRegions: compute.TargetRegionArray{
 * 					&compute.TargetRegionArgs{
 * 						ExcludeFromLatest:    pulumi.Bool(false),
 * 						Name:                 pulumi.String("West US"),
 * 						RegionalReplicaCount: pulumi.Int(1),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SafetyProfile: &compute.GalleryImageVersionSafetyProfileArgs{
 * 				AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * 			},
 * 			StorageProfile: compute.GalleryImageVersionStorageProfileResponse{
 * 				Source: &compute.GalleryArtifactVersionFullSourceArgs{
 * 					Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImageVersion;
 * import com.pulumi.azurenative.compute.GalleryImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImageVersion = new GalleryImageVersion("galleryImageVersion", GalleryImageVersionArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryImageVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.ofEntries(
 *                 Map.entry("replicationMode", "Shallow"),
 *                 Map.entry("targetRegions", Map.ofEntries(
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 1)
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .storageProfile(Map.of("source", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}")))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple Gallery Image Version using shared image as source.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImageVersion = new AzureNative.Compute.GalleryImageVersion("galleryImageVersion", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryImageVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryImageVersionPublishingProfileArgs
 *         {
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 1,
 *                 },
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "East US",
 *                     RegionalReplicaCount = 2,
 *                     StorageAccountType = "Standard_ZRS",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryImageVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.GalleryImageVersionStorageProfileArgs
 *         {
 *             Source = new AzureNative.Compute.Inputs.GalleryArtifactVersionFullSourceArgs
 *             {
 *                 Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{versionName}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewGalleryImageVersion(ctx, "galleryImageVersion", &compute.GalleryImageVersionArgs{
 * GalleryImageName: pulumi.String("myGalleryImageName"),
 * GalleryImageVersionName: pulumi.String("1.0.0"),
 * GalleryName: pulumi.String("myGalleryName"),
 * Location: pulumi.String("West US"),
 * PublishingProfile: compute.GalleryImageVersionPublishingProfileResponse{
 * TargetRegions: compute.TargetRegionArray{
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("West US"),
 * RegionalReplicaCount: pulumi.Int(1),
 * },
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("East US"),
 * RegionalReplicaCount: pulumi.Int(2),
 * StorageAccountType: pulumi.String("Standard_ZRS"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SafetyProfile: &compute.GalleryImageVersionSafetyProfileArgs{
 * AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * },
 * StorageProfile: compute.GalleryImageVersionStorageProfileResponse{
 * Source: &compute.GalleryArtifactVersionFullSourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{versionName}"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImageVersion;
 * import com.pulumi.azurenative.compute.GalleryImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImageVersion = new GalleryImageVersion("galleryImageVersion", GalleryImageVersionArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryImageVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.of("targetRegions",
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 1)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "East US"),
 *                     Map.entry("regionalReplicaCount", 2),
 *                     Map.entry("storageAccountType", "Standard_ZRS")
 *                 )))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .storageProfile(Map.of("source", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{versionName}")))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple Gallery Image Version using vhd as a source.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImageVersion = new AzureNative.Compute.GalleryImageVersion("galleryImageVersion", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryImageVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryImageVersionPublishingProfileArgs
 *         {
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 1,
 *                 },
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     ExcludeFromLatest = false,
 *                     Name = "East US",
 *                     RegionalReplicaCount = 2,
 *                     StorageAccountType = "Standard_ZRS",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryImageVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.GalleryImageVersionStorageProfileArgs
 *         {
 *             DataDiskImages = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.GalleryDataDiskImageArgs
 *                 {
 *                     HostCaching = AzureNative.Compute.HostCaching.None,
 *                     Lun = 1,
 *                     Source = new AzureNative.Compute.Inputs.GalleryDiskImageSourceArgs
 *                     {
 *                         Id = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/{storageAccount}",
 *                         Uri = "https://gallerysourcencus.blob.core.windows.net/myvhds/Windows-Server-2012-R2-20171216-en.us-128GB.vhd",
 *                     },
 *                 },
 *             },
 *             OsDiskImage = new AzureNative.Compute.Inputs.GalleryOSDiskImageArgs
 *             {
 *                 HostCaching = AzureNative.Compute.HostCaching.ReadOnly,
 *                 Source = new AzureNative.Compute.Inputs.GalleryDiskImageSourceArgs
 *                 {
 *                     Id = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/{storageAccount}",
 *                     Uri = "https://gallerysourcencus.blob.core.windows.net/myvhds/Windows-Server-2012-R2-20171216-en.us-128GB.vhd",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewGalleryImageVersion(ctx, "galleryImageVersion", &compute.GalleryImageVersionArgs{
 * GalleryImageName: pulumi.String("myGalleryImageName"),
 * GalleryImageVersionName: pulumi.String("1.0.0"),
 * GalleryName: pulumi.String("myGalleryName"),
 * Location: pulumi.String("West US"),
 * PublishingProfile: compute.GalleryImageVersionPublishingProfileResponse{
 * TargetRegions: compute.TargetRegionArray{
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("West US"),
 * RegionalReplicaCount: pulumi.Int(1),
 * },
 * &compute.TargetRegionArgs{
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("East US"),
 * RegionalReplicaCount: pulumi.Int(2),
 * StorageAccountType: pulumi.String("Standard_ZRS"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SafetyProfile: &compute.GalleryImageVersionSafetyProfileArgs{
 * AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * },
 * StorageProfile: compute.GalleryImageVersionStorageProfileResponse{
 * DataDiskImages: compute.GalleryDataDiskImageArray{
 * interface{}{
 * HostCaching: compute.HostCachingNone,
 * Lun: pulumi.Int(1),
 * Source: &compute.GalleryDiskImageSourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/{storageAccount}"),
 * Uri: pulumi.String("https://gallerysourcencus.blob.core.windows.net/myvhds/Windows-Server-2012-R2-20171216-en.us-128GB.vhd"),
 * },
 * },
 * },
 * OsDiskImage: interface{}{
 * HostCaching: compute.HostCachingReadOnly,
 * Source: &compute.GalleryDiskImageSourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/{storageAccount}"),
 * Uri: pulumi.String("https://gallerysourcencus.blob.core.windows.net/myvhds/Windows-Server-2012-R2-20171216-en.us-128GB.vhd"),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImageVersion;
 * import com.pulumi.azurenative.compute.GalleryImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImageVersion = new GalleryImageVersion("galleryImageVersion", GalleryImageVersionArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryImageVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.of("targetRegions",
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages", Map.ofEntries(
 *                             Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherDiskEncryptionSet"),
 *                             Map.entry("lun", 1)
 *                         )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 1)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "East US"),
 *                     Map.entry("regionalReplicaCount", 2),
 *                     Map.entry("storageAccountType", "Standard_ZRS")
 *                 )))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("dataDiskImages", Map.ofEntries(
 *                     Map.entry("hostCaching", "None"),
 *                     Map.entry("lun", 1),
 *                     Map.entry("source", Map.ofEntries(
 *                         Map.entry("id", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/{storageAccount}"),
 *                         Map.entry("uri", "https://gallerysourcencus.blob.core.windows.net/myvhds/Windows-Server-2012-R2-20171216-en.us-128GB.vhd")
 *                     ))
 *                 )),
 *                 Map.entry("osDiskImage", Map.ofEntries(
 *                     Map.entry("hostCaching", "ReadOnly"),
 *                     Map.entry("source", Map.ofEntries(
 *                         Map.entry("id", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/{storageAccount}"),
 *                         Map.entry("uri", "https://gallerysourcencus.blob.core.windows.net/myvhds/Windows-Server-2012-R2-20171216-en.us-128GB.vhd")
 *                     ))
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple gallery image version with target extended locations specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImageVersion = new AzureNative.Compute.GalleryImageVersion("galleryImageVersion", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryImageVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryImageVersionPublishingProfileArgs
 *         {
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 1,
 *                 },
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     Encryption = new AzureNative.Compute.Inputs.EncryptionImagesArgs
 *                     {
 *                         DataDiskImages = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet",
 *                                 Lun = 0,
 *                             },
 *                             new AzureNative.Compute.Inputs.DataDiskImageEncryptionArgs
 *                             {
 *                                 DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                                 Lun = 1,
 *                             },
 *                         },
 *                         OsDiskImage = new AzureNative.Compute.Inputs.OSDiskImageEncryptionArgs
 *                         {
 *                             DiskEncryptionSetId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet",
 *                         },
 *                     },
 *                     ExcludeFromLatest = false,
 *                     Name = "East US",
 *                     RegionalReplicaCount = 2,
 *                     StorageAccountType = "Standard_ZRS",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryImageVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.GalleryImageVersionStorageProfileArgs
 *         {
 *             Source = new AzureNative.Compute.Inputs.GalleryArtifactVersionFullSourceArgs
 *             {
 *                 Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewGalleryImageVersion(ctx, "galleryImageVersion", &compute.GalleryImageVersionArgs{
 * GalleryImageName: pulumi.String("myGalleryImageName"),
 * GalleryImageVersionName: pulumi.String("1.0.0"),
 * GalleryName: pulumi.String("myGalleryName"),
 * Location: pulumi.String("West US"),
 * PublishingProfile: compute.GalleryImageVersionPublishingProfileResponse{
 * TargetRegions: compute.TargetRegionArray{
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("West US"),
 * RegionalReplicaCount: pulumi.Int(1),
 * },
 * interface{}{
 * Encryption: interface{}{
 * DataDiskImages: compute.DataDiskImageEncryptionArray{
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(0),
 * },
 * &compute.DataDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * Lun: pulumi.Int(1),
 * },
 * },
 * OsDiskImage: &compute.OSDiskImageEncryptionArgs{
 * DiskEncryptionSetId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 * },
 * },
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("East US"),
 * RegionalReplicaCount: pulumi.Int(2),
 * StorageAccountType: pulumi.String("Standard_ZRS"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SafetyProfile: &compute.GalleryImageVersionSafetyProfileArgs{
 * AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * },
 * StorageProfile: compute.GalleryImageVersionStorageProfileResponse{
 * Source: &compute.GalleryArtifactVersionFullSourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImageVersion;
 * import com.pulumi.azurenative.compute.GalleryImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImageVersion = new GalleryImageVersion("galleryImageVersion", GalleryImageVersionArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryImageVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.of("targetRegions",
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myWestUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 1)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("encryption", Map.ofEntries(
 *                         Map.entry("dataDiskImages",
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 0)
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"),
 *                                 Map.entry("lun", 1)
 *                             )),
 *                         Map.entry("osDiskImage", Map.of("diskEncryptionSetId", "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myEastUSDiskEncryptionSet"))
 *                     )),
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "East US"),
 *                     Map.entry("regionalReplicaCount", 2),
 *                     Map.entry("storageAccountType", "Standard_ZRS")
 *                 )))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .storageProfile(Map.of("source", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:GalleryImageVersion 1.0.0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}
 * ```
 * @property galleryImageName The name of the gallery image definition in which the Image Version is to be created.
 * @property galleryImageVersionName The name of the gallery image version to be created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: <MajorVersion>.<MinorVersion>.<Patch>
 * @property galleryName The name of the Shared Image Gallery in which the Image Definition resides.
 * @property location Resource location
 * @property publishingProfile The publishing profile of a gallery image Version.
 * @property resourceGroupName The name of the resource group.
 * @property safetyProfile This is the safety profile of the Gallery Image Version.
 * @property storageProfile This is the storage profile of a Gallery Image Version.
 * @property tags Resource tags
 */
public data class GalleryImageVersionArgs(
    public val galleryImageName: Output<String>? = null,
    public val galleryImageVersionName: Output<String>? = null,
    public val galleryName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val publishingProfile: Output<GalleryImageVersionPublishingProfileArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val safetyProfile: Output<GalleryImageVersionSafetyProfileArgs>? = null,
    public val storageProfile: Output<GalleryImageVersionStorageProfileArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.GalleryImageVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.GalleryImageVersionArgs =
        com.pulumi.azurenative.compute.GalleryImageVersionArgs.builder()
            .galleryImageName(galleryImageName?.applyValue({ args0 -> args0 }))
            .galleryImageVersionName(galleryImageVersionName?.applyValue({ args0 -> args0 }))
            .galleryName(galleryName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .publishingProfile(publishingProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .safetyProfile(safetyProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageProfile(storageProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GalleryImageVersionArgs].
 */
@PulumiTagMarker
public class GalleryImageVersionArgsBuilder internal constructor() {
    private var galleryImageName: Output<String>? = null

    private var galleryImageVersionName: Output<String>? = null

    private var galleryName: Output<String>? = null

    private var location: Output<String>? = null

    private var publishingProfile: Output<GalleryImageVersionPublishingProfileArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var safetyProfile: Output<GalleryImageVersionSafetyProfileArgs>? = null

    private var storageProfile: Output<GalleryImageVersionStorageProfileArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the gallery image definition in which the Image Version is to be created.
     */
    @JvmName("fofefghqpturmvyh")
    public suspend fun galleryImageName(`value`: Output<String>) {
        this.galleryImageName = value
    }

    /**
     * @param value The name of the gallery image version to be created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: <MajorVersion>.<MinorVersion>.<Patch>
     */
    @JvmName("dajaqkabhgupsmjp")
    public suspend fun galleryImageVersionName(`value`: Output<String>) {
        this.galleryImageVersionName = value
    }

    /**
     * @param value The name of the Shared Image Gallery in which the Image Definition resides.
     */
    @JvmName("rwswqeigxivynwim")
    public suspend fun galleryName(`value`: Output<String>) {
        this.galleryName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("roabqonbdgmwpokj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The publishing profile of a gallery image Version.
     */
    @JvmName("bcthinkgcqsanayj")
    public suspend fun publishingProfile(`value`: Output<GalleryImageVersionPublishingProfileArgs>) {
        this.publishingProfile = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ingkixqlmlmpsrwc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value This is the safety profile of the Gallery Image Version.
     */
    @JvmName("drmlyfgqeyyxlnum")
    public suspend fun safetyProfile(`value`: Output<GalleryImageVersionSafetyProfileArgs>) {
        this.safetyProfile = value
    }

    /**
     * @param value This is the storage profile of a Gallery Image Version.
     */
    @JvmName("axmthgkwxsrwjmor")
    public suspend fun storageProfile(`value`: Output<GalleryImageVersionStorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("bvhvfcrtnpfulaqg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the gallery image definition in which the Image Version is to be created.
     */
    @JvmName("pbokgaajfeiwlorf")
    public suspend fun galleryImageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryImageName = mapped
    }

    /**
     * @param value The name of the gallery image version to be created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: <MajorVersion>.<MinorVersion>.<Patch>
     */
    @JvmName("wpfgjvrmtfrwenjx")
    public suspend fun galleryImageVersionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryImageVersionName = mapped
    }

    /**
     * @param value The name of the Shared Image Gallery in which the Image Definition resides.
     */
    @JvmName("luyugytnjtalgjmy")
    public suspend fun galleryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("qvthnajktoeuqnnj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The publishing profile of a gallery image Version.
     */
    @JvmName("oyjfcgevlaywcnyd")
    public suspend fun publishingProfile(`value`: GalleryImageVersionPublishingProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publishingProfile = mapped
    }

    /**
     * @param argument The publishing profile of a gallery image Version.
     */
    @JvmName("blporsaqupeohvgi")
    public suspend
    fun publishingProfile(argument: suspend GalleryImageVersionPublishingProfileArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryImageVersionPublishingProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.publishingProfile = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("acblcjccgniulidb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value This is the safety profile of the Gallery Image Version.
     */
    @JvmName("euyvsmewganyqkmq")
    public suspend fun safetyProfile(`value`: GalleryImageVersionSafetyProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.safetyProfile = mapped
    }

    /**
     * @param argument This is the safety profile of the Gallery Image Version.
     */
    @JvmName("sqluegwevesbrlin")
    public suspend
    fun safetyProfile(argument: suspend GalleryImageVersionSafetyProfileArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryImageVersionSafetyProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.safetyProfile = mapped
    }

    /**
     * @param value This is the storage profile of a Gallery Image Version.
     */
    @JvmName("ehkoysmejmlgklcj")
    public suspend fun storageProfile(`value`: GalleryImageVersionStorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument This is the storage profile of a Gallery Image Version.
     */
    @JvmName("lilbjcjbcgywhjjv")
    public suspend
    fun storageProfile(argument: suspend GalleryImageVersionStorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryImageVersionStorageProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("rdwrusewoxfihnlg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("dllrlaypihkuosae")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GalleryImageVersionArgs = GalleryImageVersionArgs(
        galleryImageName = galleryImageName,
        galleryImageVersionName = galleryImageVersionName,
        galleryName = galleryName,
        location = location,
        publishingProfile = publishingProfile,
        resourceGroupName = resourceGroupName,
        safetyProfile = safetyProfile,
        storageProfile = storageProfile,
        tags = tags,
    )
}
