@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.ImageArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.HyperVGenerationTypes
import com.pulumi.azurenative.compute.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.compute.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.ImageStorageProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.ImageStorageProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-07-01, 2023-09-01.
 * ## Example Usage
 * ### Create a virtual machine image from a blob with DiskEncryptionSet resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 BlobUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *                 DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                 },
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * ImageName: pulumi.String("myImage"),
 * Location: pulumi.String("West US"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * StorageProfile: compute.ImageStorageProfileResponse{
 * OsDisk: interface{}{
 * BlobUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * },
 * OsState: compute.OperatingSystemStateTypesGeneralized,
 * OsType: compute.OperatingSystemTypesLinux,
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(Map.of("osDisk", Map.ofEntries(
 *                 Map.entry("blobUri", "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 *                 Map.entry("diskEncryptionSet", Map.of("id", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")),
 *                 Map.entry("osState", "Generalized"),
 *                 Map.entry("osType", "Linux")
 *             )))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image from a blob.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 BlobUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *             },
 *             ZoneResilient = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * 			ImageName:         pulumi.String("myImage"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: compute.ImageStorageProfileResponse{
 * 				OsDisk: &compute.ImageOSDiskArgs{
 * 					BlobUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 					OsState: compute.OperatingSystemStateTypesGeneralized,
 * 					OsType:  compute.OperatingSystemTypesLinux,
 * 				},
 * 				ZoneResilient: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("osDisk", Map.ofEntries(
 *                     Map.entry("blobUri", "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 *                     Map.entry("osState", "Generalized"),
 *                     Map.entry("osType", "Linux")
 *                 )),
 *                 Map.entry("zoneResilient", true)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image from a managed disk with DiskEncryptionSet resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                 },
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *                 Snapshot = new AzureNative.Compute.Inputs.SubResourceArgs
 *                 {
 *                     Id = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * ImageName: pulumi.String("myImage"),
 * Location: pulumi.String("West US"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * StorageProfile: compute.ImageStorageProfileResponse{
 * OsDisk: interface{}{
 * DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * },
 * OsState: compute.OperatingSystemStateTypesGeneralized,
 * OsType: compute.OperatingSystemTypesLinux,
 * Snapshot: &compute.SubResourceArgs{
 * Id: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot"),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(Map.of("osDisk", Map.ofEntries(
 *                 Map.entry("diskEncryptionSet", Map.of("id", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")),
 *                 Map.entry("osState", "Generalized"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("snapshot", Map.of("id", "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot"))
 *             )))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image from a managed disk.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 ManagedDisk = new AzureNative.Compute.Inputs.SubResourceArgs
 *                 {
 *                     Id = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk",
 *                 },
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *             },
 *             ZoneResilient = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * ImageName: pulumi.String("myImage"),
 * Location: pulumi.String("West US"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * StorageProfile: compute.ImageStorageProfileResponse{
 * OsDisk: interface{}{
 * ManagedDisk: &compute.SubResourceArgs{
 * Id: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk"),
 * },
 * OsState: compute.OperatingSystemStateTypesGeneralized,
 * OsType: compute.OperatingSystemTypesLinux,
 * },
 * ZoneResilient: pulumi.Bool(true),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("osDisk", Map.ofEntries(
 *                     Map.entry("managedDisk", Map.of("id", "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk")),
 *                     Map.entry("osState", "Generalized"),
 *                     Map.entry("osType", "Linux")
 *                 )),
 *                 Map.entry("zoneResilient", true)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image from a snapshot with DiskEncryptionSet resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                 },
 *                 ManagedDisk = new AzureNative.Compute.Inputs.SubResourceArgs
 *                 {
 *                     Id = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk",
 *                 },
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * ImageName: pulumi.String("myImage"),
 * Location: pulumi.String("West US"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * StorageProfile: compute.ImageStorageProfileResponse{
 * OsDisk: interface{}{
 * DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * },
 * ManagedDisk: &compute.SubResourceArgs{
 * Id: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk"),
 * },
 * OsState: compute.OperatingSystemStateTypesGeneralized,
 * OsType: compute.OperatingSystemTypesLinux,
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(Map.of("osDisk", Map.ofEntries(
 *                 Map.entry("diskEncryptionSet", Map.of("id", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")),
 *                 Map.entry("managedDisk", Map.of("id", "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk")),
 *                 Map.entry("osState", "Generalized"),
 *                 Map.entry("osType", "Linux")
 *             )))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image from a snapshot.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *                 Snapshot = new AzureNative.Compute.Inputs.SubResourceArgs
 *                 {
 *                     Id = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot",
 *                 },
 *             },
 *             ZoneResilient = false,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * ImageName: pulumi.String("myImage"),
 * Location: pulumi.String("West US"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * StorageProfile: compute.ImageStorageProfileResponse{
 * OsDisk: interface{}{
 * OsState: compute.OperatingSystemStateTypesGeneralized,
 * OsType: compute.OperatingSystemTypesLinux,
 * Snapshot: &compute.SubResourceArgs{
 * Id: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot"),
 * },
 * },
 * ZoneResilient: pulumi.Bool(false),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("osDisk", Map.ofEntries(
 *                     Map.entry("osState", "Generalized"),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("snapshot", Map.of("id", "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot"))
 *                 )),
 *                 Map.entry("zoneResilient", false)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image from an existing virtual machine.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         SourceVirtualMachine = new AzureNative.Compute.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVM",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * 			ImageName:         pulumi.String("myImage"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SourceVirtualMachine: &compute.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVM"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sourceVirtualMachine(Map.of("id", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVM"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image that includes a data disk from a blob.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             DataDisks = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.ImageDataDiskArgs
 *                 {
 *                     BlobUri = "https://mystorageaccount.blob.core.windows.net/dataimages/dataimage.vhd",
 *                     Lun = 1,
 *                 },
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 BlobUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *             },
 *             ZoneResilient = false,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * 			ImageName:         pulumi.String("myImage"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: compute.ImageStorageProfileResponse{
 * 				DataDisks: compute.ImageDataDiskArray{
 * 					&compute.ImageDataDiskArgs{
 * 						BlobUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/dataimages/dataimage.vhd"),
 * 						Lun:     pulumi.Int(1),
 * 					},
 * 				},
 * 				OsDisk: &compute.ImageOSDiskArgs{
 * 					BlobUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 					OsState: compute.OperatingSystemStateTypesGeneralized,
 * 					OsType:  compute.OperatingSystemTypesLinux,
 * 				},
 * 				ZoneResilient: pulumi.Bool(false),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("dataDisks", Map.ofEntries(
 *                     Map.entry("blobUri", "https://mystorageaccount.blob.core.windows.net/dataimages/dataimage.vhd"),
 *                     Map.entry("lun", 1)
 *                 )),
 *                 Map.entry("osDisk", Map.ofEntries(
 *                     Map.entry("blobUri", "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 *                     Map.entry("osState", "Generalized"),
 *                     Map.entry("osType", "Linux")
 *                 )),
 *                 Map.entry("zoneResilient", false)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image that includes a data disk from a managed disk.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             DataDisks = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.ImageDataDiskArgs
 *                 {
 *                     Lun = 1,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.SubResourceArgs
 *                     {
 *                         Id = "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk2",
 *                     },
 *                 },
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 ManagedDisk = new AzureNative.Compute.Inputs.SubResourceArgs
 *                 {
 *                     Id = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk",
 *                 },
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *             },
 *             ZoneResilient = false,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * ImageName: pulumi.String("myImage"),
 * Location: pulumi.String("West US"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * StorageProfile: compute.ImageStorageProfileResponse{
 * DataDisks: compute.ImageDataDiskArray{
 * interface{}{
 * Lun: pulumi.Int(1),
 * ManagedDisk: &compute.SubResourceArgs{
 * Id: pulumi.String("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk2"),
 * },
 * },
 * },
 * OsDisk: interface{}{
 * ManagedDisk: &compute.SubResourceArgs{
 * Id: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk"),
 * },
 * OsState: compute.OperatingSystemStateTypesGeneralized,
 * OsType: compute.OperatingSystemTypesLinux,
 * },
 * ZoneResilient: pulumi.Bool(false),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("dataDisks", Map.ofEntries(
 *                     Map.entry("lun", 1),
 *                     Map.entry("managedDisk", Map.of("id", "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk2"))
 *                 )),
 *                 Map.entry("osDisk", Map.ofEntries(
 *                     Map.entry("managedDisk", Map.of("id", "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk")),
 *                     Map.entry("osState", "Generalized"),
 *                     Map.entry("osType", "Linux")
 *                 )),
 *                 Map.entry("zoneResilient", false)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image that includes a data disk from a snapshot.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             DataDisks = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.ImageDataDiskArgs
 *                 {
 *                     Lun = 1,
 *                     Snapshot = new AzureNative.Compute.Inputs.SubResourceArgs
 *                     {
 *                         Id = "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot2",
 *                     },
 *                 },
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *                 Snapshot = new AzureNative.Compute.Inputs.SubResourceArgs
 *                 {
 *                     Id = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot",
 *                 },
 *             },
 *             ZoneResilient = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * ImageName: pulumi.String("myImage"),
 * Location: pulumi.String("West US"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * StorageProfile: compute.ImageStorageProfileResponse{
 * DataDisks: compute.ImageDataDiskArray{
 * interface{}{
 * Lun: pulumi.Int(1),
 * Snapshot: &compute.SubResourceArgs{
 * Id: pulumi.String("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot2"),
 * },
 * },
 * },
 * OsDisk: interface{}{
 * OsState: compute.OperatingSystemStateTypesGeneralized,
 * OsType: compute.OperatingSystemTypesLinux,
 * Snapshot: &compute.SubResourceArgs{
 * Id: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot"),
 * },
 * },
 * ZoneResilient: pulumi.Bool(true),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("dataDisks", Map.ofEntries(
 *                     Map.entry("lun", 1),
 *                     Map.entry("snapshot", Map.of("id", "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot2"))
 *                 )),
 *                 Map.entry("osDisk", Map.ofEntries(
 *                     Map.entry("osState", "Generalized"),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("snapshot", Map.of("id", "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot"))
 *                 )),
 *                 Map.entry("zoneResilient", true)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:Image myImage /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/images/{imageName}
 * ```
 * @property extendedLocation The extended location of the Image.
 * @property hyperVGeneration Specifies the HyperVGenerationType of the VirtualMachine created from the image. From API Version 2019-03-01 if the image source is a blob, then we need the user to specify the value, if the source is managed resource like disk or snapshot, we may require the user to specify the property if we cannot deduce it from the source managed resource.
 * @property imageName The name of the image.
 * @property location Resource location
 * @property resourceGroupName The name of the resource group.
 * @property sourceVirtualMachine The source virtual machine from which Image is created.
 * @property storageProfile Specifies the storage settings for the virtual machine disks.
 * @property tags Resource tags
 */
public data class ImageArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val hyperVGeneration: Output<Either<String, HyperVGenerationTypes>>? = null,
    public val imageName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sourceVirtualMachine: Output<SubResourceArgs>? = null,
    public val storageProfile: Output<ImageStorageProfileArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.ImageArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.ImageArgs =
        com.pulumi.azurenative.compute.ImageArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hyperVGeneration(
                hyperVGeneration?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .imageName(imageName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sourceVirtualMachine(
                sourceVirtualMachine?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .storageProfile(storageProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ImageArgs].
 */
@PulumiTagMarker
public class ImageArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var hyperVGeneration: Output<Either<String, HyperVGenerationTypes>>? = null

    private var imageName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sourceVirtualMachine: Output<SubResourceArgs>? = null

    private var storageProfile: Output<ImageStorageProfileArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The extended location of the Image.
     */
    @JvmName("fjtqvdtlqtmnbxjh")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Specifies the HyperVGenerationType of the VirtualMachine created from the image. From API Version 2019-03-01 if the image source is a blob, then we need the user to specify the value, if the source is managed resource like disk or snapshot, we may require the user to specify the property if we cannot deduce it from the source managed resource.
     */
    @JvmName("hhfbcosqmfljmehw")
    public suspend fun hyperVGeneration(`value`: Output<Either<String, HyperVGenerationTypes>>) {
        this.hyperVGeneration = value
    }

    /**
     * @param value The name of the image.
     */
    @JvmName("wnblqbqevivwjtdm")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("tuqjfeifnfrjnksu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xchkmhwvxqwlnchl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The source virtual machine from which Image is created.
     */
    @JvmName("dadwnldghsubouca")
    public suspend fun sourceVirtualMachine(`value`: Output<SubResourceArgs>) {
        this.sourceVirtualMachine = value
    }

    /**
     * @param value Specifies the storage settings for the virtual machine disks.
     */
    @JvmName("ecpaxrsskfjcmmll")
    public suspend fun storageProfile(`value`: Output<ImageStorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ynnpalxlyilwklxb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The extended location of the Image.
     */
    @JvmName("qovtungyftrcofih")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the Image.
     */
    @JvmName("iinaomvlmjccljbu")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Specifies the HyperVGenerationType of the VirtualMachine created from the image. From API Version 2019-03-01 if the image source is a blob, then we need the user to specify the value, if the source is managed resource like disk or snapshot, we may require the user to specify the property if we cannot deduce it from the source managed resource.
     */
    @JvmName("vivbikiytvhltdmj")
    public suspend fun hyperVGeneration(`value`: Either<String, HyperVGenerationTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value Specifies the HyperVGenerationType of the VirtualMachine created from the image. From API Version 2019-03-01 if the image source is a blob, then we need the user to specify the value, if the source is managed resource like disk or snapshot, we may require the user to specify the property if we cannot deduce it from the source managed resource.
     */
    @JvmName("pstvpbpygfvyenod")
    public fun hyperVGeneration(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HyperVGenerationTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value Specifies the HyperVGenerationType of the VirtualMachine created from the image. From API Version 2019-03-01 if the image source is a blob, then we need the user to specify the value, if the source is managed resource like disk or snapshot, we may require the user to specify the property if we cannot deduce it from the source managed resource.
     */
    @JvmName("oiskqejxiujnbyyt")
    public fun hyperVGeneration(`value`: HyperVGenerationTypes) {
        val toBeMapped = Either.ofRight<String, HyperVGenerationTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value The name of the image.
     */
    @JvmName("wmhigsjdfwyxyshv")
    public suspend fun imageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("cpkefqfffjktllpc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vdipxnopnwlkeegw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The source virtual machine from which Image is created.
     */
    @JvmName("tqhoxcjvqyruqqlj")
    public suspend fun sourceVirtualMachine(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceVirtualMachine = mapped
    }

    /**
     * @param argument The source virtual machine from which Image is created.
     */
    @JvmName("fmcixqwxqdxaeeoh")
    public suspend fun sourceVirtualMachine(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceVirtualMachine = mapped
    }

    /**
     * @param value Specifies the storage settings for the virtual machine disks.
     */
    @JvmName("shwvlcooxdnmayfl")
    public suspend fun storageProfile(`value`: ImageStorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument Specifies the storage settings for the virtual machine disks.
     */
    @JvmName("xgxjvrnotmwwfhdc")
    public suspend fun storageProfile(argument: suspend ImageStorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ImageStorageProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("orlxoirlnyicstrq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("tmyfqpnndwccacvi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ImageArgs = ImageArgs(
        extendedLocation = extendedLocation,
        hyperVGeneration = hyperVGeneration,
        imageName = imageName,
        location = location,
        resourceGroupName = resourceGroupName,
        sourceVirtualMachine = sourceVirtualMachine,
        storageProfile = storageProfile,
        tags = tags,
    )
}
