@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.RestorePointCollectionSourcePropertiesResponse
import com.pulumi.azurenative.compute.kotlin.outputs.RestorePointResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.RestorePointCollectionSourcePropertiesResponse.Companion.toKotlin as restorePointCollectionSourcePropertiesResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.RestorePointResponse.Companion.toKotlin as restorePointResponseToKotlin

/**
 * Builder for [RestorePointCollection].
 */
@PulumiTagMarker
public class RestorePointCollectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RestorePointCollectionArgs = RestorePointCollectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RestorePointCollectionArgsBuilder.() -> Unit) {
        val builder = RestorePointCollectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RestorePointCollection {
        val builtJavaResource =
            com.pulumi.azurenative.compute.RestorePointCollection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RestorePointCollection(builtJavaResource)
    }
}

/**
 * Create or update Restore Point collection parameters.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-07-01, 2023-09-01.
 * ## Example Usage
 * ### Create or update a restore point collection for cross region copy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var restorePointCollection = new AzureNative.Compute.RestorePointCollection("restorePointCollection", new()
 *     {
 *         Location = "norwayeast",
 *         ResourceGroupName = "myResourceGroup",
 *         RestorePointCollectionName = "myRpc",
 *         Source = new AzureNative.Compute.Inputs.RestorePointCollectionSourcePropertiesArgs
 *         {
 *             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/restorePointCollections/sourceRpcName",
 *         },
 *         Tags =
 *         {
 *             { "myTag1", "tagValue1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewRestorePointCollection(ctx, "restorePointCollection", &compute.RestorePointCollectionArgs{
 * 			Location:                   pulumi.String("norwayeast"),
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 			RestorePointCollectionName: pulumi.String("myRpc"),
 * 			Source: &compute.RestorePointCollectionSourcePropertiesArgs{
 * 				Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/restorePointCollections/sourceRpcName"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"myTag1": pulumi.String("tagValue1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.RestorePointCollection;
 * import com.pulumi.azurenative.compute.RestorePointCollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var restorePointCollection = new RestorePointCollection("restorePointCollection", RestorePointCollectionArgs.builder()
 *             .location("norwayeast")
 *             .resourceGroupName("myResourceGroup")
 *             .restorePointCollectionName("myRpc")
 *             .source(Map.of("id", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/restorePointCollections/sourceRpcName"))
 *             .tags(Map.of("myTag1", "tagValue1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a restore point collection.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var restorePointCollection = new AzureNative.Compute.RestorePointCollection("restorePointCollection", new()
 *     {
 *         Location = "norwayeast",
 *         ResourceGroupName = "myResourceGroup",
 *         RestorePointCollectionName = "myRpc",
 *         Source = new AzureNative.Compute.Inputs.RestorePointCollectionSourcePropertiesArgs
 *         {
 *             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVM",
 *         },
 *         Tags =
 *         {
 *             { "myTag1", "tagValue1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewRestorePointCollection(ctx, "restorePointCollection", &compute.RestorePointCollectionArgs{
 * 			Location:                   pulumi.String("norwayeast"),
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 			RestorePointCollectionName: pulumi.String("myRpc"),
 * 			Source: &compute.RestorePointCollectionSourcePropertiesArgs{
 * 				Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVM"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"myTag1": pulumi.String("tagValue1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.RestorePointCollection;
 * import com.pulumi.azurenative.compute.RestorePointCollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var restorePointCollection = new RestorePointCollection("restorePointCollection", RestorePointCollectionArgs.builder()
 *             .location("norwayeast")
 *             .resourceGroupName("myResourceGroup")
 *             .restorePointCollectionName("myRpc")
 *             .source(Map.of("id", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVM"))
 *             .tags(Map.of("myTag1", "tagValue1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:RestorePointCollection myRpc /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/restorePointCollections/{restorePointCollectionName}
 * ```
 */
public class RestorePointCollection internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.RestorePointCollection,
) : KotlinCustomResource(javaResource, RestorePointCollectionMapper) {
    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the restore point collection.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The unique id of the restore point collection.
     */
    public val restorePointCollectionId: Output<String>
        get() = javaResource.restorePointCollectionId().applyValue({ args0 -> args0 })

    /**
     * A list containing all restore points created under this restore point collection.
     */
    public val restorePoints: Output<List<RestorePointResponse>>
        get() = javaResource.restorePoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> restorePointResponseToKotlin(args0) })
            })
        })

    /**
     * The properties of the source resource that this restore point collection is created from.
     */
    public val source: Output<RestorePointCollectionSourcePropertiesResponse>?
        get() = javaResource.source().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    restorePointCollectionSourcePropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RestorePointCollectionMapper : ResourceMapper<RestorePointCollection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.RestorePointCollection::class == javaResource::class

    override fun map(javaResource: Resource): RestorePointCollection =
        RestorePointCollection(javaResource as com.pulumi.azurenative.compute.RestorePointCollection)
}

/**
 * @see [RestorePointCollection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RestorePointCollection].
 */
public suspend fun restorePointCollection(
    name: String,
    block: suspend RestorePointCollectionResourceBuilder.() -> Unit,
): RestorePointCollection {
    val builder = RestorePointCollectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RestorePointCollection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun restorePointCollection(name: String): RestorePointCollection {
    val builder = RestorePointCollectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
