@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.SnapshotArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.DataAccessAuthMode
import com.pulumi.azurenative.compute.kotlin.enums.HyperVGeneration
import com.pulumi.azurenative.compute.kotlin.enums.NetworkAccessPolicy
import com.pulumi.azurenative.compute.kotlin.enums.OperatingSystemTypes
import com.pulumi.azurenative.compute.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.compute.kotlin.inputs.CopyCompletionErrorArgs
import com.pulumi.azurenative.compute.kotlin.inputs.CopyCompletionErrorArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.CreationDataArgs
import com.pulumi.azurenative.compute.kotlin.inputs.CreationDataArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.DiskSecurityProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.DiskSecurityProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.EncryptionArgs
import com.pulumi.azurenative.compute.kotlin.inputs.EncryptionArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.EncryptionSettingsCollectionArgs
import com.pulumi.azurenative.compute.kotlin.inputs.EncryptionSettingsCollectionArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.compute.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.PurchasePlanArgs
import com.pulumi.azurenative.compute.kotlin.inputs.PurchasePlanArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.SnapshotSkuArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SnapshotSkuArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.SupportedCapabilitiesArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SupportedCapabilitiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Snapshot resource.
 * Azure REST API version: 2022-07-02. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-04-30-preview, 2017-03-30, 2018-06-01, 2023-01-02, 2023-04-02, 2023-10-02.
 * ## Example Usage
 * ### Create a snapshot by importing an unmanaged blob from a different subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshot = new AzureNative.Compute.Snapshot("snapshot", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Import",
 *             SourceUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *             StorageAccountId = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         SnapshotName = "mySnapshot1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewSnapshot(ctx, "snapshot", &compute.SnapshotArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String("Import"),
 * 				SourceUri:        pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 				StorageAccountId: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SnapshotName:      pulumi.String("mySnapshot1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Snapshot;
 * import com.pulumi.azurenative.compute.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshot = new Snapshot("snapshot", SnapshotArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "Import"),
 *                 Map.entry("sourceUri", "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 *                 Map.entry("storageAccountId", "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount")
 *             ))
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .snapshotName("mySnapshot1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a snapshot by importing an unmanaged blob from the same subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshot = new AzureNative.Compute.Snapshot("snapshot", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Import",
 *             SourceUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         SnapshotName = "mySnapshot1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewSnapshot(ctx, "snapshot", &compute.SnapshotArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String("Import"),
 * 				SourceUri:    pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SnapshotName:      pulumi.String("mySnapshot1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Snapshot;
 * import com.pulumi.azurenative.compute.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshot = new Snapshot("snapshot", SnapshotArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "Import"),
 *                 Map.entry("sourceUri", "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd")
 *             ))
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .snapshotName("mySnapshot1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a snapshot from an existing snapshot in the same or a different subscription in a different region.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshot = new AzureNative.Compute.Snapshot("snapshot", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "CopyStart",
 *             SourceResourceId = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot1",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         SnapshotName = "mySnapshot2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewSnapshot(ctx, "snapshot", &compute.SnapshotArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String("CopyStart"),
 * 				SourceResourceId: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot1"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SnapshotName:      pulumi.String("mySnapshot2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Snapshot;
 * import com.pulumi.azurenative.compute.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshot = new Snapshot("snapshot", SnapshotArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "CopyStart"),
 *                 Map.entry("sourceResourceId", "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot1")
 *             ))
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .snapshotName("mySnapshot2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a snapshot from an existing snapshot in the same or a different subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshot = new AzureNative.Compute.Snapshot("snapshot", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Copy",
 *             SourceResourceId = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot1",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         SnapshotName = "mySnapshot2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewSnapshot(ctx, "snapshot", &compute.SnapshotArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String("Copy"),
 * 				SourceResourceId: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot1"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SnapshotName:      pulumi.String("mySnapshot2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Snapshot;
 * import com.pulumi.azurenative.compute.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshot = new Snapshot("snapshot", SnapshotArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "Copy"),
 *                 Map.entry("sourceResourceId", "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot1")
 *             ))
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .snapshotName("mySnapshot2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:Snapshot mySnapshot2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}
 * ```
 * @property completionPercent Percentage complete for the background copy when a resource is created via the CopyStart operation.
 * @property copyCompletionError Indicates the error details if the background copy of a resource created via the CopyStart operation fails.
 * @property creationData Disk source information. CreationData information cannot be changed after the disk has been created.
 * @property dataAccessAuthMode Additional authentication requirements when exporting or uploading to a disk or snapshot.
 * @property diskAccessId ARM id of the DiskAccess resource for using private endpoints on disks.
 * @property diskSizeGB If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
 * @property encryption Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
 * @property encryptionSettingsCollection Encryption settings collection used be Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
 * @property extendedLocation The extended location where the snapshot will be created. Extended location cannot be changed.
 * @property hyperVGeneration The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
 * @property incremental Whether a snapshot is incremental. Incremental snapshots on the same disk occupy less space than full snapshots and can be diffed.
 * @property location Resource location
 * @property networkAccessPolicy Policy for accessing the disk via network.
 * @property osType The Operating System type.
 * @property publicNetworkAccess Policy for controlling export on the disk.
 * @property purchasePlan Purchase plan information for the image from which the source disk for the snapshot was originally created.
 * @property resourceGroupName The name of the resource group.
 * @property securityProfile Contains the security related information for the resource.
 * @property sku The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional parameter for incremental snapshot and the default behavior is the SKU will be set to the same sku as the previous snapshot
 * @property snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80 characters.
 * @property supportedCapabilities List of supported capabilities for the image from which the source disk from the snapshot was originally created.
 * @property supportsHibernation Indicates the OS on a snapshot supports hibernation.
 * @property tags Resource tags
 */
public data class SnapshotArgs(
    public val completionPercent: Output<Double>? = null,
    public val copyCompletionError: Output<CopyCompletionErrorArgs>? = null,
    public val creationData: Output<CreationDataArgs>? = null,
    public val dataAccessAuthMode: Output<Either<String, DataAccessAuthMode>>? = null,
    public val diskAccessId: Output<String>? = null,
    public val diskSizeGB: Output<Int>? = null,
    public val encryption: Output<EncryptionArgs>? = null,
    public val encryptionSettingsCollection: Output<EncryptionSettingsCollectionArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val hyperVGeneration: Output<Either<String, HyperVGeneration>>? = null,
    public val incremental: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val networkAccessPolicy: Output<Either<String, NetworkAccessPolicy>>? = null,
    public val osType: Output<OperatingSystemTypes>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val purchasePlan: Output<PurchasePlanArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityProfile: Output<DiskSecurityProfileArgs>? = null,
    public val sku: Output<SnapshotSkuArgs>? = null,
    public val snapshotName: Output<String>? = null,
    public val supportedCapabilities: Output<SupportedCapabilitiesArgs>? = null,
    public val supportsHibernation: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.SnapshotArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.SnapshotArgs =
        com.pulumi.azurenative.compute.SnapshotArgs.builder()
            .completionPercent(completionPercent?.applyValue({ args0 -> args0 }))
            .copyCompletionError(
                copyCompletionError?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .creationData(creationData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataAccessAuthMode(
                dataAccessAuthMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .diskAccessId(diskAccessId?.applyValue({ args0 -> args0 }))
            .diskSizeGB(diskSizeGB?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encryptionSettingsCollection(
                encryptionSettingsCollection?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hyperVGeneration(
                hyperVGeneration?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .incremental(incremental?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkAccessPolicy(
                networkAccessPolicy?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .osType(osType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .purchasePlan(purchasePlan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityProfile(securityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .snapshotName(snapshotName?.applyValue({ args0 -> args0 }))
            .supportedCapabilities(
                supportedCapabilities?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .supportsHibernation(supportsHibernation?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SnapshotArgs].
 */
@PulumiTagMarker
public class SnapshotArgsBuilder internal constructor() {
    private var completionPercent: Output<Double>? = null

    private var copyCompletionError: Output<CopyCompletionErrorArgs>? = null

    private var creationData: Output<CreationDataArgs>? = null

    private var dataAccessAuthMode: Output<Either<String, DataAccessAuthMode>>? = null

    private var diskAccessId: Output<String>? = null

    private var diskSizeGB: Output<Int>? = null

    private var encryption: Output<EncryptionArgs>? = null

    private var encryptionSettingsCollection: Output<EncryptionSettingsCollectionArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var hyperVGeneration: Output<Either<String, HyperVGeneration>>? = null

    private var incremental: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var networkAccessPolicy: Output<Either<String, NetworkAccessPolicy>>? = null

    private var osType: Output<OperatingSystemTypes>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var purchasePlan: Output<PurchasePlanArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityProfile: Output<DiskSecurityProfileArgs>? = null

    private var sku: Output<SnapshotSkuArgs>? = null

    private var snapshotName: Output<String>? = null

    private var supportedCapabilities: Output<SupportedCapabilitiesArgs>? = null

    private var supportsHibernation: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Percentage complete for the background copy when a resource is created via the CopyStart operation.
     */
    @JvmName("uiktexephbbsbpes")
    public suspend fun completionPercent(`value`: Output<Double>) {
        this.completionPercent = value
    }

    /**
     * @param value Indicates the error details if the background copy of a resource created via the CopyStart operation fails.
     */
    @JvmName("fcggdwmyvnilfosw")
    public suspend fun copyCompletionError(`value`: Output<CopyCompletionErrorArgs>) {
        this.copyCompletionError = value
    }

    /**
     * @param value Disk source information. CreationData information cannot be changed after the disk has been created.
     */
    @JvmName("qkqalepqnxjetacb")
    public suspend fun creationData(`value`: Output<CreationDataArgs>) {
        this.creationData = value
    }

    /**
     * @param value Additional authentication requirements when exporting or uploading to a disk or snapshot.
     */
    @JvmName("gftyigjpkcxnfhhn")
    public suspend fun dataAccessAuthMode(`value`: Output<Either<String, DataAccessAuthMode>>) {
        this.dataAccessAuthMode = value
    }

    /**
     * @param value ARM id of the DiskAccess resource for using private endpoints on disks.
     */
    @JvmName("gyodhvpvbliipxoi")
    public suspend fun diskAccessId(`value`: Output<String>) {
        this.diskAccessId = value
    }

    /**
     * @param value If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
     */
    @JvmName("ssexrgtrxuqbvcyu")
    public suspend fun diskSizeGB(`value`: Output<Int>) {
        this.diskSizeGB = value
    }

    /**
     * @param value Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
     */
    @JvmName("tuwpyxgtkaoirgvt")
    public suspend fun encryption(`value`: Output<EncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value Encryption settings collection used be Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
     */
    @JvmName("iathrluvkewsmiwr")
    public suspend
    fun encryptionSettingsCollection(`value`: Output<EncryptionSettingsCollectionArgs>) {
        this.encryptionSettingsCollection = value
    }

    /**
     * @param value The extended location where the snapshot will be created. Extended location cannot be changed.
     */
    @JvmName("rnunfximntemmreh")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    @JvmName("oebgdqevcflcvgmf")
    public suspend fun hyperVGeneration(`value`: Output<Either<String, HyperVGeneration>>) {
        this.hyperVGeneration = value
    }

    /**
     * @param value Whether a snapshot is incremental. Incremental snapshots on the same disk occupy less space than full snapshots and can be diffed.
     */
    @JvmName("hdtcotskhddvuhdi")
    public suspend fun incremental(`value`: Output<Boolean>) {
        this.incremental = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("rftucghifvwomibw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Policy for accessing the disk via network.
     */
    @JvmName("dxnwanbvyofawgmw")
    public suspend fun networkAccessPolicy(`value`: Output<Either<String, NetworkAccessPolicy>>) {
        this.networkAccessPolicy = value
    }

    /**
     * @param value The Operating System type.
     */
    @JvmName("fisyaufqltexnyun")
    public suspend fun osType(`value`: Output<OperatingSystemTypes>) {
        this.osType = value
    }

    /**
     * @param value Policy for controlling export on the disk.
     */
    @JvmName("ctlscekbhnxyuvpu")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Purchase plan information for the image from which the source disk for the snapshot was originally created.
     */
    @JvmName("xaejeqponqcaulpp")
    public suspend fun purchasePlan(`value`: Output<PurchasePlanArgs>) {
        this.purchasePlan = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nhouupkishbuecoi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Contains the security related information for the resource.
     */
    @JvmName("wwtijvucacdpsyjc")
    public suspend fun securityProfile(`value`: Output<DiskSecurityProfileArgs>) {
        this.securityProfile = value
    }

    /**
     * @param value The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional parameter for incremental snapshot and the default behavior is the SKU will be set to the same sku as the previous snapshot
     */
    @JvmName("ydgnbemgycosldrq")
    public suspend fun sku(`value`: Output<SnapshotSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The name of the snapshot that is being created. The name can't be changed after the snapshot is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80 characters.
     */
    @JvmName("cbvctuuawgtwnquj")
    public suspend fun snapshotName(`value`: Output<String>) {
        this.snapshotName = value
    }

    /**
     * @param value List of supported capabilities for the image from which the source disk from the snapshot was originally created.
     */
    @JvmName("fhikhvfuokgnrcge")
    public suspend fun supportedCapabilities(`value`: Output<SupportedCapabilitiesArgs>) {
        this.supportedCapabilities = value
    }

    /**
     * @param value Indicates the OS on a snapshot supports hibernation.
     */
    @JvmName("svxqtmknvdiiyabt")
    public suspend fun supportsHibernation(`value`: Output<Boolean>) {
        this.supportsHibernation = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("qmotcqnmjpftnofl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Percentage complete for the background copy when a resource is created via the CopyStart operation.
     */
    @JvmName("bxdjujpfbuqdrwgg")
    public suspend fun completionPercent(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.completionPercent = mapped
    }

    /**
     * @param value Indicates the error details if the background copy of a resource created via the CopyStart operation fails.
     */
    @JvmName("icqpaefhoillailn")
    public suspend fun copyCompletionError(`value`: CopyCompletionErrorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyCompletionError = mapped
    }

    /**
     * @param argument Indicates the error details if the background copy of a resource created via the CopyStart operation fails.
     */
    @JvmName("kothrngrvonjnjjf")
    public suspend
    fun copyCompletionError(argument: suspend CopyCompletionErrorArgsBuilder.() -> Unit) {
        val toBeMapped = CopyCompletionErrorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.copyCompletionError = mapped
    }

    /**
     * @param value Disk source information. CreationData information cannot be changed after the disk has been created.
     */
    @JvmName("ihgefyjewqgsyyag")
    public suspend fun creationData(`value`: CreationDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationData = mapped
    }

    /**
     * @param argument Disk source information. CreationData information cannot be changed after the disk has been created.
     */
    @JvmName("futxgyifjvvjbxju")
    public suspend fun creationData(argument: suspend CreationDataArgsBuilder.() -> Unit) {
        val toBeMapped = CreationDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.creationData = mapped
    }

    /**
     * @param value Additional authentication requirements when exporting or uploading to a disk or snapshot.
     */
    @JvmName("djxoktrelyavnygt")
    public suspend fun dataAccessAuthMode(`value`: Either<String, DataAccessAuthMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataAccessAuthMode = mapped
    }

    /**
     * @param value Additional authentication requirements when exporting or uploading to a disk or snapshot.
     */
    @JvmName("xkduifdtgafnyhfj")
    public fun dataAccessAuthMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataAccessAuthMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataAccessAuthMode = mapped
    }

    /**
     * @param value Additional authentication requirements when exporting or uploading to a disk or snapshot.
     */
    @JvmName("hgnaflatfnyruqsd")
    public fun dataAccessAuthMode(`value`: DataAccessAuthMode) {
        val toBeMapped = Either.ofRight<String, DataAccessAuthMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataAccessAuthMode = mapped
    }

    /**
     * @param value ARM id of the DiskAccess resource for using private endpoints on disks.
     */
    @JvmName("dxvqjnhcmtrxbiew")
    public suspend fun diskAccessId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskAccessId = mapped
    }

    /**
     * @param value If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
     */
    @JvmName("mdemtaxwmqedqxhq")
    public suspend fun diskSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
     */
    @JvmName("pyjkvputnvtcsxje")
    public suspend fun encryption(`value`: EncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
     */
    @JvmName("pswtrqapubbtxnnt")
    public suspend fun encryption(argument: suspend EncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Encryption settings collection used be Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
     */
    @JvmName("iuvygcksryttxnqp")
    public suspend fun encryptionSettingsCollection(`value`: EncryptionSettingsCollectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionSettingsCollection = mapped
    }

    /**
     * @param argument Encryption settings collection used be Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
     */
    @JvmName("raujdluekmomokuv")
    public suspend
    fun encryptionSettingsCollection(argument: suspend EncryptionSettingsCollectionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionSettingsCollectionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionSettingsCollection = mapped
    }

    /**
     * @param value The extended location where the snapshot will be created. Extended location cannot be changed.
     */
    @JvmName("wahrlbftenqdokyv")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location where the snapshot will be created. Extended location cannot be changed.
     */
    @JvmName("ljfqbgkldetvesdn")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    @JvmName("tdkfuposohgxgtfx")
    public suspend fun hyperVGeneration(`value`: Either<String, HyperVGeneration>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    @JvmName("latbwxsvurxietqk")
    public fun hyperVGeneration(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HyperVGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    @JvmName("sstwxndkqcbjubny")
    public fun hyperVGeneration(`value`: HyperVGeneration) {
        val toBeMapped = Either.ofRight<String, HyperVGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value Whether a snapshot is incremental. Incremental snapshots on the same disk occupy less space than full snapshots and can be diffed.
     */
    @JvmName("djibjpobiomjdakn")
    public suspend fun incremental(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incremental = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("ddpsxdtsxcbjuudt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Policy for accessing the disk via network.
     */
    @JvmName("apbfmssmkloccbwl")
    public suspend fun networkAccessPolicy(`value`: Either<String, NetworkAccessPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAccessPolicy = mapped
    }

    /**
     * @param value Policy for accessing the disk via network.
     */
    @JvmName("bpucockepoiohhmg")
    public fun networkAccessPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkAccessPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkAccessPolicy = mapped
    }

    /**
     * @param value Policy for accessing the disk via network.
     */
    @JvmName("chrxkwktxivfjkld")
    public fun networkAccessPolicy(`value`: NetworkAccessPolicy) {
        val toBeMapped = Either.ofRight<String, NetworkAccessPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkAccessPolicy = mapped
    }

    /**
     * @param value The Operating System type.
     */
    @JvmName("cxjhbjfpivddawtf")
    public suspend fun osType(`value`: OperatingSystemTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Policy for controlling export on the disk.
     */
    @JvmName("sjgiaodmewovhfrc")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Policy for controlling export on the disk.
     */
    @JvmName("btplxtskywqjcvwg")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Policy for controlling export on the disk.
     */
    @JvmName("xhkswojkbllawoep")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Purchase plan information for the image from which the source disk for the snapshot was originally created.
     */
    @JvmName("nngdlncdwbrswixf")
    public suspend fun purchasePlan(`value`: PurchasePlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.purchasePlan = mapped
    }

    /**
     * @param argument Purchase plan information for the image from which the source disk for the snapshot was originally created.
     */
    @JvmName("kcmmiusjhqjivkhf")
    public suspend fun purchasePlan(argument: suspend PurchasePlanArgsBuilder.() -> Unit) {
        val toBeMapped = PurchasePlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.purchasePlan = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("caposmreiorwrvhr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Contains the security related information for the resource.
     */
    @JvmName("soohbuhkqiymjctp")
    public suspend fun securityProfile(`value`: DiskSecurityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfile = mapped
    }

    /**
     * @param argument Contains the security related information for the resource.
     */
    @JvmName("rrwgehfqgeblbnof")
    public suspend fun securityProfile(argument: suspend DiskSecurityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = DiskSecurityProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityProfile = mapped
    }

    /**
     * @param value The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional parameter for incremental snapshot and the default behavior is the SKU will be set to the same sku as the previous snapshot
     */
    @JvmName("lximdeuiutkqmoka")
    public suspend fun sku(`value`: SnapshotSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional parameter for incremental snapshot and the default behavior is the SKU will be set to the same sku as the previous snapshot
     */
    @JvmName("usnmdmidsyechwgs")
    public suspend fun sku(argument: suspend SnapshotSkuArgsBuilder.() -> Unit) {
        val toBeMapped = SnapshotSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The name of the snapshot that is being created. The name can't be changed after the snapshot is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80 characters.
     */
    @JvmName("teodcdnqqidnfnuc")
    public suspend fun snapshotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotName = mapped
    }

    /**
     * @param value List of supported capabilities for the image from which the source disk from the snapshot was originally created.
     */
    @JvmName("ptmshtixofdmvkjg")
    public suspend fun supportedCapabilities(`value`: SupportedCapabilitiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportedCapabilities = mapped
    }

    /**
     * @param argument List of supported capabilities for the image from which the source disk from the snapshot was originally created.
     */
    @JvmName("qylhgqslfbpcaeno")
    public suspend
    fun supportedCapabilities(argument: suspend SupportedCapabilitiesArgsBuilder.() -> Unit) {
        val toBeMapped = SupportedCapabilitiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.supportedCapabilities = mapped
    }

    /**
     * @param value Indicates the OS on a snapshot supports hibernation.
     */
    @JvmName("rfjlvgvcocttpgkb")
    public suspend fun supportsHibernation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportsHibernation = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("tvrhombvfirmuqxw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("uokjouuujutrnouc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SnapshotArgs = SnapshotArgs(
        completionPercent = completionPercent,
        copyCompletionError = copyCompletionError,
        creationData = creationData,
        dataAccessAuthMode = dataAccessAuthMode,
        diskAccessId = diskAccessId,
        diskSizeGB = diskSizeGB,
        encryption = encryption,
        encryptionSettingsCollection = encryptionSettingsCollection,
        extendedLocation = extendedLocation,
        hyperVGeneration = hyperVGeneration,
        incremental = incremental,
        location = location,
        networkAccessPolicy = networkAccessPolicy,
        osType = osType,
        publicNetworkAccess = publicNetworkAccess,
        purchasePlan = purchasePlan,
        resourceGroupName = resourceGroupName,
        securityProfile = securityProfile,
        sku = sku,
        snapshotName = snapshotName,
        supportedCapabilities = supportedCapabilities,
        supportsHibernation = supportsHibernation,
        tags = tags,
    )
}
