@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.AdditionalCapabilitiesResponse
import com.pulumi.azurenative.compute.kotlin.outputs.DiagnosticsProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.HardwareProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.NetworkProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.OSProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.PlanResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SecurityProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.compute.kotlin.outputs.StorageProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineExtensionResponse
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineIdentityResponse
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetVMInstanceViewResponse
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetVMNetworkProfileConfigurationResponse
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetVMProtectionPolicyResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.AdditionalCapabilitiesResponse.Companion.toKotlin as additionalCapabilitiesResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.DiagnosticsProfileResponse.Companion.toKotlin as diagnosticsProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.HardwareProfileResponse.Companion.toKotlin as hardwareProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin as networkProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.OSProfileResponse.Companion.toKotlin as oSProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.PlanResponse.Companion.toKotlin as planResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SecurityProfileResponse.Companion.toKotlin as securityProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.StorageProfileResponse.Companion.toKotlin as storageProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineExtensionResponse.Companion.toKotlin as virtualMachineExtensionResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineIdentityResponse.Companion.toKotlin as virtualMachineIdentityResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetVMInstanceViewResponse.Companion.toKotlin as virtualMachineScaleSetVMInstanceViewResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetVMNetworkProfileConfigurationResponse.Companion.toKotlin as virtualMachineScaleSetVMNetworkProfileConfigurationResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetVMProtectionPolicyResponse.Companion.toKotlin as virtualMachineScaleSetVMProtectionPolicyResponseToKotlin

/**
 * Builder for [VirtualMachineScaleSetVM].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetVMResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineScaleSetVMArgs = VirtualMachineScaleSetVMArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineScaleSetVMArgsBuilder.() -> Unit) {
        val builder = VirtualMachineScaleSetVMArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualMachineScaleSetVM {
        val builtJavaResource =
            com.pulumi.azurenative.compute.VirtualMachineScaleSetVM(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachineScaleSetVM(builtJavaResource)
    }
}

/**
 * Describes a virtual machine scale set virtual machine.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-07-01, 2023-09-01.
 * ## Example Usage
 * ### VirtualMachineScaleSetVM_Update_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSetVM = new AzureNative.Compute.VirtualMachineScaleSetVM("virtualMachineScaleSetVM", new()
 *     {
 *         AdditionalCapabilities = new AzureNative.Compute.Inputs.AdditionalCapabilitiesArgs
 *         {
 *             HibernationEnabled = true,
 *             UltraSSDEnabled = true,
 *         },
 *         AvailabilitySet = new AzureNative.Compute.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *         },
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *                 StorageUri = "aaaaaaaaaaaaa",
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = "Basic_A0",
 *             VmSizeProperties = new AzureNative.Compute.Inputs.VMSizePropertiesArgs
 *             {
 *                 VCPUsAvailable = 9,
 *                 VCPUsPerCore = 12,
 *             },
 *         },
 *         InstanceId = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
 *         LicenseType = "aaaaaaaaaa",
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkApiVersion = "2020-11-01",
 *             NetworkInterfaceConfigurations = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.VirtualMachineNetworkInterfaceConfigurationArgs
 *                 {
 *                     DeleteOption = "Delete",
 *                     DnsSettings = new AzureNative.Compute.Inputs.VirtualMachineNetworkInterfaceDnsSettingsConfigurationArgs
 *                     {
 *                         DnsServers = new[]
 *                         {
 *                             "aaaaaa",
 *                         },
 *                     },
 *                     DscpConfiguration = new AzureNative.Compute.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                     },
 *                     EnableAcceleratedNetworking = true,
 *                     EnableFpga = true,
 *                     EnableIPForwarding = true,
 *                     IpConfigurations = new[]
 *                     {
 *                         new AzureNative.Compute.Inputs.VirtualMachineNetworkInterfaceIPConfigurationArgs
 *                         {
 *                             ApplicationGatewayBackendAddressPools = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                             },
 *                             ApplicationSecurityGroups = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                             },
 *                             LoadBalancerBackendAddressPools = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                             },
 *                             Name = "aa",
 *                             Primary = true,
 *                             PrivateIPAddressVersion = "IPv4",
 *                             PublicIPAddressConfiguration = new AzureNative.Compute.Inputs.VirtualMachinePublicIPAddressConfigurationArgs
 *                             {
 *                                 DeleteOption = "Delete",
 *                                 DnsSettings = new AzureNative.Compute.Inputs.VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs
 *                                 {
 *                                     DomainNameLabel = "aaaaaaaaaaaaaaaaaaaaaaaaa",
 *                                 },
 *                                 IdleTimeoutInMinutes = 2,
 *                                 IpTags = new[]
 *                                 {
 *                                     new AzureNative.Compute.Inputs.VirtualMachineIpTagArgs
 *                                     {
 *                                         IpTagType = "aaaaaaaaaaaaaaaaaaaaaaaaa",
 *                                         Tag = "aaaaaaaaaaaaaaaaaaaa",
 *                                     },
 *                                 },
 *                                 Name = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
 *                                 PublicIPAddressVersion = "IPv4",
 *                                 PublicIPAllocationMethod = "Dynamic",
 *                                 PublicIPPrefix = new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                                 Sku = new AzureNative.Compute.Inputs.PublicIPAddressSkuArgs
 *                                 {
 *                                     Name = "Basic",
 *                                     Tier = "Regional",
 *                                 },
 *                             },
 *                             Subnet = new AzureNative.Compute.Inputs.SubResourceArgs
 *                             {
 *                                 Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                             },
 *                         },
 *                     },
 *                     Name = "aaaaaaaaaaa",
 *                     NetworkSecurityGroup = new AzureNative.Compute.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                     },
 *                     Primary = true,
 *                 },
 *             },
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     DeleteOption = "Delete",
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachineScaleSets/{vmss-name}/virtualMachines/0/networkInterfaces/vmsstestnetconfig5415",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         NetworkProfileConfiguration = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMNetworkProfileConfigurationArgs
 *         {
 *             NetworkInterfaceConfigurations = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                 {
 *                     DeleteOption = "Delete",
 *                     DnsSettings = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs
 *                     {
 *                         DnsServers = new() { },
 *                     },
 *                     EnableAcceleratedNetworking = true,
 *                     EnableFpga = true,
 *                     EnableIPForwarding = true,
 *                     IpConfigurations = new[]
 *                     {
 *                         new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                         {
 *                             ApplicationGatewayBackendAddressPools = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                             },
 *                             ApplicationSecurityGroups = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                             },
 *                             LoadBalancerBackendAddressPools = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                             },
 *                             LoadBalancerInboundNatPools = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                             },
 *                             Name = "vmsstestnetconfig9693",
 *                             Primary = true,
 *                             PrivateIPAddressVersion = "IPv4",
 *                             PublicIPAddressConfiguration = new AzureNative.Compute.Inputs.VirtualMachineScaleSetPublicIPAddressConfigurationArgs
 *                             {
 *                                 DeleteOption = "Delete",
 *                                 DnsSettings = new AzureNative.Compute.Inputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs
 *                                 {
 *                                     DomainNameLabel = "aaaaaaaaaaaaaaaaaa",
 *                                 },
 *                                 IdleTimeoutInMinutes = 18,
 *                                 IpTags = new[]
 *                                 {
 *                                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetIpTagArgs
 *                                     {
 *                                         IpTagType = "aaaaaaa",
 *                                         Tag = "aaaaaaaaaaaaaaaaaaaaaaaaaaa",
 *                                     },
 *                                 },
 *                                 Name = "aaaaaaaaaaaaaaaaaa",
 *                                 PublicIPAddressVersion = "IPv4",
 *                                 PublicIPPrefix = new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                                 Sku = new AzureNative.Compute.Inputs.PublicIPAddressSkuArgs
 *                                 {
 *                                     Name = "Basic",
 *                                     Tier = "Regional",
 *                                 },
 *                             },
 *                             Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                             {
 *                                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/vn4071/subnets/sn5503",
 *                             },
 *                         },
 *                     },
 *                     Name = "vmsstestnetconfig5415",
 *                     NetworkSecurityGroup = new AzureNative.Compute.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                     },
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "aaaaaaaaaaaaaaaa",
 *             AdminUsername = "Foo12",
 *             AllowExtensionOperations = true,
 *             ComputerName = "test000000",
 *             CustomData = "aaaa",
 *             LinuxConfiguration = new AzureNative.Compute.Inputs.LinuxConfigurationArgs
 *             {
 *                 DisablePasswordAuthentication = true,
 *                 PatchSettings = new AzureNative.Compute.Inputs.LinuxPatchSettingsArgs
 *                 {
 *                     AssessmentMode = "ImageDefault",
 *                     PatchMode = "ImageDefault",
 *                 },
 *                 ProvisionVMAgent = true,
 *                 Ssh = new AzureNative.Compute.Inputs.SshConfigurationArgs
 *                 {
 *                     PublicKeys = new[]
 *                     {
 *                         new AzureNative.Compute.Inputs.SshPublicKeyArgs
 *                         {
 *                             KeyData = "aaaaaa",
 *                             Path = "aaa",
 *                         },
 *                     },
 *                 },
 *             },
 *             RequireGuestProvisionSignal = true,
 *             Secrets = new() { },
 *             WindowsConfiguration = new AzureNative.Compute.Inputs.WindowsConfigurationArgs
 *             {
 *                 AdditionalUnattendContent = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.AdditionalUnattendContentArgs
 *                     {
 *                         ComponentName = AzureNative.Compute.ComponentNames.Microsoft_Windows_Shell_Setup,
 *                         Content = "aaaaaaaaaaaaaaaaaaaa",
 *                         PassName = AzureNative.Compute.PassNames.OobeSystem,
 *                         SettingName = AzureNative.Compute.SettingNames.AutoLogon,
 *                     },
 *                 },
 *                 EnableAutomaticUpdates = true,
 *                 PatchSettings = new AzureNative.Compute.Inputs.PatchSettingsArgs
 *                 {
 *                     AssessmentMode = "ImageDefault",
 *                     EnableHotpatching = true,
 *                     PatchMode = "Manual",
 *                 },
 *                 ProvisionVMAgent = true,
 *                 TimeZone = "aaaaaaaaaaaaaaaaaaaaaaaaaaa",
 *                 WinRM = new AzureNative.Compute.Inputs.WinRMConfigurationArgs
 *                 {
 *                     Listeners = new[]
 *                     {
 *                         new AzureNative.Compute.Inputs.WinRMListenerArgs
 *                         {
 *                             CertificateUrl = "aaaaaaaaaaaaaaaaaaaaaa",
 *                             Protocol = AzureNative.Compute.ProtocolTypes.Http,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "aaaaaaaaaa",
 *             Product = "aaaaaaaaaaaaaaaaaaaa",
 *             PromotionCode = "aaaaaaaaaaaaaaaaaaaa",
 *             Publisher = "aaaaaaaaaaaaaaaaaaaaaa",
 *         },
 *         ProtectionPolicy = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProtectionPolicyArgs
 *         {
 *             ProtectFromScaleIn = true,
 *             ProtectFromScaleSetActions = true,
 *         },
 *         ResourceGroupName = "rgcompute",
 *         SecurityProfile = new AzureNative.Compute.Inputs.SecurityProfileArgs
 *         {
 *             EncryptionAtHost = true,
 *             SecurityType = "TrustedLaunch",
 *             UefiSettings = new AzureNative.Compute.Inputs.UefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *                 VTpmEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             DataDisks = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.DataDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.None,
 *                     CreateOption = "Empty",
 *                     DeleteOption = "Delete",
 *                     DetachOption = "ForceDetach",
 *                     DiskSizeGB = 128,
 *                     Image = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                     {
 *                         Uri = "https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd",
 *                     },
 *                     Lun = 1,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                     {
 *                         DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                         {
 *                             Id = "aaaaaaaaaaaa",
 *                         },
 *                         Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vmss3176_vmss3176_0_disk2_6c4f554bdafa49baa780eb2d128ff39d",
 *                         StorageAccountType = "Standard_LRS",
 *                     },
 *                     Name = "vmss3176_vmss3176_0_disk2_6c4f554bdafa49baa780eb2d128ff39d",
 *                     ToBeDetached = true,
 *                     Vhd = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                     {
 *                         Uri = "https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd",
 *                     },
 *                     WriteAcceleratorEnabled = true,
 *                 },
 *             },
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Id = "a",
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 SharedGalleryImageId = "aaaaaaaaaaaaaaaaaaaa",
 *                 Sku = "2012-R2-Datacenter",
 *                 Version = "4.127.20180315",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.None,
 *                 CreateOption = "FromImage",
 *                 DeleteOption = "Delete",
 *                 DiffDiskSettings = new AzureNative.Compute.Inputs.DiffDiskSettingsArgs
 *                 {
 *                     Option = "Local",
 *                     Placement = "CacheDisk",
 *                 },
 *                 DiskSizeGB = 127,
 *                 EncryptionSettings = new AzureNative.Compute.Inputs.DiskEncryptionSettingsArgs
 *                 {
 *                     DiskEncryptionKey = new AzureNative.Compute.Inputs.KeyVaultSecretReferenceArgs
 *                     {
 *                         SecretUrl = "aaaaaaaa",
 *                         SourceVault = new AzureNative.Compute.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                         },
 *                     },
 *                     Enabled = true,
 *                     KeyEncryptionKey = new AzureNative.Compute.Inputs.KeyVaultKeyReferenceArgs
 *                     {
 *                         KeyUrl = "aaaaaaaaaaaaaa",
 *                         SourceVault = new AzureNative.Compute.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                         },
 *                     },
 *                 },
 *                 Image = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                 {
 *                     Uri = "https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd",
 *                 },
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                     {
 *                         Id = "aaaaaaaaaaaa",
 *                     },
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vmss3176_vmss3176_0_OsDisk_1_6d72b805e50e4de6830303c5055077fc",
 *                     StorageAccountType = "Standard_LRS",
 *                 },
 *                 Name = "vmss3176_vmss3176_0_OsDisk_1_6d72b805e50e4de6830303c5055077fc",
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *                 Vhd = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                 {
 *                     Uri = "https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd",
 *                 },
 *                 WriteAcceleratorEnabled = true,
 *             },
 *         },
 *         Tags = null,
 *         UserData = "RXhhbXBsZSBVc2VyRGF0YQ==",
 *         VmScaleSetName = "aaaaaaaaaaaaaa",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewVirtualMachineScaleSetVM(ctx, "virtualMachineScaleSetVM", &compute.VirtualMachineScaleSetVMArgs{
 * AdditionalCapabilities: &compute.AdditionalCapabilitiesArgs{
 * HibernationEnabled: pulumi.Bool(true),
 * UltraSSDEnabled: pulumi.Bool(true),
 * },
 * AvailabilitySet: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * DiagnosticsProfile: compute.DiagnosticsProfileResponse{
 * BootDiagnostics: &compute.BootDiagnosticsArgs{
 * Enabled: pulumi.Bool(true),
 * StorageUri: pulumi.String("aaaaaaaaaaaaa"),
 * },
 * },
 * HardwareProfile: compute.HardwareProfileResponse{
 * VmSize: pulumi.String("Basic_A0"),
 * VmSizeProperties: &compute.VMSizePropertiesArgs{
 * VCPUsAvailable: pulumi.Int(9),
 * VCPUsPerCore: pulumi.Int(12),
 * },
 * },
 * InstanceId: pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
 * LicenseType: pulumi.String("aaaaaaaaaa"),
 * Location: pulumi.String("westus"),
 * NetworkProfile: compute.NetworkProfileResponse{
 * NetworkApiVersion: pulumi.String("2020-11-01"),
 * NetworkInterfaceConfigurations: compute.VirtualMachineNetworkInterfaceConfigurationArray{
 * interface{}{
 * DeleteOption: pulumi.String("Delete"),
 * DnsSettings: &compute.VirtualMachineNetworkInterfaceDnsSettingsConfigurationArgs{
 * DnsServers: pulumi.StringArray{
 * pulumi.String("aaaaaa"),
 * },
 * },
 * DscpConfiguration: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * EnableAcceleratedNetworking: pulumi.Bool(true),
 * EnableFpga: pulumi.Bool(true),
 * EnableIPForwarding: pulumi.Bool(true),
 * IpConfigurations: compute.VirtualMachineNetworkInterfaceIPConfigurationArray{
 * interface{}{
 * ApplicationGatewayBackendAddressPools: compute.SubResourceArray{
 * &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * ApplicationSecurityGroups: compute.SubResourceArray{
 * &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * LoadBalancerBackendAddressPools: compute.SubResourceArray{
 * &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * Name: pulumi.String("aa"),
 * Primary: pulumi.Bool(true),
 * PrivateIPAddressVersion: pulumi.String("IPv4"),
 * PublicIPAddressConfiguration: interface{}{
 * DeleteOption: pulumi.String("Delete"),
 * DnsSettings: &compute.VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs{
 * DomainNameLabel: pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaa"),
 * },
 * IdleTimeoutInMinutes: pulumi.Int(2),
 * IpTags: compute.VirtualMachineIpTagArray{
 * &compute.VirtualMachineIpTagArgs{
 * IpTagType: pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaa"),
 * Tag: pulumi.String("aaaaaaaaaaaaaaaaaaaa"),
 * },
 * },
 * Name: pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
 * PublicIPAddressVersion: pulumi.String("IPv4"),
 * PublicIPAllocationMethod: pulumi.String("Dynamic"),
 * PublicIPPrefix: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * Sku: &compute.PublicIPAddressSkuArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Regional"),
 * },
 * },
 * Subnet: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * },
 * Name: pulumi.String("aaaaaaaaaaa"),
 * NetworkSecurityGroup: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * Primary: pulumi.Bool(true),
 * },
 * },
 * NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * &compute.NetworkInterfaceReferenceArgs{
 * DeleteOption: pulumi.String("Delete"),
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachineScaleSets/{vmss-name}/virtualMachines/0/networkInterfaces/vmsstestnetconfig5415"),
 * Primary: pulumi.Bool(true),
 * },
 * },
 * },
 * NetworkProfileConfiguration: compute.VirtualMachineScaleSetVMNetworkProfileConfigurationResponse{
 * NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * interface{}{
 * DeleteOption: pulumi.String("Delete"),
 * DnsSettings: &compute.VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs{
 * DnsServers: pulumi.StringArray{
 * },
 * },
 * EnableAcceleratedNetworking: pulumi.Bool(true),
 * EnableFpga: pulumi.Bool(true),
 * EnableIPForwarding: pulumi.Bool(true),
 * IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * interface{}{
 * ApplicationGatewayBackendAddressPools: compute.SubResourceArray{
 * &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * ApplicationSecurityGroups: compute.SubResourceArray{
 * &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * LoadBalancerBackendAddressPools: compute.SubResourceArray{
 * &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * LoadBalancerInboundNatPools: compute.SubResourceArray{
 * &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * Name: pulumi.String("vmsstestnetconfig9693"),
 * Primary: pulumi.Bool(true),
 * PrivateIPAddressVersion: pulumi.String("IPv4"),
 * PublicIPAddressConfiguration: interface{}{
 * DeleteOption: pulumi.String("Delete"),
 * DnsSettings: &compute.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs{
 * DomainNameLabel: pulumi.String("aaaaaaaaaaaaaaaaaa"),
 * },
 * IdleTimeoutInMinutes: pulumi.Int(18),
 * IpTags: compute.VirtualMachineScaleSetIpTagArray{
 * &compute.VirtualMachineScaleSetIpTagArgs{
 * IpTagType: pulumi.String("aaaaaaa"),
 * Tag: pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaaaa"),
 * },
 * },
 * Name: pulumi.String("aaaaaaaaaaaaaaaaaa"),
 * PublicIPAddressVersion: pulumi.String("IPv4"),
 * PublicIPPrefix: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * Sku: &compute.PublicIPAddressSkuArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Regional"),
 * },
 * },
 * Subnet: &compute.ApiEntityReferenceArgs{
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/vn4071/subnets/sn5503"),
 * },
 * },
 * },
 * Name: pulumi.String("vmsstestnetconfig5415"),
 * NetworkSecurityGroup: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * Primary: pulumi.Bool(true),
 * },
 * },
 * },
 * OsProfile: compute.OSProfileResponse{
 * AdminPassword: pulumi.String("aaaaaaaaaaaaaaaa"),
 * AdminUsername: pulumi.String("Foo12"),
 * AllowExtensionOperations: pulumi.Bool(true),
 * ComputerName: pulumi.String("test000000"),
 * CustomData: pulumi.String("aaaa"),
 * LinuxConfiguration: interface{}{
 * DisablePasswordAuthentication: pulumi.Bool(true),
 * PatchSettings: &compute.LinuxPatchSettingsArgs{
 * AssessmentMode: pulumi.String("ImageDefault"),
 * PatchMode: pulumi.String("ImageDefault"),
 * },
 * ProvisionVMAgent: pulumi.Bool(true),
 * Ssh: interface{}{
 * PublicKeys: compute.SshPublicKeyTypeArray{
 * &compute.SshPublicKeyTypeArgs{
 * KeyData: pulumi.String("aaaaaa"),
 * Path: pulumi.String("aaa"),
 * },
 * },
 * },
 * },
 * RequireGuestProvisionSignal: pulumi.Bool(true),
 * Secrets: compute.VaultSecretGroupArray{
 * },
 * WindowsConfiguration: interface{}{
 * AdditionalUnattendContent: compute.AdditionalUnattendContentArray{
 * &compute.AdditionalUnattendContentArgs{
 * ComponentName: compute.ComponentNames_Microsoft_Windows_Shell_Setup,
 * Content: pulumi.String("aaaaaaaaaaaaaaaaaaaa"),
 * PassName: compute.PassNamesOobeSystem,
 * SettingName: compute.SettingNamesAutoLogon,
 * },
 * },
 * EnableAutomaticUpdates: pulumi.Bool(true),
 * PatchSettings: &compute.PatchSettingsArgs{
 * AssessmentMode: pulumi.String("ImageDefault"),
 * EnableHotpatching: pulumi.Bool(true),
 * PatchMode: pulumi.String("Manual"),
 * },
 * ProvisionVMAgent: pulumi.Bool(true),
 * TimeZone: pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaaaa"),
 * WinRM: interface{}{
 * Listeners: compute.WinRMListenerArray{
 * &compute.WinRMListenerArgs{
 * CertificateUrl: pulumi.String("aaaaaaaaaaaaaaaaaaaaaa"),
 * Protocol: compute.ProtocolTypesHttp,
 * },
 * },
 * },
 * },
 * },
 * Plan: &compute.PlanArgs{
 * Name: pulumi.String("aaaaaaaaaa"),
 * Product: pulumi.String("aaaaaaaaaaaaaaaaaaaa"),
 * PromotionCode: pulumi.String("aaaaaaaaaaaaaaaaaaaa"),
 * Publisher: pulumi.String("aaaaaaaaaaaaaaaaaaaaaa"),
 * },
 * ProtectionPolicy: &compute.VirtualMachineScaleSetVMProtectionPolicyArgs{
 * ProtectFromScaleIn: pulumi.Bool(true),
 * ProtectFromScaleSetActions: pulumi.Bool(true),
 * },
 * ResourceGroupName: pulumi.String("rgcompute"),
 * SecurityProfile: compute.SecurityProfileResponse{
 * EncryptionAtHost: pulumi.Bool(true),
 * SecurityType: pulumi.String("TrustedLaunch"),
 * UefiSettings: &compute.UefiSettingsArgs{
 * SecureBootEnabled: pulumi.Bool(true),
 * VTpmEnabled: pulumi.Bool(true),
 * },
 * },
 * StorageProfile: compute.StorageProfileResponse{
 * DataDisks: compute.DataDiskArray{
 * interface{}{
 * Caching: compute.CachingTypesNone,
 * CreateOption: pulumi.String("Empty"),
 * DeleteOption: pulumi.String("Delete"),
 * DetachOption: pulumi.String("ForceDetach"),
 * DiskSizeGB: pulumi.Int(128),
 * Image: &compute.VirtualHardDiskArgs{
 * Uri: pulumi.String("https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd"),
 * },
 * Lun: pulumi.Int(1),
 * ManagedDisk: interface{}{
 * DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * Id: pulumi.String("aaaaaaaaaaaa"),
 * },
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vmss3176_vmss3176_0_disk2_6c4f554bdafa49baa780eb2d128ff39d"),
 * StorageAccountType: pulumi.String("Standard_LRS"),
 * },
 * Name: pulumi.String("vmss3176_vmss3176_0_disk2_6c4f554bdafa49baa780eb2d128ff39d"),
 * ToBeDetached: pulumi.Bool(true),
 * Vhd: &compute.VirtualHardDiskArgs{
 * Uri: pulumi.String("https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd"),
 * },
 * WriteAcceleratorEnabled: pulumi.Bool(true),
 * },
 * },
 * ImageReference: &compute.ImageReferenceArgs{
 * Id: pulumi.String("a"),
 * Offer: pulumi.String("WindowsServer"),
 * Publisher: pulumi.String("MicrosoftWindowsServer"),
 * SharedGalleryImageId: pulumi.String("aaaaaaaaaaaaaaaaaaaa"),
 * Sku: pulumi.String("2012-R2-Datacenter"),
 * Version: pulumi.String("4.127.20180315"),
 * },
 * OsDisk: interface{}{
 * Caching: compute.CachingTypesNone,
 * CreateOption: pulumi.String("FromImage"),
 * DeleteOption: pulumi.String("Delete"),
 * DiffDiskSettings: &compute.DiffDiskSettingsArgs{
 * Option: pulumi.String("Local"),
 * Placement: pulumi.String("CacheDisk"),
 * },
 * DiskSizeGB: pulumi.Int(127),
 * EncryptionSettings: interface{}{
 * DiskEncryptionKey: interface{}{
 * SecretUrl: pulumi.String("aaaaaaaa"),
 * SourceVault: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * Enabled: pulumi.Bool(true),
 * KeyEncryptionKey: interface{}{
 * KeyUrl: pulumi.String("aaaaaaaaaaaaaa"),
 * SourceVault: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * },
 * Image: &compute.VirtualHardDiskArgs{
 * Uri: pulumi.String("https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd"),
 * },
 * ManagedDisk: interface{}{
 * DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * Id: pulumi.String("aaaaaaaaaaaa"),
 * },
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vmss3176_vmss3176_0_OsDisk_1_6d72b805e50e4de6830303c5055077fc"),
 * StorageAccountType: pulumi.String("Standard_LRS"),
 * },
 * Name: pulumi.String("vmss3176_vmss3176_0_OsDisk_1_6d72b805e50e4de6830303c5055077fc"),
 * OsType: compute.OperatingSystemTypesWindows,
 * Vhd: &compute.VirtualHardDiskArgs{
 * Uri: pulumi.String("https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd"),
 * },
 * WriteAcceleratorEnabled: pulumi.Bool(true),
 * },
 * },
 * Tags: nil,
 * UserData: pulumi.String("RXhhbXBsZSBVc2VyRGF0YQ=="),
 * VmScaleSetName: pulumi.String("aaaaaaaaaaaaaa"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetVM;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetVMArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSetVM = new VirtualMachineScaleSetVM("virtualMachineScaleSetVM", VirtualMachineScaleSetVMArgs.builder()
 *             .additionalCapabilities(Map.ofEntries(
 *                 Map.entry("hibernationEnabled", true),
 *                 Map.entry("ultraSSDEnabled", true)
 *             ))
 *             .availabilitySet(Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"))
 *             .diagnosticsProfile(Map.of("bootDiagnostics", Map.ofEntries(
 *                 Map.entry("enabled", true),
 *                 Map.entry("storageUri", "aaaaaaaaaaaaa")
 *             )))
 *             .hardwareProfile(Map.ofEntries(
 *                 Map.entry("vmSize", "Basic_A0"),
 *                 Map.entry("vmSizeProperties", Map.ofEntries(
 *                     Map.entry("vCPUsAvailable", 9),
 *                     Map.entry("vCPUsPerCore", 12)
 *                 ))
 *             ))
 *             .instanceId("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa")
 *             .licenseType("aaaaaaaaaa")
 *             .location("westus")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("networkApiVersion", "2020-11-01"),
 *                 Map.entry("networkInterfaceConfigurations", Map.ofEntries(
 *                     Map.entry("deleteOption", "Delete"),
 *                     Map.entry("dnsSettings", Map.of("dnsServers", "aaaaaa")),
 *                     Map.entry("dscpConfiguration", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                     Map.entry("enableAcceleratedNetworking", true),
 *                     Map.entry("enableFpga", true),
 *                     Map.entry("enableIPForwarding", true),
 *                     Map.entry("ipConfigurations", Map.ofEntries(
 *                         Map.entry("applicationGatewayBackendAddressPools", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                         Map.entry("applicationSecurityGroups", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                         Map.entry("loadBalancerBackendAddressPools", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                         Map.entry("name", "aa"),
 *                         Map.entry("primary", true),
 *                         Map.entry("privateIPAddressVersion", "IPv4"),
 *                         Map.entry("publicIPAddressConfiguration", Map.ofEntries(
 *                             Map.entry("deleteOption", "Delete"),
 *                             Map.entry("dnsSettings", Map.of("domainNameLabel", "aaaaaaaaaaaaaaaaaaaaaaaaa")),
 *                             Map.entry("idleTimeoutInMinutes", 2),
 *                             Map.entry("ipTags", Map.ofEntries(
 *                                 Map.entry("ipTagType", "aaaaaaaaaaaaaaaaaaaaaaaaa"),
 *                                 Map.entry("tag", "aaaaaaaaaaaaaaaaaaaa")
 *                             )),
 *                             Map.entry("name", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
 *                             Map.entry("publicIPAddressVersion", "IPv4"),
 *                             Map.entry("publicIPAllocationMethod", "Dynamic"),
 *                             Map.entry("publicIPPrefix", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                             Map.entry("sku", Map.ofEntries(
 *                                 Map.entry("name", "Basic"),
 *                                 Map.entry("tier", "Regional")
 *                             ))
 *                         )),
 *                         Map.entry("subnet", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"))
 *                     )),
 *                     Map.entry("name", "aaaaaaaaaaa"),
 *                     Map.entry("networkSecurityGroup", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                     Map.entry("primary", true)
 *                 )),
 *                 Map.entry("networkInterfaces", Map.ofEntries(
 *                     Map.entry("deleteOption", "Delete"),
 *                     Map.entry("id", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachineScaleSets/{vmss-name}/virtualMachines/0/networkInterfaces/vmsstestnetconfig5415"),
 *                     Map.entry("primary", true)
 *                 ))
 *             ))
 *             .networkProfileConfiguration(Map.of("networkInterfaceConfigurations", Map.ofEntries(
 *                 Map.entry("deleteOption", "Delete"),
 *                 Map.entry("dnsSettings", Map.of("dnsServers", )),
 *                 Map.entry("enableAcceleratedNetworking", true),
 *                 Map.entry("enableFpga", true),
 *                 Map.entry("enableIPForwarding", true),
 *                 Map.entry("ipConfigurations", Map.ofEntries(
 *                     Map.entry("applicationGatewayBackendAddressPools", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                     Map.entry("applicationSecurityGroups", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                     Map.entry("loadBalancerBackendAddressPools", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                     Map.entry("loadBalancerInboundNatPools", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                     Map.entry("name", "vmsstestnetconfig9693"),
 *                     Map.entry("primary", true),
 *                     Map.entry("privateIPAddressVersion", "IPv4"),
 *                     Map.entry("publicIPAddressConfiguration", Map.ofEntries(
 *                         Map.entry("deleteOption", "Delete"),
 *                         Map.entry("dnsSettings", Map.of("domainNameLabel", "aaaaaaaaaaaaaaaaaa")),
 *                         Map.entry("idleTimeoutInMinutes", 18),
 *                         Map.entry("ipTags", Map.ofEntries(
 *                             Map.entry("ipTagType", "aaaaaaa"),
 *                             Map.entry("tag", "aaaaaaaaaaaaaaaaaaaaaaaaaaa")
 *                         )),
 *                         Map.entry("name", "aaaaaaaaaaaaaaaaaa"),
 *                         Map.entry("publicIPAddressVersion", "IPv4"),
 *                         Map.entry("publicIPPrefix", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                         Map.entry("sku", Map.ofEntries(
 *                             Map.entry("name", "Basic"),
 *                             Map.entry("tier", "Regional")
 *                         ))
 *                     )),
 *                     Map.entry("subnet", Map.of("id", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/vn4071/subnets/sn5503"))
 *                 )),
 *                 Map.entry("name", "vmsstestnetconfig5415"),
 *                 Map.entry("networkSecurityGroup", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                 Map.entry("primary", true)
 *             )))
 *             .osProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "aaaaaaaaaaaaaaaa"),
 *                 Map.entry("adminUsername", "Foo12"),
 *                 Map.entry("allowExtensionOperations", true),
 *                 Map.entry("computerName", "test000000"),
 *                 Map.entry("customData", "aaaa"),
 *                 Map.entry("linuxConfiguration", Map.ofEntries(
 *                     Map.entry("disablePasswordAuthentication", true),
 *                     Map.entry("patchSettings", Map.ofEntries(
 *                         Map.entry("assessmentMode", "ImageDefault"),
 *                         Map.entry("patchMode", "ImageDefault")
 *                     )),
 *                     Map.entry("provisionVMAgent", true),
 *                     Map.entry("ssh", Map.of("publicKeys", Map.ofEntries(
 *                         Map.entry("keyData", "aaaaaa"),
 *                         Map.entry("path", "aaa")
 *                     )))
 *                 )),
 *                 Map.entry("requireGuestProvisionSignal", true),
 *                 Map.entry("secrets", ),
 *                 Map.entry("windowsConfiguration", Map.ofEntries(
 *                     Map.entry("additionalUnattendContent", Map.ofEntries(
 *                         Map.entry("componentName", "Microsoft-Windows-Shell-Setup"),
 *                         Map.entry("content", "aaaaaaaaaaaaaaaaaaaa"),
 *                         Map.entry("passName", "OobeSystem"),
 *                         Map.entry("settingName", "AutoLogon")
 *                     )),
 *                     Map.entry("enableAutomaticUpdates", true),
 *                     Map.entry("patchSettings", Map.ofEntries(
 *                         Map.entry("assessmentMode", "ImageDefault"),
 *                         Map.entry("enableHotpatching", true),
 *                         Map.entry("patchMode", "Manual")
 *                     )),
 *                     Map.entry("provisionVMAgent", true),
 *                     Map.entry("timeZone", "aaaaaaaaaaaaaaaaaaaaaaaaaaa"),
 *                     Map.entry("winRM", Map.of("listeners", Map.ofEntries(
 *                         Map.entry("certificateUrl", "aaaaaaaaaaaaaaaaaaaaaa"),
 *                         Map.entry("protocol", "Http")
 *                     )))
 *                 ))
 *             ))
 *             .plan(Map.ofEntries(
 *                 Map.entry("name", "aaaaaaaaaa"),
 *                 Map.entry("product", "aaaaaaaaaaaaaaaaaaaa"),
 *                 Map.entry("promotionCode", "aaaaaaaaaaaaaaaaaaaa"),
 *                 Map.entry("publisher", "aaaaaaaaaaaaaaaaaaaaaa")
 *             ))
 *             .protectionPolicy(Map.ofEntries(
 *                 Map.entry("protectFromScaleIn", true),
 *                 Map.entry("protectFromScaleSetActions", true)
 *             ))
 *             .resourceGroupName("rgcompute")
 *             .securityProfile(Map.ofEntries(
 *                 Map.entry("encryptionAtHost", true),
 *                 Map.entry("securityType", "TrustedLaunch"),
 *                 Map.entry("uefiSettings", Map.ofEntries(
 *                     Map.entry("secureBootEnabled", true),
 *                     Map.entry("vTpmEnabled", true)
 *                 ))
 *             ))
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("dataDisks", Map.ofEntries(
 *                     Map.entry("caching", "None"),
 *                     Map.entry("createOption", "Empty"),
 *                     Map.entry("deleteOption", "Delete"),
 *                     Map.entry("detachOption", "ForceDetach"),
 *                     Map.entry("diskSizeGB", 128),
 *                     Map.entry("image", Map.of("uri", "https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd")),
 *                     Map.entry("lun", 1),
 *                     Map.entry("managedDisk", Map.ofEntries(
 *                         Map.entry("diskEncryptionSet", Map.of("id", "aaaaaaaaaaaa")),
 *                         Map.entry("id", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vmss3176_vmss3176_0_disk2_6c4f554bdafa49baa780eb2d128ff39d"),
 *                         Map.entry("storageAccountType", "Standard_LRS")
 *                     )),
 *                     Map.entry("name", "vmss3176_vmss3176_0_disk2_6c4f554bdafa49baa780eb2d128ff39d"),
 *                     Map.entry("toBeDetached", true),
 *                     Map.entry("vhd", Map.of("uri", "https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd")),
 *                     Map.entry("writeAcceleratorEnabled", true)
 *                 )),
 *                 Map.entry("imageReference", Map.ofEntries(
 *                     Map.entry("id", "a"),
 *                     Map.entry("offer", "WindowsServer"),
 *                     Map.entry("publisher", "MicrosoftWindowsServer"),
 *                     Map.entry("sharedGalleryImageId", "aaaaaaaaaaaaaaaaaaaa"),
 *                     Map.entry("sku", "2012-R2-Datacenter"),
 *                     Map.entry("version", "4.127.20180315")
 *                 )),
 *                 Map.entry("osDisk", Map.ofEntries(
 *                     Map.entry("caching", "None"),
 *                     Map.entry("createOption", "FromImage"),
 *                     Map.entry("deleteOption", "Delete"),
 *                     Map.entry("diffDiskSettings", Map.ofEntries(
 *                         Map.entry("option", "Local"),
 *                         Map.entry("placement", "CacheDisk")
 *                     )),
 *                     Map.entry("diskSizeGB", 127),
 *                     Map.entry("encryptionSettings", Map.ofEntries(
 *                         Map.entry("diskEncryptionKey", Map.ofEntries(
 *                             Map.entry("secretUrl", "aaaaaaaa"),
 *                             Map.entry("sourceVault", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"))
 *                         )),
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyEncryptionKey", Map.ofEntries(
 *                             Map.entry("keyUrl", "aaaaaaaaaaaaaa"),
 *                             Map.entry("sourceVault", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"))
 *                         ))
 *                     )),
 *                     Map.entry("image", Map.of("uri", "https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd")),
 *                     Map.entry("managedDisk", Map.ofEntries(
 *                         Map.entry("diskEncryptionSet", Map.of("id", "aaaaaaaaaaaa")),
 *                         Map.entry("id", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vmss3176_vmss3176_0_OsDisk_1_6d72b805e50e4de6830303c5055077fc"),
 *                         Map.entry("storageAccountType", "Standard_LRS")
 *                     )),
 *                     Map.entry("name", "vmss3176_vmss3176_0_OsDisk_1_6d72b805e50e4de6830303c5055077fc"),
 *                     Map.entry("osType", "Windows"),
 *                     Map.entry("vhd", Map.of("uri", "https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd")),
 *                     Map.entry("writeAcceleratorEnabled", true)
 *                 ))
 *             ))
 *             .tags()
 *             .userData("RXhhbXBsZSBVc2VyRGF0YQ==")
 *             .vmScaleSetName("aaaaaaaaaaaaaa")
 *             .build());
 *     }
 * }
 * ```
 * ### VirtualMachineScaleSetVM_Update_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSetVM = new AzureNative.Compute.VirtualMachineScaleSetVM("virtualMachineScaleSetVM", new()
 *     {
 *         InstanceId = "aaaaaaaaaaaaaaaaaaaa",
 *         Location = "westus",
 *         ResourceGroupName = "rgcompute",
 *         VmScaleSetName = "aaaaaaaaaaaaaaaaaa",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSetVM(ctx, "virtualMachineScaleSetVM", &compute.VirtualMachineScaleSetVMArgs{
 * 			InstanceId:        pulumi.String("aaaaaaaaaaaaaaaaaaaa"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rgcompute"),
 * 			VmScaleSetName:    pulumi.String("aaaaaaaaaaaaaaaaaa"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetVM;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetVMArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSetVM = new VirtualMachineScaleSetVM("virtualMachineScaleSetVM", VirtualMachineScaleSetVMArgs.builder()
 *             .instanceId("aaaaaaaaaaaaaaaaaaaa")
 *             .location("westus")
 *             .resourceGroupName("rgcompute")
 *             .vmScaleSetName("aaaaaaaaaaaaaaaaaa")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:VirtualMachineScaleSetVM {vmss-vm-name} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}
 * ```
 */
public class VirtualMachineScaleSetVM internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.VirtualMachineScaleSetVM,
) : KotlinCustomResource(javaResource, VirtualMachineScaleSetVMMapper) {
    /**
     * Specifies additional capabilities enabled or disabled on the virtual machine in the scale set. For instance: whether the virtual machine has the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
     */
    public val additionalCapabilities: Output<AdditionalCapabilitiesResponse>?
        get() = javaResource.additionalCapabilities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> additionalCapabilitiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to availability set at creation time. An existing VM cannot be added to an availability set.
     */
    public val availabilitySet: Output<SubResourceResponse>?
        get() = javaResource.availabilitySet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
     */
    public val diagnosticsProfile: Output<DiagnosticsProfileResponse>?
        get() = javaResource.diagnosticsProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> diagnosticsProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the hardware settings for the virtual machine.
     */
    public val hardwareProfile: Output<HardwareProfileResponse>?
        get() = javaResource.hardwareProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> hardwareProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The identity of the virtual machine, if configured.
     */
    public val identity: Output<VirtualMachineIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachineIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The virtual machine instance ID.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The virtual machine instance view.
     */
    public val instanceView: Output<VirtualMachineScaleSetVMInstanceViewResponse>
        get() = javaResource.instanceView().applyValue({ args0 ->
            args0.let({ args0 ->
                virtualMachineScaleSetVMInstanceViewResponseToKotlin(args0)
            })
        })

    /**
     * Specifies whether the latest model has been applied to the virtual machine.
     */
    public val latestModelApplied: Output<Boolean>
        get() = javaResource.latestModelApplied().applyValue({ args0 -> args0 })

    /**
     * Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs&#46;microsoft&#46;com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
     */
    public val licenseType: Output<String>?
        get() = javaResource.licenseType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the model applied to the virtual machine is the model of the virtual machine scale set or the customized model for the virtual machine.
     */
    public val modelDefinitionApplied: Output<String>
        get() = javaResource.modelDefinitionApplied().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the network interfaces of the virtual machine.
     */
    public val networkProfile: Output<NetworkProfileResponse>?
        get() = javaResource.networkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the network profile configuration of the virtual machine.
     */
    public val networkProfileConfiguration:
        Output<VirtualMachineScaleSetVMNetworkProfileConfigurationResponse>?
        get() = javaResource.networkProfileConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachineScaleSetVMNetworkProfileConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the operating system settings for the virtual machine.
     */
    public val osProfile: Output<OSProfileResponse>?
        get() = javaResource.osProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    oSProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
     */
    public val plan: Output<PlanResponse>?
        get() = javaResource.plan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    planResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the protection policy of the virtual machine.
     */
    public val protectionPolicy: Output<VirtualMachineScaleSetVMProtectionPolicyResponse>?
        get() = javaResource.protectionPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachineScaleSetVMProtectionPolicyResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The virtual machine child extension resources.
     */
    public val resources: Output<List<VirtualMachineExtensionResponse>>
        get() = javaResource.resources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachineExtensionResponseToKotlin(args0)
                })
            })
        })

    /**
     * Specifies the Security related profile settings for the virtual machine.
     */
    public val securityProfile: Output<SecurityProfileResponse>?
        get() = javaResource.securityProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> securityProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The virtual machine SKU.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * Specifies the storage settings for the virtual machine disks.
     */
    public val storageProfile: Output<StorageProfileResponse>?
        get() = javaResource.storageProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> storageProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here. <br><br>Minimum api-version: 2021-03-01
     */
    public val userData: Output<String>?
        get() = javaResource.userData().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure VM unique ID.
     */
    public val vmId: Output<String>
        get() = javaResource.vmId().applyValue({ args0 -> args0 })

    /**
     * The virtual machine zones.
     */
    public val zones: Output<List<String>>
        get() = javaResource.zones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object VirtualMachineScaleSetVMMapper : ResourceMapper<VirtualMachineScaleSetVM> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.VirtualMachineScaleSetVM::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachineScaleSetVM =
        VirtualMachineScaleSetVM(
            javaResource as
                com.pulumi.azurenative.compute.VirtualMachineScaleSetVM,
        )
}

/**
 * @see [VirtualMachineScaleSetVM].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachineScaleSetVM].
 */
public suspend fun virtualMachineScaleSetVM(
    name: String,
    block: suspend VirtualMachineScaleSetVMResourceBuilder.() -> Unit,
): VirtualMachineScaleSetVM {
    val builder = VirtualMachineScaleSetVMResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachineScaleSetVM].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachineScaleSetVM(name: String): VirtualMachineScaleSetVM {
    val builder = VirtualMachineScaleSetVMResourceBuilder()
    builder.name(name)
    return builder.build()
}
