@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.VirtualMachineScaleSetVMExtensionArgs.builder
import com.pulumi.azurenative.compute.kotlin.inputs.KeyVaultSecretReferenceArgs
import com.pulumi.azurenative.compute.kotlin.inputs.KeyVaultSecretReferenceArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineExtensionInstanceViewArgs
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineExtensionInstanceViewArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a VMSS VM Extension.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2019-12-01, 2021-11-01, 2023-07-01, 2023-09-01.
 * ## Example Usage
 * ### Create VirtualMachineScaleSet VM extension.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSetVMExtension = new AzureNative.Compute.VirtualMachineScaleSetVMExtension("virtualMachineScaleSetVMExtension", new()
 *     {
 *         AutoUpgradeMinorVersion = true,
 *         InstanceId = "0",
 *         Publisher = "extPublisher",
 *         ResourceGroupName = "myResourceGroup",
 *         Settings =
 *         {
 *             { "UserName", "xyz@microsoft.com" },
 *         },
 *         Type = "extType",
 *         TypeHandlerVersion = "1.2",
 *         VmExtensionName = "myVMExtension",
 *         VmScaleSetName = "myvmScaleSet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSetVMExtension(ctx, "virtualMachineScaleSetVMExtension", &compute.VirtualMachineScaleSetVMExtensionArgs{
 * 			AutoUpgradeMinorVersion: pulumi.Bool(true),
 * 			InstanceId:              pulumi.String("0"),
 * 			Publisher:               pulumi.String("extPublisher"),
 * 			ResourceGroupName:       pulumi.String("myResourceGroup"),
 * 			Settings: pulumi.Any{
 * 				UserName: "xyz@microsoft.com",
 * 			},
 * 			Type:               pulumi.String("extType"),
 * 			TypeHandlerVersion: pulumi.String("1.2"),
 * 			VmExtensionName:    pulumi.String("myVMExtension"),
 * 			VmScaleSetName:     pulumi.String("myvmScaleSet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetVMExtension;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetVMExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSetVMExtension = new VirtualMachineScaleSetVMExtension("virtualMachineScaleSetVMExtension", VirtualMachineScaleSetVMExtensionArgs.builder()
 *             .autoUpgradeMinorVersion(true)
 *             .instanceId("0")
 *             .publisher("extPublisher")
 *             .resourceGroupName("myResourceGroup")
 *             .settings(Map.of("UserName", "xyz@microsoft.com"))
 *             .type("extType")
 *             .typeHandlerVersion("1.2")
 *             .vmExtensionName("myVMExtension")
 *             .vmScaleSetName("myvmScaleSet")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:VirtualMachineScaleSetVMExtension myVMExtension /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/extensions/{vmExtensionName}
 * ```
 * @property autoUpgradeMinorVersion Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
 * @property enableAutomaticUpgrade Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
 * @property forceUpdateTag How the extension handler should be forced to update even if the extension configuration has not changed.
 * @property instanceId The instance ID of the virtual machine.
 * @property instanceView The virtual machine extension instance view.
 * @property location The location of the extension.
 * @property protectedSettings The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
 * @property protectedSettingsFromKeyVault The extensions protected settings that are passed by reference, and consumed from key vault
 * @property provisionAfterExtensions Collection of extension names after which this extension needs to be provisioned.
 * @property publisher The name of the extension handler publisher.
 * @property resourceGroupName The name of the resource group.
 * @property settings Json formatted public settings for the extension.
 * @property suppressFailures Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
 * @property type Specifies the type of the extension; an example is "CustomScriptExtension".
 * @property typeHandlerVersion Specifies the version of the script handler.
 * @property vmExtensionName The name of the virtual machine extension.
 * @property vmScaleSetName The name of the VM scale set.
 */
public data class VirtualMachineScaleSetVMExtensionArgs(
    public val autoUpgradeMinorVersion: Output<Boolean>? = null,
    public val enableAutomaticUpgrade: Output<Boolean>? = null,
    public val forceUpdateTag: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val instanceView: Output<VirtualMachineExtensionInstanceViewArgs>? = null,
    public val location: Output<String>? = null,
    public val protectedSettings: Output<Any>? = null,
    public val protectedSettingsFromKeyVault: Output<KeyVaultSecretReferenceArgs>? = null,
    public val provisionAfterExtensions: Output<List<String>>? = null,
    public val publisher: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val settings: Output<Any>? = null,
    public val suppressFailures: Output<Boolean>? = null,
    public val type: Output<String>? = null,
    public val typeHandlerVersion: Output<String>? = null,
    public val vmExtensionName: Output<String>? = null,
    public val vmScaleSetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.VirtualMachineScaleSetVMExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.VirtualMachineScaleSetVMExtensionArgs =
        com.pulumi.azurenative.compute.VirtualMachineScaleSetVMExtensionArgs.builder()
            .autoUpgradeMinorVersion(autoUpgradeMinorVersion?.applyValue({ args0 -> args0 }))
            .enableAutomaticUpgrade(enableAutomaticUpgrade?.applyValue({ args0 -> args0 }))
            .forceUpdateTag(forceUpdateTag?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .instanceView(instanceView?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .protectedSettings(protectedSettings?.applyValue({ args0 -> args0 }))
            .protectedSettingsFromKeyVault(
                protectedSettingsFromKeyVault?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisionAfterExtensions(
                provisionAfterExtensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .settings(settings?.applyValue({ args0 -> args0 }))
            .suppressFailures(suppressFailures?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .typeHandlerVersion(typeHandlerVersion?.applyValue({ args0 -> args0 }))
            .vmExtensionName(vmExtensionName?.applyValue({ args0 -> args0 }))
            .vmScaleSetName(vmScaleSetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineScaleSetVMExtensionArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetVMExtensionArgsBuilder internal constructor() {
    private var autoUpgradeMinorVersion: Output<Boolean>? = null

    private var enableAutomaticUpgrade: Output<Boolean>? = null

    private var forceUpdateTag: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var instanceView: Output<VirtualMachineExtensionInstanceViewArgs>? = null

    private var location: Output<String>? = null

    private var protectedSettings: Output<Any>? = null

    private var protectedSettingsFromKeyVault: Output<KeyVaultSecretReferenceArgs>? = null

    private var provisionAfterExtensions: Output<List<String>>? = null

    private var publisher: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var settings: Output<Any>? = null

    private var suppressFailures: Output<Boolean>? = null

    private var type: Output<String>? = null

    private var typeHandlerVersion: Output<String>? = null

    private var vmExtensionName: Output<String>? = null

    private var vmScaleSetName: Output<String>? = null

    /**
     * @param value Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    @JvmName("jiunufqefhgbvdxu")
    public suspend fun autoUpgradeMinorVersion(`value`: Output<Boolean>) {
        this.autoUpgradeMinorVersion = value
    }

    /**
     * @param value Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
     */
    @JvmName("lisekvblyjbwclcr")
    public suspend fun enableAutomaticUpgrade(`value`: Output<Boolean>) {
        this.enableAutomaticUpgrade = value
    }

    /**
     * @param value How the extension handler should be forced to update even if the extension configuration has not changed.
     */
    @JvmName("kxpolaysirhysljv")
    public suspend fun forceUpdateTag(`value`: Output<String>) {
        this.forceUpdateTag = value
    }

    /**
     * @param value The instance ID of the virtual machine.
     */
    @JvmName("uinxhirorsgryqwy")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The virtual machine extension instance view.
     */
    @JvmName("mclvaeowqcfkscwm")
    public suspend fun instanceView(`value`: Output<VirtualMachineExtensionInstanceViewArgs>) {
        this.instanceView = value
    }

    /**
     * @param value The location of the extension.
     */
    @JvmName("wsoturdmqlpbxngl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    @JvmName("cttgjqxxoogqjaex")
    public suspend fun protectedSettings(`value`: Output<Any>) {
        this.protectedSettings = value
    }

    /**
     * @param value The extensions protected settings that are passed by reference, and consumed from key vault
     */
    @JvmName("qswiyhsqjunifvcs")
    public suspend fun protectedSettingsFromKeyVault(`value`: Output<KeyVaultSecretReferenceArgs>) {
        this.protectedSettingsFromKeyVault = value
    }

    /**
     * @param value Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("wcauxesrqanlyams")
    public suspend fun provisionAfterExtensions(`value`: Output<List<String>>) {
        this.provisionAfterExtensions = value
    }

    @JvmName("gvquedgwpdavkcva")
    public suspend fun provisionAfterExtensions(vararg values: Output<String>) {
        this.provisionAfterExtensions = Output.all(values.asList())
    }

    /**
     * @param values Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("fxkmlxomawvakxov")
    public suspend fun provisionAfterExtensions(values: List<Output<String>>) {
        this.provisionAfterExtensions = Output.all(values)
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("dxnwmegiadcmbmru")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ajdbkuprtrvvitrl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Json formatted public settings for the extension.
     */
    @JvmName("bxrdptbpdwjqtkox")
    public suspend fun settings(`value`: Output<Any>) {
        this.settings = value
    }

    /**
     * @param value Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
     */
    @JvmName("nomvwwfasynmkdwc")
    public suspend fun suppressFailures(`value`: Output<Boolean>) {
        this.suppressFailures = value
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("aysuwtsgblottljc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("yedseaeismgljcuw")
    public suspend fun typeHandlerVersion(`value`: Output<String>) {
        this.typeHandlerVersion = value
    }

    /**
     * @param value The name of the virtual machine extension.
     */
    @JvmName("goqcthggiyssfigx")
    public suspend fun vmExtensionName(`value`: Output<String>) {
        this.vmExtensionName = value
    }

    /**
     * @param value The name of the VM scale set.
     */
    @JvmName("ghwlcbokupcjnohf")
    public suspend fun vmScaleSetName(`value`: Output<String>) {
        this.vmScaleSetName = value
    }

    /**
     * @param value Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    @JvmName("hcxtdxsbgcetnhge")
    public suspend fun autoUpgradeMinorVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradeMinorVersion = mapped
    }

    /**
     * @param value Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
     */
    @JvmName("xodyjjfsppyqnypd")
    public suspend fun enableAutomaticUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticUpgrade = mapped
    }

    /**
     * @param value How the extension handler should be forced to update even if the extension configuration has not changed.
     */
    @JvmName("cqgvdthuebjayjcf")
    public suspend fun forceUpdateTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdateTag = mapped
    }

    /**
     * @param value The instance ID of the virtual machine.
     */
    @JvmName("jljpwuylxwapgaxn")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The virtual machine extension instance view.
     */
    @JvmName("ctciuljgeqpedhro")
    public suspend fun instanceView(`value`: VirtualMachineExtensionInstanceViewArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceView = mapped
    }

    /**
     * @param argument The virtual machine extension instance view.
     */
    @JvmName("yelmskqvvmnaxfrq")
    public suspend
    fun instanceView(argument: suspend VirtualMachineExtensionInstanceViewArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineExtensionInstanceViewArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.instanceView = mapped
    }

    /**
     * @param value The location of the extension.
     */
    @JvmName("qsyoukpncgcjubvv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    @JvmName("iqtqykoudwwkbtge")
    public suspend fun protectedSettings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedSettings = mapped
    }

    /**
     * @param value The extensions protected settings that are passed by reference, and consumed from key vault
     */
    @JvmName("urmbtrpugmthldax")
    public suspend fun protectedSettingsFromKeyVault(`value`: KeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedSettingsFromKeyVault = mapped
    }

    /**
     * @param argument The extensions protected settings that are passed by reference, and consumed from key vault
     */
    @JvmName("odafyapckhnfnfit")
    public suspend
    fun protectedSettingsFromKeyVault(argument: suspend KeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.protectedSettingsFromKeyVault = mapped
    }

    /**
     * @param value Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("bfdmvikajftikbml")
    public suspend fun provisionAfterExtensions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionAfterExtensions = mapped
    }

    /**
     * @param values Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("nmamvecjmgwmnyls")
    public suspend fun provisionAfterExtensions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisionAfterExtensions = mapped
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("sldyrhoicxdecmpy")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("liihikxopotdlplr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Json formatted public settings for the extension.
     */
    @JvmName("wewnmougjtdpjwig")
    public suspend fun settings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param value Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
     */
    @JvmName("sgnhrulunhxhgylm")
    public suspend fun suppressFailures(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suppressFailures = mapped
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("qawwcrvomvmbjekm")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("cmfxiuckutfedqiy")
    public suspend fun typeHandlerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeHandlerVersion = mapped
    }

    /**
     * @param value The name of the virtual machine extension.
     */
    @JvmName("yvkeadgudylleqri")
    public suspend fun vmExtensionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmExtensionName = mapped
    }

    /**
     * @param value The name of the VM scale set.
     */
    @JvmName("eypsjpsuhnijhpsl")
    public suspend fun vmScaleSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmScaleSetName = mapped
    }

    internal fun build(): VirtualMachineScaleSetVMExtensionArgs =
        VirtualMachineScaleSetVMExtensionArgs(
            autoUpgradeMinorVersion = autoUpgradeMinorVersion,
            enableAutomaticUpgrade = enableAutomaticUpgrade,
            forceUpdateTag = forceUpdateTag,
            instanceId = instanceId,
            instanceView = instanceView,
            location = location,
            protectedSettings = protectedSettings,
            protectedSettingsFromKeyVault = protectedSettingsFromKeyVault,
            provisionAfterExtensions = provisionAfterExtensions,
            publisher = publisher,
            resourceGroupName = resourceGroupName,
            settings = settings,
            suppressFailures = suppressFailures,
            type = type,
            typeHandlerVersion = typeHandlerVersion,
            vmExtensionName = vmExtensionName,
            vmScaleSetName = vmScaleSetName,
        )
}
