@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates the error code if the background copy of a resource created via the CopyStart operation fails.
 */
public enum class CopyCompletionErrorReason(
    public val javaValue: com.pulumi.azurenative.compute.enums.CopyCompletionErrorReason,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.CopyCompletionErrorReason> {
    /**
     * Indicates that the source snapshot was deleted while the background copy of the resource created via CopyStart operation was in progress.
     */
    CopySourceNotFound(com.pulumi.azurenative.compute.enums.CopyCompletionErrorReason.CopySourceNotFound),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.CopyCompletionErrorReason = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.CopyCompletionErrorReason):
            CopyCompletionErrorReason =
            CopyCompletionErrorReason.values().first { it.javaValue == javaType }
    }
}
