@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The sku name.
 */
public enum class DiskStorageAccountTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.DiskStorageAccountTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.DiskStorageAccountTypes> {
    /**
     * Standard HDD locally redundant storage. Best for backup, non-critical, and infrequent access.
     */
    Standard_LRS(com.pulumi.azurenative.compute.enums.DiskStorageAccountTypes.Standard_LRS),

    /**
     * Premium SSD locally redundant storage. Best for production and performance sensitive workloads.
     */
    Premium_LRS(com.pulumi.azurenative.compute.enums.DiskStorageAccountTypes.Premium_LRS),

    /**
     * Standard SSD locally redundant storage. Best for web servers, lightly used enterprise applications and dev/test.
     */
    StandardSSD_LRS(com.pulumi.azurenative.compute.enums.DiskStorageAccountTypes.StandardSSD_LRS),

    /**
     * Ultra SSD locally redundant storage. Best for IO-intensive workloads such as SAP HANA, top tier databases (for example, SQL, Oracle), and other transaction-heavy workloads.
     */
    UltraSSD_LRS(com.pulumi.azurenative.compute.enums.DiskStorageAccountTypes.UltraSSD_LRS),

    /**
     * Premium SSD zone redundant storage. Best for the production workloads that need storage resiliency against zone failures.
     */
    Premium_ZRS(com.pulumi.azurenative.compute.enums.DiskStorageAccountTypes.Premium_ZRS),

    /**
     * Standard SSD zone redundant storage. Best for web servers, lightly used enterprise applications and dev/test that need storage resiliency against zone failures.
     */
    StandardSSD_ZRS(com.pulumi.azurenative.compute.enums.DiskStorageAccountTypes.StandardSSD_ZRS),

    /**
     * Premium SSD v2 locally redundant storage. Best for production and performance-sensitive workloads that consistently require low latency and high IOPS and throughput.
     */
    PremiumV2_LRS(com.pulumi.azurenative.compute.enums.DiskStorageAccountTypes.PremiumV2_LRS),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.DiskStorageAccountTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.DiskStorageAccountTypes):
            DiskStorageAccountTypes =
            DiskStorageAccountTypes.values().first { it.javaValue == javaType }
    }
}
