@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
 */
public enum class StorageAccountTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.StorageAccountTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.StorageAccountTypes> {
    Standard_LRS(com.pulumi.azurenative.compute.enums.StorageAccountTypes.Standard_LRS),
    Premium_LRS(com.pulumi.azurenative.compute.enums.StorageAccountTypes.Premium_LRS),
    StandardSSD_LRS(com.pulumi.azurenative.compute.enums.StorageAccountTypes.StandardSSD_LRS),
    UltraSSD_LRS(com.pulumi.azurenative.compute.enums.StorageAccountTypes.UltraSSD_LRS),
    Premium_ZRS(com.pulumi.azurenative.compute.enums.StorageAccountTypes.Premium_ZRS),
    StandardSSD_ZRS(com.pulumi.azurenative.compute.enums.StorageAccountTypes.StandardSSD_ZRS),
    PremiumV2_LRS(com.pulumi.azurenative.compute.enums.StorageAccountTypes.PremiumV2_LRS),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.StorageAccountTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.StorageAccountTypes):
            StorageAccountTypes = StorageAccountTypes.values().first { it.javaValue == javaType }
    }
}
