@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.AdditionalCapabilitiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Enables or disables a capability on the virtual machine or virtual machine scale set.
 * @property hibernationEnabled The flag that enables or disables hibernation capability on the VM.
 * @property ultraSSDEnabled The flag that enables or disables a capability to have one or more managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale set only if this property is enabled.
 */
public data class AdditionalCapabilitiesArgs(
    public val hibernationEnabled: Output<Boolean>? = null,
    public val ultraSSDEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.AdditionalCapabilitiesArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.AdditionalCapabilitiesArgs =
        com.pulumi.azurenative.compute.inputs.AdditionalCapabilitiesArgs.builder()
            .hibernationEnabled(hibernationEnabled?.applyValue({ args0 -> args0 }))
            .ultraSSDEnabled(ultraSSDEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdditionalCapabilitiesArgs].
 */
@PulumiTagMarker
public class AdditionalCapabilitiesArgsBuilder internal constructor() {
    private var hibernationEnabled: Output<Boolean>? = null

    private var ultraSSDEnabled: Output<Boolean>? = null

    /**
     * @param value The flag that enables or disables hibernation capability on the VM.
     */
    @JvmName("yvmrycegyvxcfhwp")
    public suspend fun hibernationEnabled(`value`: Output<Boolean>) {
        this.hibernationEnabled = value
    }

    /**
     * @param value The flag that enables or disables a capability to have one or more managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale set only if this property is enabled.
     */
    @JvmName("ercjuykvmhwctiox")
    public suspend fun ultraSSDEnabled(`value`: Output<Boolean>) {
        this.ultraSSDEnabled = value
    }

    /**
     * @param value The flag that enables or disables hibernation capability on the VM.
     */
    @JvmName("gjercynxstjtypdj")
    public suspend fun hibernationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hibernationEnabled = mapped
    }

    /**
     * @param value The flag that enables or disables a capability to have one or more managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale set only if this property is enabled.
     */
    @JvmName("byrbjscdwxrytfkx")
    public suspend fun ultraSSDEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ultraSSDEnabled = mapped
    }

    internal fun build(): AdditionalCapabilitiesArgs = AdditionalCapabilitiesArgs(
        hibernationEnabled = hibernationEnabled,
        ultraSSDEnabled = ultraSSDEnabled,
    )
}
