@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.ApiEntityReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The API entity reference.
 * @property id The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
 */
public data class ApiEntityReferenceArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.ApiEntityReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.ApiEntityReferenceArgs =
        com.pulumi.azurenative.compute.inputs.ApiEntityReferenceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiEntityReferenceArgs].
 */
@PulumiTagMarker
public class ApiEntityReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
     */
    @JvmName("wjrmrtsjdbfoyawa")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
     */
    @JvmName("rmoahrnqrswheujl")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ApiEntityReferenceArgs = ApiEntityReferenceArgs(
        id = id,
    )
}
