@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.AutomaticOSUpgradePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration parameters used for performing automatic OS upgrade.
 * @property disableAutomaticRollback Whether OS image rollback feature should be disabled. Default value is false.
 * @property enableAutomaticOSUpgrade Indicates whether OS upgrades should automatically be applied to scale set instances in a rolling fashion when a newer version of the OS image becomes available. Default value is false. If this is set to true for Windows based scale sets, [enableAutomaticUpdates](https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet) is automatically set to false and cannot be set to true.
 * @property useRollingUpgradePolicy Indicates whether rolling upgrade policy should be used during Auto OS Upgrade. Default value is false. Auto OS Upgrade will fallback to the default policy if no policy is defined on the VMSS.
 */
public data class AutomaticOSUpgradePolicyArgs(
    public val disableAutomaticRollback: Output<Boolean>? = null,
    public val enableAutomaticOSUpgrade: Output<Boolean>? = null,
    public val useRollingUpgradePolicy: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.AutomaticOSUpgradePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.AutomaticOSUpgradePolicyArgs =
        com.pulumi.azurenative.compute.inputs.AutomaticOSUpgradePolicyArgs.builder()
            .disableAutomaticRollback(disableAutomaticRollback?.applyValue({ args0 -> args0 }))
            .enableAutomaticOSUpgrade(enableAutomaticOSUpgrade?.applyValue({ args0 -> args0 }))
            .useRollingUpgradePolicy(useRollingUpgradePolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomaticOSUpgradePolicyArgs].
 */
@PulumiTagMarker
public class AutomaticOSUpgradePolicyArgsBuilder internal constructor() {
    private var disableAutomaticRollback: Output<Boolean>? = null

    private var enableAutomaticOSUpgrade: Output<Boolean>? = null

    private var useRollingUpgradePolicy: Output<Boolean>? = null

    /**
     * @param value Whether OS image rollback feature should be disabled. Default value is false.
     */
    @JvmName("fsgfllbcdqbhhget")
    public suspend fun disableAutomaticRollback(`value`: Output<Boolean>) {
        this.disableAutomaticRollback = value
    }

    /**
     * @param value Indicates whether OS upgrades should automatically be applied to scale set instances in a rolling fashion when a newer version of the OS image becomes available. Default value is false. If this is set to true for Windows based scale sets, [enableAutomaticUpdates](https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet) is automatically set to false and cannot be set to true.
     */
    @JvmName("uogfodrkmvwapdln")
    public suspend fun enableAutomaticOSUpgrade(`value`: Output<Boolean>) {
        this.enableAutomaticOSUpgrade = value
    }

    /**
     * @param value Indicates whether rolling upgrade policy should be used during Auto OS Upgrade. Default value is false. Auto OS Upgrade will fallback to the default policy if no policy is defined on the VMSS.
     */
    @JvmName("qsfyytwbsjsajgjq")
    public suspend fun useRollingUpgradePolicy(`value`: Output<Boolean>) {
        this.useRollingUpgradePolicy = value
    }

    /**
     * @param value Whether OS image rollback feature should be disabled. Default value is false.
     */
    @JvmName("cmyvdvytijeqrhfj")
    public suspend fun disableAutomaticRollback(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableAutomaticRollback = mapped
    }

    /**
     * @param value Indicates whether OS upgrades should automatically be applied to scale set instances in a rolling fashion when a newer version of the OS image becomes available. Default value is false. If this is set to true for Windows based scale sets, [enableAutomaticUpdates](https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet) is automatically set to false and cannot be set to true.
     */
    @JvmName("tcpsceyrpomnbtnx")
    public suspend fun enableAutomaticOSUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticOSUpgrade = mapped
    }

    /**
     * @param value Indicates whether rolling upgrade policy should be used during Auto OS Upgrade. Default value is false. Auto OS Upgrade will fallback to the default policy if no policy is defined on the VMSS.
     */
    @JvmName("jrsntvcphpsmqecl")
    public suspend fun useRollingUpgradePolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useRollingUpgradePolicy = mapped
    }

    internal fun build(): AutomaticOSUpgradePolicyArgs = AutomaticOSUpgradePolicyArgs(
        disableAutomaticRollback = disableAutomaticRollback,
        enableAutomaticOSUpgrade = enableAutomaticOSUpgrade,
        useRollingUpgradePolicy = useRollingUpgradePolicy,
    )
}
