@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.CloudServiceExtensionProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a cloud service extension profile.
 * @property extensions List of extensions for the cloud service.
 */
public data class CloudServiceExtensionProfileArgs(
    public val extensions: Output<List<ExtensionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.CloudServiceExtensionProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.CloudServiceExtensionProfileArgs =
        com.pulumi.azurenative.compute.inputs.CloudServiceExtensionProfileArgs.builder()
            .extensions(
                extensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CloudServiceExtensionProfileArgs].
 */
@PulumiTagMarker
public class CloudServiceExtensionProfileArgsBuilder internal constructor() {
    private var extensions: Output<List<ExtensionArgs>>? = null

    /**
     * @param value List of extensions for the cloud service.
     */
    @JvmName("grxsmppxugspfpjr")
    public suspend fun extensions(`value`: Output<List<ExtensionArgs>>) {
        this.extensions = value
    }

    @JvmName("pltqfarfnjwwdofp")
    public suspend fun extensions(vararg values: Output<ExtensionArgs>) {
        this.extensions = Output.all(values.asList())
    }

    /**
     * @param values List of extensions for the cloud service.
     */
    @JvmName("thaxgmdmibagogug")
    public suspend fun extensions(values: List<Output<ExtensionArgs>>) {
        this.extensions = Output.all(values)
    }

    /**
     * @param value List of extensions for the cloud service.
     */
    @JvmName("ojivcodbkouegcpx")
    public suspend fun extensions(`value`: List<ExtensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param argument List of extensions for the cloud service.
     */
    @JvmName("lvknydrtsjdglhfv")
    public suspend fun extensions(argument: List<suspend ExtensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ExtensionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument List of extensions for the cloud service.
     */
    @JvmName("vfelyjrtimkyhptn")
    public suspend fun extensions(vararg argument: suspend ExtensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ExtensionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument List of extensions for the cloud service.
     */
    @JvmName("wygxhiccdovwoqhp")
    public suspend fun extensions(argument: suspend ExtensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExtensionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param values List of extensions for the cloud service.
     */
    @JvmName("cbymiljeqpomhjuw")
    public suspend fun extensions(vararg values: ExtensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    internal fun build(): CloudServiceExtensionProfileArgs = CloudServiceExtensionProfileArgs(
        extensions = extensions,
    )
}
