@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.CloudServiceRoleSkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the cloud service role sku.
 * @property capacity Specifies the number of role instances in the cloud service.
 * @property name The sku name. NOTE: If the new SKU is not supported on the hardware the cloud service is currently on, you need to delete and recreate the cloud service or move back to the old sku.
 * @property tier Specifies the tier of the cloud service. Possible Values are <br /><br /> **Standard** <br /><br /> **Basic**
 */
public data class CloudServiceRoleSkuArgs(
    public val capacity: Output<Double>? = null,
    public val name: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.CloudServiceRoleSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.CloudServiceRoleSkuArgs =
        com.pulumi.azurenative.compute.inputs.CloudServiceRoleSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CloudServiceRoleSkuArgs].
 */
@PulumiTagMarker
public class CloudServiceRoleSkuArgsBuilder internal constructor() {
    private var capacity: Output<Double>? = null

    private var name: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value Specifies the number of role instances in the cloud service.
     */
    @JvmName("khludhpmidakokhw")
    public suspend fun capacity(`value`: Output<Double>) {
        this.capacity = value
    }

    /**
     * @param value The sku name. NOTE: If the new SKU is not supported on the hardware the cloud service is currently on, you need to delete and recreate the cloud service or move back to the old sku.
     */
    @JvmName("kckxppprendbequi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the tier of the cloud service. Possible Values are <br /><br /> **Standard** <br /><br /> **Basic**
     */
    @JvmName("dxwkvvuyharoklwr")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value Specifies the number of role instances in the cloud service.
     */
    @JvmName("phieouqiwhheffvs")
    public suspend fun capacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The sku name. NOTE: If the new SKU is not supported on the hardware the cloud service is currently on, you need to delete and recreate the cloud service or move back to the old sku.
     */
    @JvmName("tavgsehdtdkpbevf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the tier of the cloud service. Possible Values are <br /><br /> **Standard** <br /><br /> **Basic**
     */
    @JvmName("kbfbejlmhawvrxty")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): CloudServiceRoleSkuArgs = CloudServiceRoleSkuArgs(
        capacity = capacity,
        name = name,
        tier = tier,
    )
}
