@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.CommunityGalleryInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information of community gallery if current gallery is shared to community
 * @property eula End-user license agreement for community gallery image.
 * @property publicNamePrefix The prefix of the gallery name that will be displayed publicly. Visible to all users.
 * @property publisherContact Community gallery publisher support email. The email address of the publisher. Visible to all users.
 * @property publisherUri The link to the publisher website. Visible to all users.
 */
public data class CommunityGalleryInfoArgs(
    public val eula: Output<String>? = null,
    public val publicNamePrefix: Output<String>? = null,
    public val publisherContact: Output<String>? = null,
    public val publisherUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.CommunityGalleryInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.CommunityGalleryInfoArgs =
        com.pulumi.azurenative.compute.inputs.CommunityGalleryInfoArgs.builder()
            .eula(eula?.applyValue({ args0 -> args0 }))
            .publicNamePrefix(publicNamePrefix?.applyValue({ args0 -> args0 }))
            .publisherContact(publisherContact?.applyValue({ args0 -> args0 }))
            .publisherUri(publisherUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CommunityGalleryInfoArgs].
 */
@PulumiTagMarker
public class CommunityGalleryInfoArgsBuilder internal constructor() {
    private var eula: Output<String>? = null

    private var publicNamePrefix: Output<String>? = null

    private var publisherContact: Output<String>? = null

    private var publisherUri: Output<String>? = null

    /**
     * @param value End-user license agreement for community gallery image.
     */
    @JvmName("mwbrdwfnfcjpiypt")
    public suspend fun eula(`value`: Output<String>) {
        this.eula = value
    }

    /**
     * @param value The prefix of the gallery name that will be displayed publicly. Visible to all users.
     */
    @JvmName("qoqfrnvloieqdrkl")
    public suspend fun publicNamePrefix(`value`: Output<String>) {
        this.publicNamePrefix = value
    }

    /**
     * @param value Community gallery publisher support email. The email address of the publisher. Visible to all users.
     */
    @JvmName("jrqiqpsftgfrswrx")
    public suspend fun publisherContact(`value`: Output<String>) {
        this.publisherContact = value
    }

    /**
     * @param value The link to the publisher website. Visible to all users.
     */
    @JvmName("lnqbsjmxieagsoox")
    public suspend fun publisherUri(`value`: Output<String>) {
        this.publisherUri = value
    }

    /**
     * @param value End-user license agreement for community gallery image.
     */
    @JvmName("yjblhstnwwkpwmyq")
    public suspend fun eula(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eula = mapped
    }

    /**
     * @param value The prefix of the gallery name that will be displayed publicly. Visible to all users.
     */
    @JvmName("afmwsirpetuscbtd")
    public suspend fun publicNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNamePrefix = mapped
    }

    /**
     * @param value Community gallery publisher support email. The email address of the publisher. Visible to all users.
     */
    @JvmName("pesncfbgwiqbpnem")
    public suspend fun publisherContact(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherContact = mapped
    }

    /**
     * @param value The link to the publisher website. Visible to all users.
     */
    @JvmName("bxdumhujokmnshef")
    public suspend fun publisherUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherUri = mapped
    }

    internal fun build(): CommunityGalleryInfoArgs = CommunityGalleryInfoArgs(
        eula = eula,
        publicNamePrefix = publicNamePrefix,
        publisherContact = publisherContact,
        publisherUri = publisherUri,
    )
}
