@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.DataDiskArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.CachingTypes
import com.pulumi.azurenative.compute.kotlin.enums.DiskCreateOptionTypes
import com.pulumi.azurenative.compute.kotlin.enums.DiskDeleteOptionTypes
import com.pulumi.azurenative.compute.kotlin.enums.DiskDetachOptionTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a data disk.
 * @property caching Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**
 * @property createOption Specifies how the virtual machine should be created. Possible values are: **Attach.** This value is used when you are using a specialized disk to create the virtual machine. **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you should also use the imageReference element described above. If you are using a marketplace image, you should also use the plan element previously described.
 * @property deleteOption Specifies whether data disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If this value is used, the data disk is deleted when VM is deleted. **Detach.** If this value is used, the data disk is retained after VM is deleted. The default value is set to **Detach**.
 * @property detachOption Specifies the detach behavior to be used while detaching a disk or which is already in the process of detachment from the virtual machine. Supported values: **ForceDetach.** detachOption: **ForceDetach** is applicable only for managed data disks. If a previous detachment attempt of the data disk did not complete due to an unexpected failure from the virtual machine and the disk is still not released then use force-detach as a last resort option to detach the disk forcibly from the VM. All writes might not have been flushed when using this detach behavior. **This feature is still in preview** mode and is not supported for VirtualMachineScaleSet. To force-detach a data disk update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
 * @property diskSizeGB Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
 * @property image The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
 * @property lun Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
 * @property managedDisk The managed disk parameters.
 * @property name The disk name.
 * @property toBeDetached Specifies whether the data disk is in process of detachment from the VirtualMachine/VirtualMachineScaleset
 * @property vhd The virtual hard disk.
 * @property writeAcceleratorEnabled Specifies whether writeAccelerator should be enabled or disabled on the disk.
 */
public data class DataDiskArgs(
    public val caching: Output<CachingTypes>? = null,
    public val createOption: Output<Either<String, DiskCreateOptionTypes>>,
    public val deleteOption: Output<Either<String, DiskDeleteOptionTypes>>? = null,
    public val detachOption: Output<Either<String, DiskDetachOptionTypes>>? = null,
    public val diskSizeGB: Output<Int>? = null,
    public val image: Output<VirtualHardDiskArgs>? = null,
    public val lun: Output<Int>,
    public val managedDisk: Output<ManagedDiskParametersArgs>? = null,
    public val name: Output<String>? = null,
    public val toBeDetached: Output<Boolean>? = null,
    public val vhd: Output<VirtualHardDiskArgs>? = null,
    public val writeAcceleratorEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.DataDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.DataDiskArgs =
        com.pulumi.azurenative.compute.inputs.DataDiskArgs.builder()
            .caching(caching?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .createOption(
                createOption.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deleteOption(
                deleteOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .detachOption(
                detachOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .diskSizeGB(diskSizeGB?.applyValue({ args0 -> args0 }))
            .image(image?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .lun(lun.applyValue({ args0 -> args0 }))
            .managedDisk(managedDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .toBeDetached(toBeDetached?.applyValue({ args0 -> args0 }))
            .vhd(vhd?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .writeAcceleratorEnabled(writeAcceleratorEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataDiskArgs].
 */
@PulumiTagMarker
public class DataDiskArgsBuilder internal constructor() {
    private var caching: Output<CachingTypes>? = null

    private var createOption: Output<Either<String, DiskCreateOptionTypes>>? = null

    private var deleteOption: Output<Either<String, DiskDeleteOptionTypes>>? = null

    private var detachOption: Output<Either<String, DiskDetachOptionTypes>>? = null

    private var diskSizeGB: Output<Int>? = null

    private var image: Output<VirtualHardDiskArgs>? = null

    private var lun: Output<Int>? = null

    private var managedDisk: Output<ManagedDiskParametersArgs>? = null

    private var name: Output<String>? = null

    private var toBeDetached: Output<Boolean>? = null

    private var vhd: Output<VirtualHardDiskArgs>? = null

    private var writeAcceleratorEnabled: Output<Boolean>? = null

    /**
     * @param value Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**
     */
    @JvmName("pqrhwfyvgehyfibg")
    public suspend fun caching(`value`: Output<CachingTypes>) {
        this.caching = value
    }

    /**
     * @param value Specifies how the virtual machine should be created. Possible values are: **Attach.** This value is used when you are using a specialized disk to create the virtual machine. **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you should also use the imageReference element described above. If you are using a marketplace image, you should also use the plan element previously described.
     */
    @JvmName("cnrwaabibcklljbm")
    public suspend fun createOption(`value`: Output<Either<String, DiskCreateOptionTypes>>) {
        this.createOption = value
    }

    /**
     * @param value Specifies whether data disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If this value is used, the data disk is deleted when VM is deleted. **Detach.** If this value is used, the data disk is retained after VM is deleted. The default value is set to **Detach**.
     */
    @JvmName("yfktekbxbefhhmyi")
    public suspend fun deleteOption(`value`: Output<Either<String, DiskDeleteOptionTypes>>) {
        this.deleteOption = value
    }

    /**
     * @param value Specifies the detach behavior to be used while detaching a disk or which is already in the process of detachment from the virtual machine. Supported values: **ForceDetach.** detachOption: **ForceDetach** is applicable only for managed data disks. If a previous detachment attempt of the data disk did not complete due to an unexpected failure from the virtual machine and the disk is still not released then use force-detach as a last resort option to detach the disk forcibly from the VM. All writes might not have been flushed when using this detach behavior. **This feature is still in preview** mode and is not supported for VirtualMachineScaleSet. To force-detach a data disk update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
     */
    @JvmName("woqfwhjfpouurndj")
    public suspend fun detachOption(`value`: Output<Either<String, DiskDetachOptionTypes>>) {
        this.detachOption = value
    }

    /**
     * @param value Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
     */
    @JvmName("tavivlcoecrawyuq")
    public suspend fun diskSizeGB(`value`: Output<Int>) {
        this.diskSizeGB = value
    }

    /**
     * @param value The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
     */
    @JvmName("qyohjvgtycyyatkq")
    public suspend fun image(`value`: Output<VirtualHardDiskArgs>) {
        this.image = value
    }

    /**
     * @param value Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
     */
    @JvmName("lgelvheseyvsqrtc")
    public suspend fun lun(`value`: Output<Int>) {
        this.lun = value
    }

    /**
     * @param value The managed disk parameters.
     */
    @JvmName("ewbcbftspwemgidm")
    public suspend fun managedDisk(`value`: Output<ManagedDiskParametersArgs>) {
        this.managedDisk = value
    }

    /**
     * @param value The disk name.
     */
    @JvmName("dadbthvvyebjwcxj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies whether the data disk is in process of detachment from the VirtualMachine/VirtualMachineScaleset
     */
    @JvmName("wdvgktqahbltblxl")
    public suspend fun toBeDetached(`value`: Output<Boolean>) {
        this.toBeDetached = value
    }

    /**
     * @param value The virtual hard disk.
     */
    @JvmName("oikruiicdrjumudr")
    public suspend fun vhd(`value`: Output<VirtualHardDiskArgs>) {
        this.vhd = value
    }

    /**
     * @param value Specifies whether writeAccelerator should be enabled or disabled on the disk.
     */
    @JvmName("svtmmbafepjpcbnx")
    public suspend fun writeAcceleratorEnabled(`value`: Output<Boolean>) {
        this.writeAcceleratorEnabled = value
    }

    /**
     * @param value Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**
     */
    @JvmName("hvfqrtoinjjtmvcv")
    public suspend fun caching(`value`: CachingTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caching = mapped
    }

    /**
     * @param value Specifies how the virtual machine should be created. Possible values are: **Attach.** This value is used when you are using a specialized disk to create the virtual machine. **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you should also use the imageReference element described above. If you are using a marketplace image, you should also use the plan element previously described.
     */
    @JvmName("jqpsppilufpnouwc")
    public suspend fun createOption(`value`: Either<String, DiskCreateOptionTypes>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value Specifies how the virtual machine should be created. Possible values are: **Attach.** This value is used when you are using a specialized disk to create the virtual machine. **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you should also use the imageReference element described above. If you are using a marketplace image, you should also use the plan element previously described.
     */
    @JvmName("wpfhajpsvkncqqhg")
    public fun createOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskCreateOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value Specifies how the virtual machine should be created. Possible values are: **Attach.** This value is used when you are using a specialized disk to create the virtual machine. **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you should also use the imageReference element described above. If you are using a marketplace image, you should also use the plan element previously described.
     */
    @JvmName("yrkjbfniempgokwk")
    public fun createOption(`value`: DiskCreateOptionTypes) {
        val toBeMapped = Either.ofRight<String, DiskCreateOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value Specifies whether data disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If this value is used, the data disk is deleted when VM is deleted. **Detach.** If this value is used, the data disk is retained after VM is deleted. The default value is set to **Detach**.
     */
    @JvmName("lalsjgmdrekwriys")
    public suspend fun deleteOption(`value`: Either<String, DiskDeleteOptionTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specifies whether data disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If this value is used, the data disk is deleted when VM is deleted. **Detach.** If this value is used, the data disk is retained after VM is deleted. The default value is set to **Detach**.
     */
    @JvmName("thdqixndbiggacgj")
    public fun deleteOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskDeleteOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specifies whether data disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If this value is used, the data disk is deleted when VM is deleted. **Detach.** If this value is used, the data disk is retained after VM is deleted. The default value is set to **Detach**.
     */
    @JvmName("qdijdfdpwekvqoos")
    public fun deleteOption(`value`: DiskDeleteOptionTypes) {
        val toBeMapped = Either.ofRight<String, DiskDeleteOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specifies the detach behavior to be used while detaching a disk or which is already in the process of detachment from the virtual machine. Supported values: **ForceDetach.** detachOption: **ForceDetach** is applicable only for managed data disks. If a previous detachment attempt of the data disk did not complete due to an unexpected failure from the virtual machine and the disk is still not released then use force-detach as a last resort option to detach the disk forcibly from the VM. All writes might not have been flushed when using this detach behavior. **This feature is still in preview** mode and is not supported for VirtualMachineScaleSet. To force-detach a data disk update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
     */
    @JvmName("xoramrfoaxbyoveu")
    public suspend fun detachOption(`value`: Either<String, DiskDetachOptionTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detachOption = mapped
    }

    /**
     * @param value Specifies the detach behavior to be used while detaching a disk or which is already in the process of detachment from the virtual machine. Supported values: **ForceDetach.** detachOption: **ForceDetach** is applicable only for managed data disks. If a previous detachment attempt of the data disk did not complete due to an unexpected failure from the virtual machine and the disk is still not released then use force-detach as a last resort option to detach the disk forcibly from the VM. All writes might not have been flushed when using this detach behavior. **This feature is still in preview** mode and is not supported for VirtualMachineScaleSet. To force-detach a data disk update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
     */
    @JvmName("gguijscvhmdaefyy")
    public fun detachOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskDetachOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.detachOption = mapped
    }

    /**
     * @param value Specifies the detach behavior to be used while detaching a disk or which is already in the process of detachment from the virtual machine. Supported values: **ForceDetach.** detachOption: **ForceDetach** is applicable only for managed data disks. If a previous detachment attempt of the data disk did not complete due to an unexpected failure from the virtual machine and the disk is still not released then use force-detach as a last resort option to detach the disk forcibly from the VM. All writes might not have been flushed when using this detach behavior. **This feature is still in preview** mode and is not supported for VirtualMachineScaleSet. To force-detach a data disk update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
     */
    @JvmName("rbdeurnyvbyhrurs")
    public fun detachOption(`value`: DiskDetachOptionTypes) {
        val toBeMapped = Either.ofRight<String, DiskDetachOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.detachOption = mapped
    }

    /**
     * @param value Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
     */
    @JvmName("qpwdvcshgvybjuot")
    public suspend fun diskSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
     */
    @JvmName("jxarsyufomorxclk")
    public suspend fun image(`value`: VirtualHardDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param argument The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
     */
    @JvmName("rcrgrhsiuxpydmyu")
    public suspend fun image(argument: suspend VirtualHardDiskArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualHardDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.image = mapped
    }

    /**
     * @param value Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
     */
    @JvmName("sdrbafeqhvroekxy")
    public suspend fun lun(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lun = mapped
    }

    /**
     * @param value The managed disk parameters.
     */
    @JvmName("odrfwepnravdyprj")
    public suspend fun managedDisk(`value`: ManagedDiskParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedDisk = mapped
    }

    /**
     * @param argument The managed disk parameters.
     */
    @JvmName("djfqnmhppmcudavk")
    public suspend fun managedDisk(argument: suspend ManagedDiskParametersArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedDiskParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedDisk = mapped
    }

    /**
     * @param value The disk name.
     */
    @JvmName("eqwtlwxcstcmloel")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies whether the data disk is in process of detachment from the VirtualMachine/VirtualMachineScaleset
     */
    @JvmName("pffaiikiffmfukkx")
    public suspend fun toBeDetached(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toBeDetached = mapped
    }

    /**
     * @param value The virtual hard disk.
     */
    @JvmName("pjtprtbwgsadgana")
    public suspend fun vhd(`value`: VirtualHardDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vhd = mapped
    }

    /**
     * @param argument The virtual hard disk.
     */
    @JvmName("wycixwbvdnixhchg")
    public suspend fun vhd(argument: suspend VirtualHardDiskArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualHardDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vhd = mapped
    }

    /**
     * @param value Specifies whether writeAccelerator should be enabled or disabled on the disk.
     */
    @JvmName("dhebqdcqqbpixwyh")
    public suspend fun writeAcceleratorEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeAcceleratorEnabled = mapped
    }

    internal fun build(): DataDiskArgs = DataDiskArgs(
        caching = caching,
        createOption = createOption ?: throw PulumiNullFieldException("createOption"),
        deleteOption = deleteOption,
        detachOption = detachOption,
        diskSizeGB = diskSizeGB,
        image = image,
        lun = lun ?: throw PulumiNullFieldException("lun"),
        managedDisk = managedDisk,
        name = name,
        toBeDetached = toBeDetached,
        vhd = vhd,
        writeAcceleratorEnabled = writeAcceleratorEnabled,
    )
}
