@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Enables or disables a capability on the dedicated host group. Minimum api-version: 2022-03-01.
 * @property ultraSSDEnabled The flag that enables or disables a capability to have UltraSSD Enabled Virtual Machines on Dedicated Hosts of the Dedicated Host Group. For the Virtual Machines to be UltraSSD Enabled, UltraSSDEnabled flag for the resource needs to be set true as well. The value is defaulted to 'false' when not provided. Please refer to https://docs.microsoft.com/en-us/azure/virtual-machines/disks-enable-ultra-ssd for more details on Ultra SSD feature. **Note:** The ultraSSDEnabled setting can only be enabled for Host Groups that are created as zonal. Minimum api-version: 2022-03-01.
 */
public data class DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs(
    public val ultraSSDEnabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs =
        com.pulumi.azurenative.compute.inputs.DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs.builder()
            .ultraSSDEnabled(ultraSSDEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs].
 */
@PulumiTagMarker
public class DedicatedHostGroupPropertiesAdditionalCapabilitiesArgsBuilder internal constructor() {
    private var ultraSSDEnabled: Output<Boolean>? = null

    /**
     * @param value The flag that enables or disables a capability to have UltraSSD Enabled Virtual Machines on Dedicated Hosts of the Dedicated Host Group. For the Virtual Machines to be UltraSSD Enabled, UltraSSDEnabled flag for the resource needs to be set true as well. The value is defaulted to 'false' when not provided. Please refer to https://docs.microsoft.com/en-us/azure/virtual-machines/disks-enable-ultra-ssd for more details on Ultra SSD feature. **Note:** The ultraSSDEnabled setting can only be enabled for Host Groups that are created as zonal. Minimum api-version: 2022-03-01.
     */
    @JvmName("etwqlvrspndsvhfy")
    public suspend fun ultraSSDEnabled(`value`: Output<Boolean>) {
        this.ultraSSDEnabled = value
    }

    /**
     * @param value The flag that enables or disables a capability to have UltraSSD Enabled Virtual Machines on Dedicated Hosts of the Dedicated Host Group. For the Virtual Machines to be UltraSSD Enabled, UltraSSDEnabled flag for the resource needs to be set true as well. The value is defaulted to 'false' when not provided. Please refer to https://docs.microsoft.com/en-us/azure/virtual-machines/disks-enable-ultra-ssd for more details on Ultra SSD feature. **Note:** The ultraSSDEnabled setting can only be enabled for Host Groups that are created as zonal. Minimum api-version: 2022-03-01.
     */
    @JvmName("npscdgggblptgksi")
    public suspend fun ultraSSDEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ultraSSDEnabled = mapped
    }

    internal fun build(): DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs =
        DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs(
            ultraSSDEnabled = ultraSSDEnabled,
        )
}
