@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GalleryApplicationCustomActionParameterArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.GalleryApplicationCustomActionParameterType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The definition of a parameter that can be passed to a custom action of a Gallery Application Version.
 * @property defaultValue The default value of the parameter.  Only applies to string types
 * @property description A description to help users understand what this parameter means
 * @property name The name of the custom action.  Must be unique within the Gallery Application Version.
 * @property required Indicates whether this parameter must be passed when running the custom action.
 * @property type Specifies the type of the custom action parameter. Possible values are: String, ConfigurationDataBlob or LogOutputBlob
 */
public data class GalleryApplicationCustomActionParameterArgs(
    public val defaultValue: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>,
    public val required: Output<Boolean>? = null,
    public val type: Output<GalleryApplicationCustomActionParameterType>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GalleryApplicationCustomActionParameterArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.GalleryApplicationCustomActionParameterArgs =
        com.pulumi.azurenative.compute.inputs.GalleryApplicationCustomActionParameterArgs.builder()
            .defaultValue(defaultValue?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .required(required?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GalleryApplicationCustomActionParameterArgs].
 */
@PulumiTagMarker
public class GalleryApplicationCustomActionParameterArgsBuilder internal constructor() {
    private var defaultValue: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var required: Output<Boolean>? = null

    private var type: Output<GalleryApplicationCustomActionParameterType>? = null

    /**
     * @param value The default value of the parameter.  Only applies to string types
     */
    @JvmName("pxejupmncwavfron")
    public suspend fun defaultValue(`value`: Output<String>) {
        this.defaultValue = value
    }

    /**
     * @param value A description to help users understand what this parameter means
     */
    @JvmName("tfbhuywpgjbkiaas")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the custom action.  Must be unique within the Gallery Application Version.
     */
    @JvmName("vctddkmdhefnqjru")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates whether this parameter must be passed when running the custom action.
     */
    @JvmName("armithwfebdaalcs")
    public suspend fun required(`value`: Output<Boolean>) {
        this.required = value
    }

    /**
     * @param value Specifies the type of the custom action parameter. Possible values are: String, ConfigurationDataBlob or LogOutputBlob
     */
    @JvmName("npuaqwuddqhpctqo")
    public suspend fun type(`value`: Output<GalleryApplicationCustomActionParameterType>) {
        this.type = value
    }

    /**
     * @param value The default value of the parameter.  Only applies to string types
     */
    @JvmName("tapmdxvxcudhwsed")
    public suspend fun defaultValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValue = mapped
    }

    /**
     * @param value A description to help users understand what this parameter means
     */
    @JvmName("yerlfvygruuahdvt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the custom action.  Must be unique within the Gallery Application Version.
     */
    @JvmName("acuosfqggfmicbrp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Indicates whether this parameter must be passed when running the custom action.
     */
    @JvmName("gfawqhlqwcdqfuyx")
    public suspend fun required(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.required = mapped
    }

    /**
     * @param value Specifies the type of the custom action parameter. Possible values are: String, ConfigurationDataBlob or LogOutputBlob
     */
    @JvmName("soprdmadpuknxkov")
    public suspend fun type(`value`: GalleryApplicationCustomActionParameterType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): GalleryApplicationCustomActionParameterArgs =
        GalleryApplicationCustomActionParameterArgs(
            defaultValue = defaultValue,
            description = description,
            name = name ?: throw PulumiNullFieldException("name"),
            required = required,
            type = type,
        )
}
