@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GalleryApplicationVersionSafetyProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The safety profile of the Gallery Application Version.
 * @property allowDeletionOfReplicatedLocations Indicates whether or not removing this Gallery Image Version from replicated regions is allowed.
 */
public data class GalleryApplicationVersionSafetyProfileArgs(
    public val allowDeletionOfReplicatedLocations: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GalleryApplicationVersionSafetyProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.GalleryApplicationVersionSafetyProfileArgs =
        com.pulumi.azurenative.compute.inputs.GalleryApplicationVersionSafetyProfileArgs.builder()
            .allowDeletionOfReplicatedLocations(
                allowDeletionOfReplicatedLocations?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [GalleryApplicationVersionSafetyProfileArgs].
 */
@PulumiTagMarker
public class GalleryApplicationVersionSafetyProfileArgsBuilder internal constructor() {
    private var allowDeletionOfReplicatedLocations: Output<Boolean>? = null

    /**
     * @param value Indicates whether or not removing this Gallery Image Version from replicated regions is allowed.
     */
    @JvmName("vvumfggwpufrrrxi")
    public suspend fun allowDeletionOfReplicatedLocations(`value`: Output<Boolean>) {
        this.allowDeletionOfReplicatedLocations = value
    }

    /**
     * @param value Indicates whether or not removing this Gallery Image Version from replicated regions is allowed.
     */
    @JvmName("jrbrpsvidwtpwicq")
    public suspend fun allowDeletionOfReplicatedLocations(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowDeletionOfReplicatedLocations = mapped
    }

    internal fun build(): GalleryApplicationVersionSafetyProfileArgs =
        GalleryApplicationVersionSafetyProfileArgs(
            allowDeletionOfReplicatedLocations = allowDeletionOfReplicatedLocations,
        )
}
