@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GalleryExtendedLocationArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.GalleryExtendedLocationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The name of the extended location.
 * @property name
 * @property type It is type of the extended location.
 */
public data class GalleryExtendedLocationArgs(
    public val name: Output<String>? = null,
    public val type: Output<Either<String, GalleryExtendedLocationType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GalleryExtendedLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GalleryExtendedLocationArgs =
        com.pulumi.azurenative.compute.inputs.GalleryExtendedLocationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GalleryExtendedLocationArgs].
 */
@PulumiTagMarker
public class GalleryExtendedLocationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<Either<String, GalleryExtendedLocationType>>? = null

    /**
     * @param value
     */
    @JvmName("jolejuvturektsdp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value It is type of the extended location.
     */
    @JvmName("fpuikwvvlrjhmvdw")
    public suspend fun type(`value`: Output<Either<String, GalleryExtendedLocationType>>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("jrityakdgivcrcjc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value It is type of the extended location.
     */
    @JvmName("etrvlsljnpatxmsn")
    public suspend fun type(`value`: Either<String, GalleryExtendedLocationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value It is type of the extended location.
     */
    @JvmName("oqccfahjapfwdftw")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GalleryExtendedLocationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value It is type of the extended location.
     */
    @JvmName("nqllmeaenruvxckv")
    public fun type(`value`: GalleryExtendedLocationType) {
        val toBeMapped = Either.ofRight<String, GalleryExtendedLocationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): GalleryExtendedLocationArgs = GalleryExtendedLocationArgs(
        name = name,
        type = type,
    )
}
