@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetAvailabilitySetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property availabilitySetName The name of the availability set.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetAvailabilitySetPlainArgs(
    public val availabilitySetName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetAvailabilitySetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetAvailabilitySetPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetAvailabilitySetPlainArgs.builder()
            .availabilitySetName(availabilitySetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAvailabilitySetPlainArgs].
 */
@PulumiTagMarker
public class GetAvailabilitySetPlainArgsBuilder internal constructor() {
    private var availabilitySetName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the availability set.
     */
    @JvmName("srrldqhwlhjanawj")
    public suspend fun availabilitySetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.availabilitySetName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lknyladjhmmuvlae")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAvailabilitySetPlainArgs = GetAvailabilitySetPlainArgs(
        availabilitySetName = availabilitySetName ?: throw PulumiNullFieldException("availabilitySetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
