@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetDedicatedHostGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand expression to apply on the operation. 'InstanceView' will retrieve the list of instance views of the dedicated hosts under the dedicated host group. 'UserData' is not supported for dedicated host group.
 * @property hostGroupName The name of the dedicated host group.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetDedicatedHostGroupPlainArgs(
    public val expand: String? = null,
    public val hostGroupName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetDedicatedHostGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetDedicatedHostGroupPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetDedicatedHostGroupPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .hostGroupName(hostGroupName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDedicatedHostGroupPlainArgs].
 */
@PulumiTagMarker
public class GetDedicatedHostGroupPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var hostGroupName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The expand expression to apply on the operation. 'InstanceView' will retrieve the list of instance views of the dedicated hosts under the dedicated host group. 'UserData' is not supported for dedicated host group.
     */
    @JvmName("pbmvcumqwqjissqd")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the dedicated host group.
     */
    @JvmName("iuipuielhabxrcsd")
    public suspend fun hostGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hostGroupName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ejasgrinqfmkqjvi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDedicatedHostGroupPlainArgs = GetDedicatedHostGroupPlainArgs(
        expand = expand,
        hostGroupName = hostGroupName ?: throw PulumiNullFieldException("hostGroupName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
