@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetGalleryImageVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand expression to apply on the operation.
 * @property galleryImageName The name of the gallery image definition in which the Image Version resides.
 * @property galleryImageVersionName The name of the gallery image version to be retrieved.
 * @property galleryName The name of the Shared Image Gallery in which the Image Definition resides.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetGalleryImageVersionPlainArgs(
    public val expand: String? = null,
    public val galleryImageName: String,
    public val galleryImageVersionName: String,
    public val galleryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetGalleryImageVersionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetGalleryImageVersionPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetGalleryImageVersionPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .galleryImageName(galleryImageName.let({ args0 -> args0 }))
            .galleryImageVersionName(galleryImageVersionName.let({ args0 -> args0 }))
            .galleryName(galleryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGalleryImageVersionPlainArgs].
 */
@PulumiTagMarker
public class GetGalleryImageVersionPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var galleryImageName: String? = null

    private var galleryImageVersionName: String? = null

    private var galleryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The expand expression to apply on the operation.
     */
    @JvmName("ilhnwdvlgukqdaff")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the gallery image definition in which the Image Version resides.
     */
    @JvmName("bppfxhtauvflapet")
    public suspend fun galleryImageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.galleryImageName = mapped
    }

    /**
     * @param value The name of the gallery image version to be retrieved.
     */
    @JvmName("pduocukwllporqqs")
    public suspend fun galleryImageVersionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.galleryImageVersionName = mapped
    }

    /**
     * @param value The name of the Shared Image Gallery in which the Image Definition resides.
     */
    @JvmName("rixnwugemyviruqp")
    public suspend fun galleryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.galleryName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("weytckiwsinskojt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGalleryImageVersionPlainArgs = GetGalleryImageVersionPlainArgs(
        expand = expand,
        galleryImageName = galleryImageName ?: throw PulumiNullFieldException("galleryImageName"),
        galleryImageVersionName = galleryImageVersionName ?: throw
            PulumiNullFieldException("galleryImageVersionName"),
        galleryName = galleryName ?: throw PulumiNullFieldException("galleryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
