@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetGalleryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand query option to apply on the operation.
 * @property galleryName The name of the Shared Image Gallery.
 * @property resourceGroupName The name of the resource group.
 * @property select The select expression to apply on the operation.
 */
public data class GetGalleryPlainArgs(
    public val expand: String? = null,
    public val galleryName: String,
    public val resourceGroupName: String,
    public val select: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetGalleryPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetGalleryPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetGalleryPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .galleryName(galleryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .select(select?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGalleryPlainArgs].
 */
@PulumiTagMarker
public class GetGalleryPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var galleryName: String? = null

    private var resourceGroupName: String? = null

    private var select: String? = null

    /**
     * @param value The expand query option to apply on the operation.
     */
    @JvmName("bxleoylcxcbuylby")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the Shared Image Gallery.
     */
    @JvmName("fbnlddnslffypwio")
    public suspend fun galleryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.galleryName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rdclolbaqclqirha")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The select expression to apply on the operation.
     */
    @JvmName("igmjtwferuldagil")
    public suspend fun select(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.select = mapped
    }

    internal fun build(): GetGalleryPlainArgs = GetGalleryPlainArgs(
        expand = expand,
        galleryName = galleryName ?: throw PulumiNullFieldException("galleryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        select = select,
    )
}
