@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetVirtualMachineExtensionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand expression to apply on the operation.
 * @property resourceGroupName The name of the resource group.
 * @property vmExtensionName The name of the virtual machine extension.
 * @property vmName The name of the virtual machine containing the extension.
 */
public data class GetVirtualMachineExtensionPlainArgs(
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val vmExtensionName: String,
    public val vmName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetVirtualMachineExtensionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetVirtualMachineExtensionPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetVirtualMachineExtensionPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vmExtensionName(vmExtensionName.let({ args0 -> args0 }))
            .vmName(vmName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualMachineExtensionPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualMachineExtensionPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var vmExtensionName: String? = null

    private var vmName: String? = null

    /**
     * @param value The expand expression to apply on the operation.
     */
    @JvmName("vajrcqulrotqetij")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wiegpmofpkdjwrks")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual machine extension.
     */
    @JvmName("gsewcqtpernlvhvf")
    public suspend fun vmExtensionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmExtensionName = mapped
    }

    /**
     * @param value The name of the virtual machine containing the extension.
     */
    @JvmName("gnjeeuyytlsblviw")
    public suspend fun vmName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmName = mapped
    }

    internal fun build(): GetVirtualMachineExtensionPlainArgs = GetVirtualMachineExtensionPlainArgs(
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vmExtensionName = vmExtensionName ?: throw PulumiNullFieldException("vmExtensionName"),
        vmName = vmName ?: throw PulumiNullFieldException("vmName"),
    )
}
