@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetVirtualMachinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand expression to apply on the operation. 'InstanceView' retrieves a snapshot of the runtime properties of the virtual machine that is managed by the platform and can change outside of control plane operations. 'UserData' retrieves the UserData property as part of the VM model view that was provided by the user during the VM Create/Update operation.
 * @property resourceGroupName The name of the resource group.
 * @property vmName The name of the virtual machine.
 */
public data class GetVirtualMachinePlainArgs(
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val vmName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetVirtualMachinePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetVirtualMachinePlainArgs =
        com.pulumi.azurenative.compute.inputs.GetVirtualMachinePlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vmName(vmName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualMachinePlainArgs].
 */
@PulumiTagMarker
public class GetVirtualMachinePlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var vmName: String? = null

    /**
     * @param value The expand expression to apply on the operation. 'InstanceView' retrieves a snapshot of the runtime properties of the virtual machine that is managed by the platform and can change outside of control plane operations. 'UserData' retrieves the UserData property as part of the VM model view that was provided by the user during the VM Create/Update operation.
     */
    @JvmName("dfododioofuemwcv")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("caxsyyywbnhlccpd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual machine.
     */
    @JvmName("sonejcnmlxantdlf")
    public suspend fun vmName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmName = mapped
    }

    internal fun build(): GetVirtualMachinePlainArgs = GetVirtualMachinePlainArgs(
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vmName = vmName ?: throw PulumiNullFieldException("vmName"),
    )
}
