@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetExtensionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand expression to apply on the operation.
 * @property resourceGroupName The name of the resource group.
 * @property vmScaleSetName The name of the VM scale set containing the extension.
 * @property vmssExtensionName The name of the VM scale set extension.
 */
public data class GetVirtualMachineScaleSetExtensionPlainArgs(
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val vmScaleSetName: String,
    public val vmssExtensionName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetExtensionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetExtensionPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetExtensionPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vmScaleSetName(vmScaleSetName.let({ args0 -> args0 }))
            .vmssExtensionName(vmssExtensionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualMachineScaleSetExtensionPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualMachineScaleSetExtensionPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var vmScaleSetName: String? = null

    private var vmssExtensionName: String? = null

    /**
     * @param value The expand expression to apply on the operation.
     */
    @JvmName("ybotfwysefjvrcql")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("bnchhvfjnquajnne")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VM scale set containing the extension.
     */
    @JvmName("wstggvcrfmechers")
    public suspend fun vmScaleSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmScaleSetName = mapped
    }

    /**
     * @param value The name of the VM scale set extension.
     */
    @JvmName("bxaepwbctgessmax")
    public suspend fun vmssExtensionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmssExtensionName = mapped
    }

    internal fun build(): GetVirtualMachineScaleSetExtensionPlainArgs =
        GetVirtualMachineScaleSetExtensionPlainArgs(
            expand = expand,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            vmScaleSetName = vmScaleSetName ?: throw PulumiNullFieldException("vmScaleSetName"),
            vmssExtensionName = vmssExtensionName ?: throw PulumiNullFieldException("vmssExtensionName"),
        )
}
