@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetVMRunCommandPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand expression to apply on the operation.
 * @property instanceId The instance ID of the virtual machine.
 * @property resourceGroupName The name of the resource group.
 * @property runCommandName The name of the virtual machine run command.
 * @property vmScaleSetName The name of the VM scale set.
 */
public data class GetVirtualMachineScaleSetVMRunCommandPlainArgs(
    public val expand: String? = null,
    public val instanceId: String,
    public val resourceGroupName: String,
    public val runCommandName: String,
    public val vmScaleSetName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetVMRunCommandPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetVMRunCommandPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetVMRunCommandPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .runCommandName(runCommandName.let({ args0 -> args0 }))
            .vmScaleSetName(vmScaleSetName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualMachineScaleSetVMRunCommandPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualMachineScaleSetVMRunCommandPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var instanceId: String? = null

    private var resourceGroupName: String? = null

    private var runCommandName: String? = null

    private var vmScaleSetName: String? = null

    /**
     * @param value The expand expression to apply on the operation.
     */
    @JvmName("ivcetmpeictbjllx")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The instance ID of the virtual machine.
     */
    @JvmName("xurycrjftfrewrvw")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("invmtngsndsryxgp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual machine run command.
     */
    @JvmName("peguhfdxfciiggxa")
    public suspend fun runCommandName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.runCommandName = mapped
    }

    /**
     * @param value The name of the VM scale set.
     */
    @JvmName("hxnrhtyaiwcbfhem")
    public suspend fun vmScaleSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmScaleSetName = mapped
    }

    internal fun build(): GetVirtualMachineScaleSetVMRunCommandPlainArgs =
        GetVirtualMachineScaleSetVMRunCommandPlainArgs(
            expand = expand,
            instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            runCommandName = runCommandName ?: throw PulumiNullFieldException("runCommandName"),
            vmScaleSetName = vmScaleSetName ?: throw PulumiNullFieldException("vmScaleSetName"),
        )
}
