@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.VirtualMachineSizeTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies the hardware settings for the virtual machine.
 * @property vmSize Specifies the size of the virtual machine. The enum data type is currently deprecated and will be removed by December 23rd 2023. The recommended way to get the list of available sizes is using these APIs: [List all available virtual machine sizes in an availability set](https://docs&#46;microsoft&#46;com/rest/api/compute/availabilitysets/listavailablesizes), [List all available virtual machine sizes in a region]( https://docs&#46;microsoft&#46;com/rest/api/compute/resourceskus/list), [List all available virtual machine sizes for resizing](https://docs&#46;microsoft&#46;com/rest/api/compute/virtualmachines/listavailablesizes)&#46; For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/sizes). The available VM sizes depend on region and availability set.
 * @property vmSizeProperties Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-07-01. This feature is still in preview mode and is not supported for VirtualMachineScaleSet. Please follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for more details.
 */
public data class HardwareProfileArgs(
    public val vmSize: Output<Either<String, VirtualMachineSizeTypes>>? = null,
    public val vmSizeProperties: Output<VMSizePropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.HardwareProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.HardwareProfileArgs =
        com.pulumi.azurenative.compute.inputs.HardwareProfileArgs.builder()
            .vmSize(
                vmSize?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vmSizeProperties(
                vmSizeProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [HardwareProfileArgs].
 */
@PulumiTagMarker
public class HardwareProfileArgsBuilder internal constructor() {
    private var vmSize: Output<Either<String, VirtualMachineSizeTypes>>? = null

    private var vmSizeProperties: Output<VMSizePropertiesArgs>? = null

    /**
     * @param value Specifies the size of the virtual machine. The enum data type is currently deprecated and will be removed by December 23rd 2023. The recommended way to get the list of available sizes is using these APIs: [List all available virtual machine sizes in an availability set](https://docs&#46;microsoft&#46;com/rest/api/compute/availabilitysets/listavailablesizes), [List all available virtual machine sizes in a region]( https://docs&#46;microsoft&#46;com/rest/api/compute/resourceskus/list), [List all available virtual machine sizes for resizing](https://docs&#46;microsoft&#46;com/rest/api/compute/virtualmachines/listavailablesizes)&#46; For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/sizes). The available VM sizes depend on region and availability set.
     */
    @JvmName("pvxekdktlbajpdym")
    public suspend fun vmSize(`value`: Output<Either<String, VirtualMachineSizeTypes>>) {
        this.vmSize = value
    }

    /**
     * @param value Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-07-01. This feature is still in preview mode and is not supported for VirtualMachineScaleSet. Please follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for more details.
     */
    @JvmName("uoynbvcgypoygirp")
    public suspend fun vmSizeProperties(`value`: Output<VMSizePropertiesArgs>) {
        this.vmSizeProperties = value
    }

    /**
     * @param value Specifies the size of the virtual machine. The enum data type is currently deprecated and will be removed by December 23rd 2023. The recommended way to get the list of available sizes is using these APIs: [List all available virtual machine sizes in an availability set](https://docs&#46;microsoft&#46;com/rest/api/compute/availabilitysets/listavailablesizes), [List all available virtual machine sizes in a region]( https://docs&#46;microsoft&#46;com/rest/api/compute/resourceskus/list), [List all available virtual machine sizes for resizing](https://docs&#46;microsoft&#46;com/rest/api/compute/virtualmachines/listavailablesizes)&#46; For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/sizes). The available VM sizes depend on region and availability set.
     */
    @JvmName("hngwvdjbepiacayj")
    public suspend fun vmSize(`value`: Either<String, VirtualMachineSizeTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    /**
     * @param value Specifies the size of the virtual machine. The enum data type is currently deprecated and will be removed by December 23rd 2023. The recommended way to get the list of available sizes is using these APIs: [List all available virtual machine sizes in an availability set](https://docs&#46;microsoft&#46;com/rest/api/compute/availabilitysets/listavailablesizes), [List all available virtual machine sizes in a region]( https://docs&#46;microsoft&#46;com/rest/api/compute/resourceskus/list), [List all available virtual machine sizes for resizing](https://docs&#46;microsoft&#46;com/rest/api/compute/virtualmachines/listavailablesizes)&#46; For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/sizes). The available VM sizes depend on region and availability set.
     */
    @JvmName("fqdeuaigrtqvtvhc")
    public fun vmSize(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualMachineSizeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    /**
     * @param value Specifies the size of the virtual machine. The enum data type is currently deprecated and will be removed by December 23rd 2023. The recommended way to get the list of available sizes is using these APIs: [List all available virtual machine sizes in an availability set](https://docs&#46;microsoft&#46;com/rest/api/compute/availabilitysets/listavailablesizes), [List all available virtual machine sizes in a region]( https://docs&#46;microsoft&#46;com/rest/api/compute/resourceskus/list), [List all available virtual machine sizes for resizing](https://docs&#46;microsoft&#46;com/rest/api/compute/virtualmachines/listavailablesizes)&#46; For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/sizes). The available VM sizes depend on region and availability set.
     */
    @JvmName("rvyqrlhdqkyibxfk")
    public fun vmSize(`value`: VirtualMachineSizeTypes) {
        val toBeMapped = Either.ofRight<String, VirtualMachineSizeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    /**
     * @param value Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-07-01. This feature is still in preview mode and is not supported for VirtualMachineScaleSet. Please follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for more details.
     */
    @JvmName("bkncqdcimjfredob")
    public suspend fun vmSizeProperties(`value`: VMSizePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSizeProperties = mapped
    }

    /**
     * @param argument Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-07-01. This feature is still in preview mode and is not supported for VirtualMachineScaleSet. Please follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for more details.
     */
    @JvmName("iquakeefsoysqasa")
    public suspend fun vmSizeProperties(argument: suspend VMSizePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VMSizePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vmSizeProperties = mapped
    }

    internal fun build(): HardwareProfileArgs = HardwareProfileArgs(
        vmSize = vmSize,
        vmSizeProperties = vmSizeProperties,
    )
}
