@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.ImageStorageProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a storage profile.
 * @property dataDisks Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
 * @property osDisk Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
 * @property zoneResilient Specifies whether an image is zone resilient or not. Default is false. Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
 */
public data class ImageStorageProfileArgs(
    public val dataDisks: Output<List<ImageDataDiskArgs>>? = null,
    public val osDisk: Output<ImageOSDiskArgs>? = null,
    public val zoneResilient: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.ImageStorageProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.ImageStorageProfileArgs =
        com.pulumi.azurenative.compute.inputs.ImageStorageProfileArgs.builder()
            .dataDisks(
                dataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .osDisk(osDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .zoneResilient(zoneResilient?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageStorageProfileArgs].
 */
@PulumiTagMarker
public class ImageStorageProfileArgsBuilder internal constructor() {
    private var dataDisks: Output<List<ImageDataDiskArgs>>? = null

    private var osDisk: Output<ImageOSDiskArgs>? = null

    private var zoneResilient: Output<Boolean>? = null

    /**
     * @param value Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("wtnicpieucimtldn")
    public suspend fun dataDisks(`value`: Output<List<ImageDataDiskArgs>>) {
        this.dataDisks = value
    }

    @JvmName("vlltbywdrklkocue")
    public suspend fun dataDisks(vararg values: Output<ImageDataDiskArgs>) {
        this.dataDisks = Output.all(values.asList())
    }

    /**
     * @param values Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("uiypspenhtyjvatx")
    public suspend fun dataDisks(values: List<Output<ImageDataDiskArgs>>) {
        this.dataDisks = Output.all(values)
    }

    /**
     * @param value Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("ykrewnoukralyoee")
    public suspend fun osDisk(`value`: Output<ImageOSDiskArgs>) {
        this.osDisk = value
    }

    /**
     * @param value Specifies whether an image is zone resilient or not. Default is false. Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
     */
    @JvmName("urufodkjjihbtjot")
    public suspend fun zoneResilient(`value`: Output<Boolean>) {
        this.zoneResilient = value
    }

    /**
     * @param value Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("vshpdjpqxjrpvkok")
    public suspend fun dataDisks(`value`: List<ImageDataDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param argument Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("ckcnvkgapoopdsmt")
    public suspend fun dataDisks(argument: List<suspend ImageDataDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ImageDataDiskArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("ekderrxoqfqdudhk")
    public suspend fun dataDisks(vararg argument: suspend ImageDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ImageDataDiskArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("rntjxlmygkyeislv")
    public suspend fun dataDisks(argument: suspend ImageDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ImageDataDiskArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param values Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("xdbnoedculktrnds")
    public suspend fun dataDisks(vararg values: ImageDataDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param value Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("ibheshvrkxwpjxas")
    public suspend fun osDisk(`value`: ImageOSDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osDisk = mapped
    }

    /**
     * @param argument Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("bqdcksthpkeqsnnf")
    public suspend fun osDisk(argument: suspend ImageOSDiskArgsBuilder.() -> Unit) {
        val toBeMapped = ImageOSDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osDisk = mapped
    }

    /**
     * @param value Specifies whether an image is zone resilient or not. Default is false. Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
     */
    @JvmName("dwovdwwoqvhcsoum")
    public suspend fun zoneResilient(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneResilient = mapped
    }

    internal fun build(): ImageStorageProfileArgs = ImageStorageProfileArgs(
        dataDisks = dataDisks,
        osDisk = osDisk,
        zoneResilient = zoneResilient,
    )
}
