@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.KeyVaultKeyReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a reference to Key Vault Key
 * @property keyUrl The URL referencing a key encryption key in Key Vault.
 * @property sourceVault The relative URL of the Key Vault containing the key.
 */
public data class KeyVaultKeyReferenceArgs(
    public val keyUrl: Output<String>,
    public val sourceVault: Output<SubResourceArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.KeyVaultKeyReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.KeyVaultKeyReferenceArgs =
        com.pulumi.azurenative.compute.inputs.KeyVaultKeyReferenceArgs.builder()
            .keyUrl(keyUrl.applyValue({ args0 -> args0 }))
            .sourceVault(sourceVault.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KeyVaultKeyReferenceArgs].
 */
@PulumiTagMarker
public class KeyVaultKeyReferenceArgsBuilder internal constructor() {
    private var keyUrl: Output<String>? = null

    private var sourceVault: Output<SubResourceArgs>? = null

    /**
     * @param value The URL referencing a key encryption key in Key Vault.
     */
    @JvmName("xpisaamsynevbrbt")
    public suspend fun keyUrl(`value`: Output<String>) {
        this.keyUrl = value
    }

    /**
     * @param value The relative URL of the Key Vault containing the key.
     */
    @JvmName("oshgmynppxacjrfk")
    public suspend fun sourceVault(`value`: Output<SubResourceArgs>) {
        this.sourceVault = value
    }

    /**
     * @param value The URL referencing a key encryption key in Key Vault.
     */
    @JvmName("asllhajyqruhpvnc")
    public suspend fun keyUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyUrl = mapped
    }

    /**
     * @param value The relative URL of the Key Vault containing the key.
     */
    @JvmName("sohnptbqtyqchlij")
    public suspend fun sourceVault(`value`: SubResourceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceVault = mapped
    }

    /**
     * @param argument The relative URL of the Key Vault containing the key.
     */
    @JvmName("fjnghnkfbudmiqvv")
    public suspend fun sourceVault(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceVault = mapped
    }

    internal fun build(): KeyVaultKeyReferenceArgs = KeyVaultKeyReferenceArgs(
        keyUrl = keyUrl ?: throw PulumiNullFieldException("keyUrl"),
        sourceVault = sourceVault ?: throw PulumiNullFieldException("sourceVault"),
    )
}
